/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Terminal;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.FileSystemStore;
import io.intino.ness.datahubterminalplugin.ArtifactoryConnector;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.Safe;
import io.intino.ness.datahubterminalplugin.ontology.OntologyPublisher;
import io.intino.ness.datahubterminalplugin.terminal.TerminalPublisher;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class DataHubTerminalsPluginLauncher
extends PluginLauncher {
    private static final String MINIMUM_BPM_VERSION = "3.0.0";
    private static final String MINIMUM_TERMINAL_JMS_VERSION = "5.0.0";
    private static final String MINIMUM_EVENT_VERSION = "4.0.0";
    private static final String MINIMUM_INGESTION_VERSION = "5.0.0";
    private static final String MINIMUM_MASTER_VERSION = "2.0.0";
    private static final String MINIMUM_DATALAKE_VERSION = "6.0.0";
    private static final String MAX_DATALAKE_VERSION = "7.0.0";
    private static final String MAX_TERMINAL_JMS_VERSION = "6.0.0";
    private static final String MAX_INGESTION_VERSION = "6.0.0";
    private static final String MAX_EVENT_VERSION = "5.0.0";
    private boolean deleteTempDirOnPublish = true;
    private boolean publishTerminalsIfOntologyFails = false;

    public void run() {
        if (this.invokedPhase.ordinal() < 2) {
            return;
        }
        this.logger().println("Building " + this.configuration().artifact().name() + " terminals...");
        File tempDir = this.tempDirectory();
        this.run(tempDir);
    }

    public void run(File tempDir) {
        File resDirectory;
        if (this.logger() != null) {
            this.logger().println("Maven HOME: " + this.systemProperties.mavenHome.getAbsolutePath());
        }
        if ((resDirectory = this.resDirectory(this.moduleStructure().resDirectories)) == null) {
            return;
        }
        NessGraph graph = DataHubTerminalsPluginLauncher.loadGraph(resDirectory);
        if (this.hasErrors(graph)) {
            return;
        }
        Map<String, String> versions = this.versions();
        if (!this.publishOntology(graph, versions, tempDir) && !this.publishTerminalsIfOntologyFails) {
            return;
        }
        this.publishTerminals(graph, versions, tempDir);
        this.logger().println("Finished generation of terminals!");
    }

    private Map<String, String> versions() {
        return Map.of("terminal-jms", this.terminalJmsVersion(), "ingestion", this.ingestionVersion(), "bpm", this.bpmVersion(), "master", this.masterVersion(), "event", this.eventVersion(), "datalake", this.datalakeVersion());
    }

    private boolean publishOntology(NessGraph graph, Map<String, String> versions, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            published.set(new OntologyPublisher(new File(tempDir, "ontology"), graph, this.configuration(), this.moduleStructure(), versions, this.systemProperties(), this.invokedPhase, this.logger(), this.notifier()).publish() & published.get());
            if (published.get() && this.notifier() != null) {
                this.notifier().notify("Ontology " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), "ontology", this.configuration().artifact().version()));
            }
            this.handleTempDir(tempDir, published);
            return published.get();
        }
        catch (Throwable e) {
            this.logger().println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void publishTerminals(NessGraph nessGraph, Map<String, String> versions, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            nessGraph.terminalList().parallelStream().forEach(terminal -> {
                published.set(new TerminalPublisher(new File(tempDir, terminal.name$()), (Terminal)terminal, this.configuration(), versions, this.systemProperties(), this.invokedPhase, this.logger(), this.notifier()).publish() & published.get());
                if (published.get() && this.notifier() != null) {
                    this.notifier().notify("Terminal " + terminal.name$() + " " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), this.terminalNameArtifact((Terminal)terminal), this.configuration().artifact().version()));
                }
            });
            this.handleTempDir(tempDir, published);
        }
        catch (Throwable e) {
            this.logger().println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleTempDir(File tempDir, AtomicBoolean published) throws IOException {
        if (published.get() && this.deleteTempDirOnPublish) {
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    private static NessGraph loadGraph(File resDirectory) {
        String[] stashes = (String[])Arrays.stream(Objects.requireNonNull(resDirectory.listFiles(f -> f.getName().endsWith(".stash")))).map(f -> f.getName().replace(".stash", "")).toArray(String[]::new);
        NessGraph graph = (NessGraph)new Graph((Store)new FileSystemStore(resDirectory)).loadStashes(stashes).as(NessGraph.class);
        if (graph.messageList(t -> t.name$().equals("Session")).findAny().isEmpty()) {
            graph.create("Session", "Session").message();
        }
        return graph;
    }

    private boolean hasErrors(NessGraph graph) {
        if (graph == null) {
            this.notifier().notifyError("Couldn't load graph. Please recompile module");
            return true;
        }
        if (DataHubTerminalsPluginLauncher.safe(() -> this.configuration().artifact().distribution()) != null && DataHubTerminalsPluginLauncher.safe(() -> this.configuration().artifact().distribution().snapshot()) == null && this.isSnapshotVersion()) {
            this.notifier().notifyError("Snapshot distribution repository not found");
            return true;
        }
        return false;
    }

    private File resDirectory(List<File> directories) {
        File resDirectory = directories.stream().filter(d -> {
            File[] files = d.getAbsoluteFile().listFiles(f -> f.getName().endsWith(".stash"));
            return files != null && files.length > 0;
        }).findFirst().orElse(null);
        if (resDirectory == null) {
            this.notifier().notifyError("Stashes not found. Please compile module");
            return null;
        }
        return resDirectory;
    }

    private String terminalNameArtifact(Terminal terminal) {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)terminal.name$()).toString());
    }

    private String terminalJmsVersion() {
        List<String> terminalVersions = ArtifactoryConnector.terminalVersions();
        Collections.reverse(terminalVersions);
        return terminalVersions.isEmpty() ? "5.0.0" : this.suitableTerminalVersion(terminalVersions);
    }

    private String ingestionVersion() {
        List<String> versions = ArtifactoryConnector.ingestionVersions();
        Collections.reverse(versions);
        return versions.isEmpty() ? "5.0.0" : this.suitableIngestionVersion(versions);
    }

    private String masterVersion() {
        List<String> versions = ArtifactoryConnector.masterVersions();
        Collections.reverse(versions);
        return versions.isEmpty() ? MINIMUM_MASTER_VERSION : this.suitableIngestionVersion(versions);
    }

    private String eventVersion() {
        List<String> versions = ArtifactoryConnector.eventVersions();
        Collections.reverse(versions);
        return versions.isEmpty() ? MINIMUM_EVENT_VERSION : this.suitableEventVersion(versions);
    }

    private String datalakeVersion() {
        List<String> versions = ArtifactoryConnector.datalakeVersions();
        Collections.reverse(versions);
        return versions.isEmpty() ? "6.0.0" : this.suitableDatalakeVersion(versions);
    }

    private String suitableTerminalVersion(List<String> versions) {
        return versions.stream().filter(version -> version.compareTo("6.0.0") < 0).findFirst().orElse("5.0.0");
    }

    private String suitableIngestionVersion(List<String> versions) {
        return versions.stream().filter(v -> v.compareTo("6.0.0") < 0).findFirst().orElse("5.0.0");
    }

    private String suitableEventVersion(List<String> versions) {
        return versions.stream().filter(v -> v.compareTo("5.0.0") < 0).findFirst().orElse(MINIMUM_EVENT_VERSION);
    }

    private String suitableDatalakeVersion(List<String> versions) {
        return versions.stream().filter(v -> v.compareTo(MAX_DATALAKE_VERSION) < 0).findFirst().orElse(MINIMUM_EVENT_VERSION);
    }

    private boolean isSnapshotVersion() {
        return this.configuration().artifact().version().contains("SNAPSHOT");
    }

    private String bpmVersion() {
        List<String> bpmVersions = ArtifactoryConnector.bpmVersions();
        return bpmVersions.isEmpty() ? MINIMUM_BPM_VERSION : bpmVersions.get(bpmVersions.size() - 1);
    }

    private String participle() {
        return this.invokedPhase == PluginLauncher.Phase.INSTALL ? "installed" : "distributed";
    }

    private String accessorDependency(String groupId, String artifactId, String version) {
        return "<dependency>\n    <groupId>" + groupId.toLowerCase() + "</groupId>\n    <artifactId>" + artifactId.toLowerCase() + "</artifactId>\n    <version>" + version + "</version>\n</dependency>";
    }

    private File tempDirectory() {
        try {
            return Files.createTempDirectory("_temp", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("");
        }
    }

    public static <T> T safe(Safe.Wrapper<T> wrapper) {
        try {
            return wrapper.value();
        }
        catch (Throwable var2) {
            return null;
        }
    }

    public void deleteTempDirOnPublish(boolean deleteTempDirOnPublish) {
        this.deleteTempDirOnPublish = deleteTempDirOnPublish;
    }

    public void publishTerminalsIfOntologyFails(boolean publishTerminalsIfOntologyFails) {
        this.publishTerminalsIfOntologyFails = publishTerminalsIfOntologyFails;
    }
}

