/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DatamartTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"datamart", "interface"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.concurrent.ConcurrentHashMap;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.Instant;\nimport java.util.Optional;\n\nimport io.intino.ness.master.Datamart;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.reflection.*;\n\npublic interface ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart extends Datamart {\n\n\tDatamartDefinition definition = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.DatamartDefinitionInternal();\n\n\tList<String> listSnapshots();\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart snapshot(String timetag);\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("Stream<TimelineNode> timelines(String id);")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timeline", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("Stream<ReelNode> reels(String id);")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reel", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tDictionary dictionary(String name);\n\n\tclass Entities {\n\n\t\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart;\n\t\tprivate final Map<EntityDefinition, Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> entitiesByType;\n\n\t\tpublic Entities(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart) {\n\t\t\tthis.datamart = datamart;\n\t\t\tthis.entitiesByType = new ConcurrentHashMap<>();\n\t\t\tdatamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> entitiesByType.put(entity, new ConcurrentHashMap<>()));\n\t\t}\n\n\t\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart() {\n\t\t\treturn datamart;\n\t\t}\n\n    \tpublic int size() {\n    \t\treturn entitiesByType.values().stream().mapToInt(Map::size).sum();\n    \t}\n\n    \tpublic boolean contains(String id) {\n    \t\treturn get(id) != null;\n    \t}\n\n    \tpublic boolean contains(EntityDefinition definition, String id) {\n    \t\treturn get(definition, id) != null;\n    \t}\n\n    \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity get(String id) {\n    \t\treturn mapOf(id).map(map -> map.get(id)).orElse(null);\n    \t}\n\n    \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity getDescendant(EntityDefinition definition, String id) {\n    \t\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity entity = get(definition, id);\n    \t\treturn entity != null ? entity : definition.descendants().stream()\n    \t\t\t.filter(descendant -> !descendant.isAbstract())\n    \t\t\t.map(descendant -> get(descendant, id))\n    \t\t\t.filter(java.util.Objects::nonNull).findFirst().orElse(null);\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity get(EntityDefinition type, String id) {\n    \t\treturn entitiesByType.containsKey(type) ? entitiesByType.get(type).get(id) : null;\n        }\n\n    \tpublic void add(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity entity) {\n    \t\tentitiesByType.get(entity.getDefinition()).put(entity.id(), entity);\n    \t}\n\n    \tpublic void remove(String id) {\n    \t\tmapOf(id).ifPresent(map -> map.remove(id));\n    \t}\n\n    \tpublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> stream() {\n    \t\treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n    \t}\n\n    \tpublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> stream(EntityDefinition type) {\n    \t\treturn entitiesByType.containsKey(type) ? entitiesByType.get(type).values().stream() : Stream.empty();\n    \t}\n\n    \tpublic Stream<Entity> streamGeneric() {\n        \treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n        }\n\n    \tprivate java.util.Optional<Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> mapOf(String id) {\n    \t\treturn entitiesByType.values().stream().filter(map -> map.containsKey(id)).findFirst();\n    \t}\n    }\n\n    interface ChronosNode {\n    \t/**<p>Returns the id of the chronos object</p>*/\n    \tString id();\n    \t/**<p>Returns the type of the chronos object, as defined in the model</p>*/\n    \tString type();\n    \t/**Clears this node's internal cache, if any, and notifies the datamart to unload this node from memory.*/\n    \tvoid dispose();\n    }\n\n    interface TimelineNode extends ChronosNode {\n    \tjava.util.concurrent.atomic.AtomicBoolean AlwaysDownloadFromDatahub = new java.util.concurrent.atomic.AtomicBoolean();\n\t\tboolean exists();\n\t\tio.intino.sumus.chronos.TimelineStore.TimeModel timeModel() throws TimelineNotAvailableException;\n\t\tio.intino.sumus.chronos.TimelineStore.SensorModel sensorModel() throws TimelineNotAvailableException;\n\t\tInstant first() throws TimelineNotAvailableException;\n\t\tInstant last() throws TimelineNotAvailableException;\n    \tio.intino.sumus.chronos.Timeline get() throws TimelineNotAvailableException;\n\n    \tvoid setEventListener(EventListener listener);\n\n \t\tinterface EventListener {\n    \t\tvoid onEventReceived(TimelineNode node, io.intino.alexandria.event.Event event);\n    \t}\n\n    \tstatic TimelineNode empty() {\n    \t\treturn new TimelineNode() {\n                public String id(){return \"\";}\n                public String type(){return \"\";}\n                public void dispose(){}\n            \tpublic boolean exists() {return false;}\n            \tpublic io.intino.sumus.chronos.TimelineStore.TimeModel timeModel() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.TimelineStore.SensorModel sensorModel() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic Instant first() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic Instant last() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Timeline get() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic void setEventListener(EventListener listener) {}\n    \t\t};\n    \t}\n    }\n\n    interface ReelNode extends ChronosNode {\n\t\tboolean exists();\n    \tjava.time.Instant start() throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.State stateOf(String signal) throws ReelNotAvailableException;\n\t\tdefault List<io.intino.sumus.chronos.State> stateOf(List<String> signals) throws ReelNotAvailableException {return signals.isEmpty() ? java.util.Collections.emptyList() : stateOf(signals.stream());}\n\t\tList<io.intino.sumus.chronos.State> stateOf(Stream<String> signals) throws ReelNotAvailableException;\n\t\tio.intino.sumus.chronos.Shot lastShotOf(String signal) throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots() throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots(String group) throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots(io.intino.sumus.chronos.Group group) throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.Reel get(io.intino.sumus.chronos.Period period) throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.Reel get(java.time.Instant from, java.time.Instant to, io.intino.sumus.chronos.Period period) throws ReelNotAvailableException;\n    \tvoid setEventListener(EventListener listener);\n\n \t\tinterface EventListener {\n    \t\tvoid onEventReceived(ReelNode node, io.intino.alexandria.event.Event event);\n    \t}\n\n    \tstatic ReelNode empty() {\n    \t\treturn new ReelNode() {\n    \t        public String id(){return \"\";}\n                public String type(){return \"\";}\n                public void dispose(){}\n    \t\t\tpublic boolean exists() {return false;}\n            \tpublic java.time.Instant start() throws ReelNotAvailableException {throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.State stateOf(String signal) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic List<io.intino.sumus.chronos.State> stateOf(Stream<String> signals) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Shot lastShotOf(String signal) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots() throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots(String group) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots(io.intino.sumus.chronos.Group group) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Reel get(io.intino.sumus.chronos.Period period) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Reel get(java.time.Instant from, java.time.Instant to, io.intino.sumus.chronos.Period period) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic void setEventListener(EventListener listener) {}\n    \t\t};\n    \t}\n    }\n\n\tfinal class DatamartDefinitionInternal implements DatamartDefinition {\n\t\tprivate DatamartDefinition definition;\n\t\tprivate DatamartDefinitionInternal() {}\n\t\t@Override\n\t\tpublic String name() {return definition().name();}\n\t\t@Override\n\t\tpublic Datamart.Scale scale() {return definition().scale();}\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {return definition().entities();}\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {return definition().structs();}\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String fullName) {\n        \treturn definition().entity(fullName);\n        }\n        @Override\n        public Optional<StructDefinition> struct(String fullName) {\n        \treturn definition().struct(fullName);\n        }\n\t\tprivate DatamartDefinition definition() {\n\t\t\tif (definition == null) throw new IllegalStateException(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart is not initialized\");\n\t\t\treturn definition;\n\t\t}\n\t}\n\n\tpublic static class DatahubRequestException extends Exception {\n\t\tpublic DatahubRequestException() {}\n\t\tpublic DatahubRequestException(String message) {super(message);}\n\t\tpublic DatahubRequestException(String message, Throwable cause) {super(message, cause);}\n\t}\n\n\tpublic static class TimelineNotAvailableException extends Exception {\n    \tpublic TimelineNotAvailableException() {}\n    \tpublic TimelineNotAvailableException(String message) {super(message);}\n    \tpublic TimelineNotAvailableException(Throwable e) {super(e);}\n    }\n\n\tpublic static class ReelNotAvailableException extends Exception {\n    \tpublic ReelNotAvailableException() {}\n    \tpublic ReelNotAvailableException(String message) {super(message);}\n    \tpublic ReelNotAvailableException(Throwable e) {super(e);}\n    }\n}")}), this.rule().condition(this.allTypes(new String[]{"datamart", "message", "impl"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.terminal.Connector;\nimport io.intino.ness.master.reflection.*;\nimport io.intino.ness.master.model.Entity;\n\nimport org.apache.activemq.command.ActiveMQTextMessage;\n\nimport java.io.File;\nimport java.util.*;\nimport java.util.function.BiFunction;\nimport java.util.concurrent.atomic.AtomicBoolean;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.LocalDate;\nimport java.time.LocalDateTime;\nimport java.time.Instant;\n\nimport ")}).output(new Rule.Output[]{this.mark("ontologypackage", new String[0])}).output(new Rule.Output[]{this.literal(".*;\n\nimport static java.util.Objects.requireNonNull;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl implements ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart {\n\n\tprivate static final String DATAHUB_MESSAGE_TOPIC = \"service.ness.datamarts\";\n\tprivate static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition definition = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition();\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("private static final Set<String> TIMELINE_EVENTS = Set.of(")}).output(new Rule.Output[]{this.mark("timelineEvents", new String[0])}).output(new Rule.Output[]{this.literal(");")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("private static final Set<String> REEL_EVENTS = Set.of(")}).output(new Rule.Output[]{this.mark("reelEvents", new String[0])}).output(new Rule.Output[]{this.literal(");")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate final Connector connector;\n\tprivate final ")}).output(new Rule.Output[]{this.mark("terminal", new String[0])}).output(new Rule.Output[]{this.literal(".DatamartsRetryConfig retryConfig;\n\tprivate final AtomicBoolean initialized = new AtomicBoolean(false);\n\tprivate final List<EntityListener> entityListeners = new ArrayList<>();\n\tprivate final Map<String, List<MasterMounter>> mounters = new HashMap<>();\n\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.Entities entities;\n\tprivate Instant ts;\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private boolean hasLocalAccessToTimelines;")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private final Map<String, TimelineNodeImpl> timelines = new java.util.concurrent.ConcurrentHashMap<>();")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("private boolean hasLocalAccessToReels;")})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("private final Map<String, ReelNodeImpl> reels = new java.util.concurrent.ConcurrentHashMap<>();")})}).output(new Rule.Output[]{this.literal("\n\tprivate volatile DictionaryImpl dictionary = new DictionaryImpl();\n\tprivate final Map<Class<?>, BiFunction<EntityDefinition, String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityReference>> entityReferenceFactory = createEntityReferenceFactory();\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(Connector connector, ")}).output(new Rule.Output[]{this.mark("terminal", new String[0])}).output(new Rule.Output[]{this.literal(".DatamartsRetryConfig retryConfig) {\n\t\tthis.connector = requireNonNull(connector);\n\t\tthis.retryConfig = requireNonNull(retryConfig);\n\t\tthis.entities = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.Entities(this);\n\t\tinitMounters();\n\t}\n\n\tpublic synchronized ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl init(String datamartSourceSelector) {\n\t\ttry {\n\t\t\tif (!initialized.compareAndSet(false, true)) return this;\n\t\t\tdownloadDatamartFromDatahub(datamartSourceSelector);\n\t\t\tLogger.info(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart (\" + (snapshotTimetag().isEmpty() ? \"\" : \"snapshot \" + snapshotTimetag() + \", \")  + connector.clientId() + \") initialized successfully.\");\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart failed to start because a \" + e.getClass().getName() + \" occurred: \" + e.getMessage());\n\t\t}\n\t\treturn this;\n\t}\n\n\t@Override\n\tpublic int size() {\n\t\treturn entities.size();\n\t}\n\n\t@Override\n\t@SuppressWarnings(\"unchecked\")\n\tpublic <T extends Entity> T get(String id) {\n\t\tMasterEntity entity = entities.get(id);\n\t\tif (entity == null) return null;\n\t\tEntityDefinition definition = entity.getDefinition();\n\t\tClass<?> javaClass = definition.javaClass();\n\t\treturn (T) entityReferenceFactory.getOrDefault(javaClass, (BiFunction<EntityDefinition, String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityReference>) ((a,b) -> null)).apply(definition, id);\n\t}\n\n\t@Override\n\tpublic Stream<Entity> entities() {\n\t\treturn entities.streamGeneric();\n\t}\n\n\t@Override\n\tpublic void addEntityListener(EntityListener listener) {\n\t\tif (listener == null) throw new NullPointerException(\"EntityListener cannot be null\");\n\t\tentityListeners.add(listener);\n\t}\n\n\t@Override\n\tpublic DatamartDefinition getDefinition() {\n\t\treturn definition;\n\t}\n\n\t@Override\n    public List<String> listSnapshots() {\n    \ttry {\n    \t\tjavax.jms.Message message = requestResponseFromDatahub(\"listSnapshots\", listSnapshotsRequest());\n    \t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((javax.jms.TextMessage) message).getText());\n    \t\treturn handleListSnapshotsResponse(message);\n    \t} catch (Exception e) {\n    \t\tLogger.error(\"Could not download list of available snapshots: \" + e.getMessage(), e);\n    \t\treturn java.util.Collections.emptyList();\n    \t}\n    }\n\n    private javax.jms.Message listSnapshotsRequest() throws Exception {\n    \tActiveMQTextMessage message = new ActiveMQTextMessage();\n    \tmessage.setText(\"datamart=\" + name() + \";operation=snapshots\");\n    \treturn message;\n    }\n\n    private List<String> handleListSnapshotsResponse(javax.jms.Message message) throws Exception {\n    \treturn java.util.Arrays.stream(((javax.jms.TextMessage) message).getText().split(\",\")).collect(Collectors.toList());\n    }\n\n    @Override\n    public synchronized ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart snapshot(String timetag) {\n    \tif (timetag == null) return this;\n    \treturn new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(connector, retryConfig) {\n    \t\t@Override\n    \t\tprotected String snapshotTimetag() {\n    \t\t\treturn timetag;\n    \t\t}\n    \t\t@Override\n    \t\tpublic synchronized MasterDatamart snapshot(String timetag) {\n    \t\t\tthrow new java.lang.UnsupportedOperationException(\"Cannot request snapshots to snapshot instances of a datamart\");\n    \t\t}\n    \t}.init(null);\n    }\n\n    public Instant ts() {\n    \treturn this.ts;\n    }\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[]{"timelinesByIdMethod"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timeline", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[]{"reelsByIdMethod"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reel", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t@Override\n\tpublic Dictionary dictionary() {\n\t\treturn dictionary;\n\t}\n\n\t@Override\n    public Dictionary dictionary(String name) {\n    \tif (name == null) name = \"\";\n    \tif (dictionary.name.equals(name)) return dictionary;\n    \tloadDictionaryFromDatahub(name);\n    \treturn dictionary;\n    }\n\n\tprivate void downloadDatamartFromDatahub(String datamartSourceSelector) throws DatahubRequestException {\n\t\tif (connector instanceof io.intino.alexandria.terminal.StubConnector) return;\n\t\tLogger.debug(\"Downloading datamart from datahub...\");\n\t\tlong start = java.lang.System.currentTimeMillis();\n\n\t\tLogger.debug(\"Downloading entities...\");\n\t\tint[] eventCount = new int[1];\n\t\tloadEntitiesFromEvents(downloadEntities(eventCount, datamartSourceSelector), eventCount);\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("loadTimelinesFromDatahub();")})}).output(new Rule.Output[]{this.literal("\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("loadReelsFromDatahub();")})}).output(new Rule.Output[]{this.literal("\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasDictionary", new String[0])}).output(new Rule.Output[]{this.literal("loadDictionaryFromDatahub(\"\");")})}).output(new Rule.Output[]{this.literal("\n\n\t\tlong time = java.lang.System.currentTimeMillis() - start;\n\t\tLogger.debug(\"Datamart downloaded from datahub after \" + time + \" ms\");\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[]{"loadTimelinesFromDatahubMethod"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[]{"loadReelsFromDatahubMethod"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasDictionary", new String[]{"loadDictionaryFromDatahubMethod"})})}).output(new Rule.Output[]{this.literal("\n\n\tprivate Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) throws DatahubRequestException {\n\t\ttry {\n\t\t\tjavax.jms.Message message = requestResponseFromDatahub(\"downloadEvents\", downloadEntitiesRequest(datamartSourceSelector));\n\t\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((javax.jms.TextMessage) message).getText());\n\t\t\treturn handleDownloadResponse(message, eventCount);\n\t\t} catch (NullPointerException e) {\n\t\t\tthrow new DatahubRequestException(\"Could not download datamart: no response from datahub.\");\n\t\t} catch(DatahubRequestException e) {\n\t\t\tthrow e;\n\t\t} catch (Exception e) {\n\t\t\tthrow new DatahubRequestException(\"Could not download datamart: \" + e.getMessage());\n\t\t}\n\t}\n\n\tprivate javax.jms.Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {\n\t\tActiveMQTextMessage message = new ActiveMQTextMessage();\n\t\tmessage.setText(\"datamart=\" + name() +\n\t\t\t\";operation=entities\" +\n\t\t\t(snapshotTimetag().isEmpty() ? \"\" : \";timetag=\" + snapshotTimetag()) +\n\t\t\t(datamartSourceSelector == null ? \"\" : \";sourceSelector=\" + datamartSourceSelector)\n\t\t);\n\t\treturn message;\n\t}\n\n\tprotected String snapshotTimetag() {\n\t\treturn \"\";\n\t}\n\n\tprivate Stream<Event> handleDownloadResponse(javax.jms.Message message, int[] eventCount) throws Exception {\n\t\tjavax.jms.BytesMessage m = (javax.jms.BytesMessage) message;\n\t\teventCount[0] = m.getIntProperty(\"size\");\n\t\tint size = m.getIntProperty(\"size\");\n\t\tbyte[] bytes = new byte[size];\n\t\tm.readBytes(bytes, size);\n\t\treturn io.intino.alexandria.zim.ZimStream.of(new java.io.ByteArrayInputStream(bytes)).map(io.intino.alexandria.event.message.MessageEvent::new);\n\t}\n\n\tprivate void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {\n\t\tevents.forEach(this::mount);\n\t}\n\n\tpublic synchronized void mount(Event event) {\n\t\tif (event == null) return;\n\t\tthis.ts = event.ts();\n\t\tmountEntities(event);\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("mountTimelines(event);")})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("mountReels(event);")})}).output(new Rule.Output[]{this.literal("\n\t\t// TODO: update dictionary when resource event arrives\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("private void mountReels(Event event) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tif (!REEL_EVENTS.contains(event.type())) return;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString id = sensorParameter(event.ss());")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString type = event.type();")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString key = id + \":\" + type;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tif (!reels.containsKey(key)) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\tReelNodeImpl node = new ReelNodeImpl(id, type, sourcesOfReel(type), null);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\treels.put(key, node);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t}")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\treels.values().forEach(reel -> reel.notifyEvent(event));")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("private void mountTimelines(Event event) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tif (!TIMELINE_EVENTS.contains(event.type())) return;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString id = sensorParameter(event.ss());")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tString type = event.type();")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tTimelineNodeImpl node = timelines.computeIfAbsent(id + \":\" + type, k -> new TimelineNodeImpl(id, type, sourcesOfTimeline(type), null));")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tnode.notifyEvent(event);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate static String sensorParameter(String ss) {\n\t\tif (ss.contains(\"?\")) {\n\t\t\ttry {\n\t\t\t\tMap<String, String> map = Arrays.stream(ss.substring(ss.indexOf(\"?\") + 1).split(\";\"))\n\t\t\t\t\t\t.map(p -> p.split(\"=\"))\n\t\t\t\t\t\t.collect(Collectors.toMap(f -> f[0], f -> f[1]));\n\t\t\t\tif (map.containsKey(\"sensor\")) return map.get(\"sensor\");\n\t\t\t\telse ss.substring(0, ss.indexOf(\"?\"));\n\t\t\t} catch (Exception e) {\n\t\t\t\tLogger.error(e);\n\t\t\t}\n\t\t}\n\t\treturn ss;\n\t}\n\n\tprivate void mountEntities(Event event) {\n\t\ttry {\n\t\t\tjava.util.Optional.ofNullable(this.mounters.get(event.type())).ifPresent(mounters -> mounters.forEach(mounter -> mounter.mount(event)));\n\t\t} catch (Exception e) {\n\t\t\tLogger.error(\"Failed to mount event of type \" + event.type() + \": \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\tprivate void initMounters() {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"registerMounter"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tprivate static int availableThreads() {\n\t\treturn Runtime.getRuntime().availableProcessors();\n\t}\n\n\tprivate javax.jms.Message requestResponseFromDatahub(String requestName, javax.jms.Message request) throws DatahubRequestException {\n    \tlong timeout = retryConfig.initialTimeoutAmount;\n    \tfor(int i = 0; i < retryConfig.maxAttempts; i++) {\n    \t\tjavax.jms.Message message = connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, retryConfig.timeoutUnit);\n    \t\tif (message != null) return message;\n    \t\tif (i < retryConfig.maxAttempts - 1) Logger.warn(\"(\"+(i+1)+\") Datahub did not respond after \" + timeout + \" \" + retryConfig.timeoutUnit + \" to the request '\" + requestName + \"'. Trying again...\");\n    \t\ttimeout *= retryConfig.timeoutMultiplier;\n    \t}\n    \tthrow new DatahubRequestException(\"Datahub did not respond to the request '\" + requestName + \"' after \" + retryConfig.maxAttempts);\n    }\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timelineNode", new String[]{"nodeImpl"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reelNode", new String[]{"nodeImpl"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("dictionary", new String[]{"dictionaryImpl"})})}).output(new Rule.Output[]{this.literal("\n\n\tprivate static Set<String> sourcesOfTimeline(String type) {\n    \treturn switch(type) {\n    \t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timeline", new String[]{"sourcesSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\tdefault -> java.util.Collections.emptySet();\n    \t};\n    }\n\n\tprivate static Set<String> sourcesOfReel(String type) {\n    \treturn switch(type) {\n    \t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reel", new String[]{"sourcesSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\tdefault -> java.util.Collections.emptySet();\n    \t};\n    }\n\n    Map<Class<?>, BiFunction<EntityDefinition, String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityReference>> createEntityReferenceFactory() {\n    \tMap<Class<?>, BiFunction<EntityDefinition, String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityReference>> map = new HashMap<>();\n    \t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"referenceFactoryEntry"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n    \treturn map;\n    }\n\n\t// WARNING: extremely compacted and ugly code ahead... continue at your own discretion.\n\tpublic static final class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition implements DatamartDefinition {\n\n\t\t@Override\n\t\tpublic String name() {\n\t\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t\t}\n\n\t\t@Override\n\t\tpublic Scale scale() {\n\t\t\treturn Scale.")}).output(new Rule.Output[]{this.mark("scale", new String[0])}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {\n\t\t\treturn new Query<EntityDefinition>(List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {\n\t\t\treturn new Query<StructDefinition>(List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String name) {\n\t\t\tswitch(name) {\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"defSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t}\n\t\t\treturn Optional.empty();\n\t\t}\n\n\t\t@Override\n    \tpublic Optional<StructDefinition> struct(String name) {\n    \t\tswitch(name) {\n    \t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"defSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\t}\n    \t\treturn Optional.empty();\n    \t}\n\n\t\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition datamart() {\n\t\t\treturn this;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"declareDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"declareDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tstatic {\n\t\ttry {\n\t\t\tObject ref = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.class.getDeclaredField(\"definition\").get(null);\n\t\t\tjava.lang.reflect.Field field = ref.getClass().getDeclaredField(\"definition\");\n\t\t\tfield.setAccessible(true);\n\t\t\tfield.set(ref, definition);\n\t\t\tfield.setAccessible(false);\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"Could not set ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.definition field\");\n\t\t}\n\t}\n}")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.not(this.type("abstract")), this.trigger("referencefactoryentry")}).output(new Rule.Output[]{this.literal("map.put(")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class, (definition, id) -> new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(() -> entities.get(definition, id)));")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("definition")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("defswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return Optional.of(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition);")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("defswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return Optional.of(")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition);")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("declaredefinition")}).output(new Rule.Output[]{this.literal("public final EntityDefinition ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition = new EntityDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")}).output(new Rule.Output[]{this.mark("fullName", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic boolean isAbstract() {return ")}).output(new Rule.Output[]{this.mark("isAbstract", new String[0])}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<AttributeDefinition> declaredAttributes() {\treturn declaredAttributes;}\n\tpublic Optional<EntityDefinition> parent() {return ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.of(")}).output(new Rule.Output[]{this.mark("parent", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.empty()")}))}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<EntityDefinition> ancestors() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("ancestor", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic List<EntityDefinition> descendants() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("descendant", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>();\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasNoParents", new String[]{"addIdAndEnabledAttributes"})})}).output(new Rule.Output[]{this.literal("\n    \t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"addDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \treturn Collections.synchronizedList(list);\n\t}\n\tpublic boolean equals(Object other) {\n\t\tif (other == null || other.getClass() != getClass()) return false;\n\t\treturn fullName().equals(((EntityDefinition)other).fullName());\n\t}\n\tpublic int hashCode() {return fullName().hashCode();}\n\tpublic String toString() {return fullName();}\n};")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("declaredefinition")}).output(new Rule.Output[]{this.literal("public final StructDefinition ")}).output(new Rule.Output[]{this.mark("fullName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition = new StructDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")}).output(new Rule.Output[]{this.mark("fullName", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic List<AttributeDefinition> declaredAttributes() {return declaredAttributes;}\n\tpublic Optional<StructDefinition> parent() {return ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.of(")}).output(new Rule.Output[]{this.mark("parent", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition)")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.empty()")}))}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<StructDefinition> ancestors() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("ancestor", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic List<StructDefinition> descendants() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("descendant", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>(")}).output(new Rule.Output[]{this.mark("numAttributes", new String[0])}).output(new Rule.Output[]{this.literal(");\n    \t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"addDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \treturn Collections.synchronizedList(list);\n\t}\n\tpublic boolean equals(Object other) {\n    \tif (other == null || other.getClass() != getClass()) return false;\n    \treturn fullName().equals(((StructDefinition)other).fullName());\n    }\n    public int hashCode() {return fullName().hashCode();}\n    public String toString() {return fullName();}\n};")}), this.rule().condition(this.type("subclass"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.anyTypes(new String[]{"descendant", "ancestor"}), this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.anyTypes(new String[]{"descendant", "ancestor"}), this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("StructDefinition")}), this.rule().condition(this.trigger("addidandenabledattributes"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"id\";}\n\tpublic Class<?> type() {return String.class;}\n\tpublic String toString() {return name();}\n});\nlist.add(new AttributeDefinition() {\n\tpublic String name() {return \"enabled\";}\n\tpublic Class<?> type() {return Boolean.class;}\n\tpublic String toString() {return name();}\n});")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("inherited")), this.type("collection"), this.trigger("adddefinition")}).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\";}\n\tpublic Class<?> type() {return ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\tpublic String toString() {return name();}\n\tpublic List<ParameterDefinition> parameters() {\n\t\treturn List.of(new ParameterDefinition() {\n\t\t\tpublic Optional<ConceptDefinition<?>> asConceptDefinition() {return ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"asConceptDefinition"})}).output(new Rule.Output[]{this.literal(";}\n\t\t\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("parameterType", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\t\t\tpublic String toString() {return javaClass().getSimpleName();}\n\t\t});\n\t}\n});")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("inherited")), this.trigger("adddefinition")}).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\";}\n\tpublic Class<?> type() {return ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\tpublic String toString() {return name();}\n});")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.type("entity"), this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.of(datamart().")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.type("struct"), this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.of(datamart().")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition)")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.empty()")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.type("entity"), this.trigger("registermounter")}).output(new Rule.Output[]{this.literal("mounters.computeIfAbsent(\"")}).output(new Rule.Output[]{this.mark("event", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("\", type -> new ArrayList<>(1)).add(new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mounters.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Mounter(entities, entityListeners));")}), this.rule().condition(this.type("subclasstop"), new Rule.Condition[]{this.trigger("getallstream")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.type("timeline"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic TimelineNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(String id) {\n\tif (hasLocalAccessToTimelines) return timelines.containsKey(id.replace(\":\", \"-\") + \":")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\") ? timelines.get(id.replace(\":\", \"-\") + \":")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\") : TimelineNode.empty();\n\treturn timelines.computeIfAbsent(id.replace(\":\", \"-\") + \":")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", theId -> new TimelineNodeImpl(id, \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", Set.of(")}).output(new Rule.Output[]{this.mark("sources", new String[0])}).output(new Rule.Output[]{this.literal(")));\n}")}), this.rule().condition(this.type("reel"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ReelNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(String id) {\n\tif (hasLocalAccessToReels) return reels.containsKey(id.replace(\":\", \"-\") + \":")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\") ? reels.get(id.replace(\":\", \"-\") + \":")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\") : ReelNode.empty();\n\treturn reels.computeIfAbsent(id.replace(\":\", \"-\") + \":")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", theId -> new ReelNodeImpl(id, \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", Set.of(")}).output(new Rule.Output[]{this.mark("sources", new String[0])}).output(new Rule.Output[]{this.literal(")));\n}\n\n@Override\npublic Stream<ReelNode> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Reels() {\n\tStream stream = reels.values().stream().filter(r -> r.type.equals(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")).toList().stream();\n\treturn stream;\n}")}), this.rule().condition(this.trigger("timelinesbyidmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic Stream<TimelineNode> timelines(String id) {\n\tStream stream = timelines.values().stream().filter(t -> t.id.equals(id)).toList().stream();\n\treturn stream;\n}")}), this.rule().condition(this.trigger("reelsbyidmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic Stream<ReelNode> reels(String id) {\n\tStream stream = reels.values().stream().filter(r -> r.id.equals(id)).toList().stream();\n\treturn stream;\n}")}), this.rule().condition(this.trigger("sourcesswitchcase"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\" -> Set.of(")}).output(new Rule.Output[]{this.mark("sources", new String[0])}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.type("abstract"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\tif (id == null) return null;\n\tvar entity = entities.getDescendant(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n\tif (entity == null) return null;\n\tEntityDefinition definition = entity.getDefinition();\n\tClass<?> javaClass = definition.javaClass();\n\treturn (")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(") entityReferenceFactory.getOrDefault(javaClass, (BiFunction<EntityDefinition, String, ")}).output(new Rule.Output[]{this.mark("datamart", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityReference>) ((a,b) -> null)).apply(definition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\t")}).output(new Rule.Output[]{this.mark("subclasstop", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());//.distinct();\n}")}), this.rule().condition(this.type("superclass"), new Rule.Condition[]{this.not(this.type("abstract")), this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\tif (id == null) return null;\n\tvar entity = entities.getDescendant(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n\tif (entity == null) return null;\n\tEntityDefinition definition = entity.getDefinition();\n\tClass<?> javaClass = definition.javaClass();\n\treturn (")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(") entityReferenceFactory.getOrDefault(javaClass, (BiFunction<EntityDefinition, String, ")}).output(new Rule.Output[]{this.mark("datamart", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityReference>) ((a,b) -> null)).apply(definition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\tentities.<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">stream(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition).map(Entity::id).map(id -> new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(() -> entities.get(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id))),\n\t\t")}).output(new Rule.Output[]{this.mark("subclasstop", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());//.distinct();\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null || !entities.contains(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id) ? null : new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(() -> entities.get(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id));\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn entities.stream(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)\n\t\t.map(Entity::id)\n\t\t.map(this::")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(")\n\t\t.filter(java.util.Objects::nonNull);\n}")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id);\nStream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\ndefault List<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("List() {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().collect(Collectors.toList());}\ndefault java.util.Optional<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(java.util.function.Predicate<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> predicate) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().filter(predicate).findFirst();}")}), this.rule().condition(this.type("timeline"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.literal("default TimelineNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("entity", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" entity) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(entity.id());}\nTimelineNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(String id);")}), this.rule().condition(this.type("reel"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.literal("default ReelNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("entity", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" entity) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(entity.id());}\nReelNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(String id);\nStream<ReelNode> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reels();")}), this.rule().condition(this.trigger("loadtimelinesfromdatahubmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void loadTimelinesFromDatahub() {\n\tLogger.debug(\"Downloading timelines...\");\n\tBoolean hasLocalAccessToTimelines = null;\n    for(String filename : listTimelineFiles()) {\n    \tif (filename == null || filename.isBlank()) continue;\n    \ttry {\n           \tFile file = new File(filename);\n           \tString id = file.getName().replace(\".timeline\", \"\");\n           \tString type = file.getParentFile().getName();\n           \tTimelineNodeImpl node = new TimelineNodeImpl(id, type, sourcesOfTimeline(type), file.exists() ? file : null);\n           \ttimelines.put(id + \":\" + type, node);\n           \tif (hasLocalAccessToTimelines == null) hasLocalAccessToTimelines = file.exists();\n           \telse hasLocalAccessToTimelines &= file.exists();\n        } catch (Exception e) {\n           \tLogger.debug(\"Could not load timeline \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n        }\n    }\n    this.hasLocalAccessToTimelines = hasLocalAccessToTimelines != null && hasLocalAccessToTimelines;\n    Logger.debug(\"Loaded \" + timelines.size() + \" timelines (hasLocalAccessToTimelines=\" + this.hasLocalAccessToTimelines + \")\");\n}\n\nprivate String[] listTimelineFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-timelines;\");\n\t\tjavax.jms.Message message = requestResponseFromDatahub(\"list-timelines\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((javax.jms.TextMessage) message).getText());\n\t\treturn ((javax.jms.TextMessage)message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")}), this.rule().condition(this.trigger("loadreelsfromdatahubmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void loadReelsFromDatahub() {\n\tLogger.debug(\"Downloading reels...\");\n\tBoolean hasLocalAccessToReels = null;\n\tfor(String filename : listReelFiles()) {\n\t\tif (filename == null || filename.isBlank()) continue;\n\t\ttry {\n\t    \tFile file = new File(filename);\n\t    \tString id = file.getName().replace(\".reel\", \"\");\n\t    \tString type = file.getParentFile().getName();\n\t    \tReelNodeImpl node = new ReelNodeImpl(id, type, sourcesOfReel(type), file.exists() ? file : null);\n\t    \treels.put(id + \":\" + type, node);\n\t    \tif (hasLocalAccessToReels == null) hasLocalAccessToReels = file.exists();\n            else hasLocalAccessToReels &= file.exists();\n\t    } catch (Exception e) {\n\t    \tLogger.debug(\"Could not load reel \" + filename + \" -> \" + e.getClass().getSimpleName() + \": \" + e.getMessage());\n\t    }\n\t}\n\tthis.hasLocalAccessToReels = hasLocalAccessToReels != null && hasLocalAccessToReels;\n\tLogger.debug(\"Loaded \" + reels.size() + \" reels\");\n}\n\nprivate String[] listReelFiles() {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=list-reels;\");\n\t\tjavax.jms.Message message = requestResponseFromDatahub(\"list-reels\", request);\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((javax.jms.TextMessage) message).getText());\n\t\treturn ((javax.jms.TextMessage)message).getText().split(\",\");\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0];\n\t}\n}")}), this.rule().condition(this.trigger("loaddictionaryfromdatahubmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void loadDictionaryFromDatahub(String name) {\n\tLogger.debug(\"Downloading dictionary...\");\n\tMap<String, Map<String, String>> words = new HashMap<>();\n\tvar entries = dictionaryEntries(name);\n\tfor(var triplet : entries) {\n\t\twords.computeIfAbsent(triplet[0], k -> new HashMap<>(4)).put(triplet[1], triplet[2]);\n\t}\n\tthis.dictionary = new DictionaryImpl(name, words);\n\tLogger.debug(\"Loaded dictionary \" + name + \" with \" + words.size() + \" words\");\n}\n\nprivate String[][] dictionaryEntries(String name) {\n\ttry {\n\t\tActiveMQTextMessage request = new ActiveMQTextMessage();\n\t\trequest.setText(\"datamart=\" + name() + \";operation=get-dictionary;name=\"+name);\n\t\tjavax.jms.Message message = requestResponseFromDatahub(\"get-dictionary\", request);\n\t\tif (message == null) return new String[0][0];\n\t\tif (!message.getBooleanProperty(\"success\")) throw new Exception(((javax.jms.TextMessage) message).getText());\n\t\tString text = ((javax.jms.TextMessage) message).getText();\n\t\tif (text == null) return new String[0][0];\n\t\treturn java.util.Arrays.stream(text.split(\"\\n\"))\n\t\t\t.filter(l -> !l.isBlank())\n\t\t\t.map(l -> l.trim().split(\"\\t\", -1))\n\t\t\t.filter(t -> t.length >= 3)\n\t\t\t.toArray(String[][]::new);\n\t} catch (Exception e) {\n\t\tLogger.error(e);\n\t\treturn new String[0][0];\n\t}\n}")})});
    }
}

