package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class EntityBaseTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((allTypes("entity","base"))).output(literal("package ")).output(mark("package")).output(literal(";\n\nimport java.util.*;\nimport java.util.stream.Collectors;\n\nimport io.intino.ness.master.model.*;\nimport io.intino.ness.master.reflection.*;\nimport io.intino.ness.master.model.Concept.Attribute.Value;\n\npublic class ")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity implements Entity {\n\n\tprivate final String id;\n\tprivate final ")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart datamart;\n\tprivate final Map<String, Attribute> attributes;\n\tprivate final EntityDefinition definition;\n\tprivate List<ChangeListener> listeners;\n\n\tpublic ")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity(String id, ")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart datamart, EntityDefinition definition) {\n\t\tthis.id = id;\n\t\tthis.datamart = datamart;\n\t\tthis.attributes = definition.attributes().stream()\n\t\t\t.map(a -> new Attribute(a.name(), null))\n\t\t\t.collect(Collectors.toMap(a -> a.name, a -> a, (a,b) -> b, LinkedHashMap::new));\n\t\tthis.attributes.put(\"id\", new Attribute(\"id\", id));\n\t\tthis.attributes.put(\"enabled\", new Attribute(\"enabled\", true));\n\t\tthis.definition = definition;\n\t}\n\n\t@Override\n\tpublic String id() {\n\t\treturn id;\n\t}\n\n\t@Override\n\tpublic boolean enabled() {\n\t\treturn attribute(\"enabled\").value().as(Boolean.class);\n\t}\n\n\t@Override\n\tpublic ")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart datamart() {\n\t\treturn datamart;\n\t}\n\n\t@Override\n\tpublic EntityDefinition getDefinition() {\n\t\treturn definition;\n\t}\n\n\t@Override\n\tpublic Concept.Attribute attribute(String name) {\n\t\treturn attributes.get(name);\n\t}\n\n\t@Override\n\tpublic List<Concept.Attribute> attributes() {\n\t\treturn new ArrayList<>(attributes.values());\n\t}\n\n\t@Override\n\tpublic void addChangeListener(ChangeListener listener) {\n\t\tif(listener == null) throw new NullPointerException(\"ChangeListener cannot be null\");\n\t\tif(listeners == null) listeners = new ArrayList<>(1);\n\t\tlisteners.add(listener);\n\t}\n\n\tprivate static final java.util.Set<String> ExcludedAttributeNames = java.util.Set.of(\"id\", \"enabled\", \"ts\", \"ss\");\n\tpublic synchronized void addAttribute(String name, Object value) {\n\t\tif(ExcludedAttributeNames.contains(name)) return;\n\t\tattributes.put(name, new Attribute(name, value));\n\t\tvar attributeDefinitions = getDefinition().declaredAttributes();\n\t\tif(attributeDefinitions.stream().anyMatch(a -> a.name().equals(name))) return;\n\t\tattributeDefinitions.add(new AttributeDefinition() {\n        \tpublic String name() {return name;}\n        \tpublic Class<?> type() {return String.class;}\n        \tpublic String toString() {return name;}\n        });\n\t}\n\n\tsynchronized void updateAttribute(String name, Object newValue) {\n\t\tAttribute attribute = attributes.get(name);\n\t\tif(attribute == null) {\n\t\t\taddAttribute(name, newValue);\n\t\t\treturn;\n\t\t}\n\t\tif(name.equals(\"id\")) return;\n\t\tValue oldValue = attribute.value();\n\t\tattribute.setValue(newValue);\n\t\tif(!oldValue.equals(attribute.value())) notifyChangeListeners(attribute, oldValue);\n\t}\n\n\tprivate void notifyChangeListeners(Attribute attribute, Value oldValue) {\n\t\tif(listeners == null) return;\n\t\tfor(ChangeListener listener : listeners) {\n\t\t\ttry {listener.onChange(this, attribute, oldValue);} catch(Throwable e) {}\n\t\t}\n\t}\n\n\t@Override\n\tpublic boolean equals(Object o) {\n\t\tif (this == o) return true;\n\t\tif (o == null || getClass() != o.getClass()) return false;\n\t\treturn id.equals(((Entity) o).id());\n\t}\n\n\t@Override\n\tpublic int hashCode() {\n\t\treturn id.hashCode();\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn id;\n\t}\n\n\tpublic final class Attribute implements Concept.Attribute {\n\n\t\tprivate final String name;\n\t\tprivate Value value;\n\t\tprivate List<ChangeListener> listeners;\n\n\t\tpublic Attribute(String name) {\n        \tthis(name, null);\n        }\n\n\t\tpublic Attribute(String name, Object initialValue) {\n\t\t\tthis.name = name;\n\t\t\tthis.value = new Value(initialValue);\n\t\t}\n\n\t\t@Override\n\t\tpublic AttributeDefinition getDefinition() {\n\t\t\treturn ")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity.this.getDefinition().attribute(name).get();\n\t\t}\n\n\t\t@Override\n        public String name() {\n        \treturn name;\n        }\n\n\t\t@Override\n\t\tpublic Value value() {\n\t\t\treturn value;\n\t\t}\n\n\t\t@Override\n\t\tpublic void addChangeListener(ChangeListener listener) {\n\t\t\tif(listener == null) throw new NullPointerException(\"ChangeListener cannot be null\");\n\t\t\tif(listeners == null) listeners = new ArrayList<>(1);\n\t\t\tlisteners.add(listener);\n\t\t}\n\n\t\tprivate void setValue(Object newValue) {\n\t\t\tValue oldValue = this.value;\n\t\t\tthis.value = new Value(newValue);\n\t\t\tif(!oldValue.equals(newValue)) notifyChangeListeners(oldValue, this.value);\n\t\t}\n\n\t\tprivate void notifyChangeListeners(Value oldValue, Value newValue) {\n\t\t\tif(listeners == null) return;\n\t\t\tfor(ChangeListener listener : listeners) {\n\t\t\t\ttry {\n\t\t\t\t\tlistener.onValueChange(oldValue, newValue);\n\t\t\t\t} catch(Throwable ignored) {}\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (this == o) return true;\n\t\t\tif (o == null || getClass() != o.getClass()) return false;\n\t\t\tAttribute other = (Attribute) o;\n\t\t\treturn name().equals(other.name()) && type().equals(other.type()) && value.equals(other.value());\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(name(), type(), value());\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn type().getSimpleName() + \" \" + name() + \" = \" + value();\n\t\t}\n\t}\n\n\tpublic static final class EntityDefinitionInternal implements EntityDefinition {\n\n    \tprivate final String entityName;\n\n    \tpublic EntityDefinitionInternal(String entityName) {\n    \t\tthis.entityName = entityName;\n    \t}\n\n    \t@Override\n    \tpublic boolean isAbstract() {\n    \t\treturn definition().isAbstract();\n    \t}\n\n    \t@Override\n    \tpublic String fullName() {\n    \t\treturn definition().fullName();\n    \t}\n\n    \t@Override\n    \tpublic String name() {\n    \t\treturn definition().name();\n    \t}\n\n    \t@Override\n    \tpublic List<AttributeDefinition> declaredAttributes() {\n    \t\treturn definition().declaredAttributes();\n    \t}\n\n    \t@Override\n    \tpublic java.util.Optional<EntityDefinition> parent() {\n    \t\treturn definition().parent();\n    \t}\n\n    \t@Override\n        public List<EntityDefinition> ancestors() {\n        \treturn definition().ancestors();\n        }\n\n    \t@Override\n    \tpublic List<EntityDefinition> descendants() {\n    \t\treturn definition().descendants();\n    \t}\n\n    \t@Override\n    \tpublic Class<?> javaClass() {\n    \t\treturn definition().javaClass();\n    \t}\n\n    \t@Override\n    \tpublic boolean equals(Object o) {\n    \t\tif(o == null) return false;\n    \t\tif(o instanceof EntityDefinition) return o.equals(definition());\n    \t\treturn false;\n    \t}\n\n    \t@Override\n    \tpublic int hashCode() {\n    \t\treturn definition().hashCode();\n    \t}\n\n    \tprivate EntityDefinition definition() {\n    \t\treturn ")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart.definition.entity(entityName).orElseThrow(() -> new IllegalStateException(\"")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart is not initialized\"));\n    \t}\n    }\n}")),
			rule().condition((type("entityBaseReference"))).output(literal("package ")).output(mark("package")).output(literal(";\n\nimport io.intino.cosmos.datahub.datamarts.master.")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity;\nimport io.intino.ness.master.Datamart;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.reflection.EntityDefinition;\n\nimport java.util.List;\nimport java.util.NoSuchElementException;\nimport java.util.function.Supplier;\n\npublic class ")).output(mark("datamart", "FirstUpperCase")).output(literal("EntityReference implements Entity {\n\n\tprivate final Supplier<")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity> entity;\n\n\tpublic ")).output(mark("datamart", "FirstUpperCase")).output(literal("EntityReference(Supplier<")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity> entity) {\n\t\tthis.entity = entity;\n\t}\n\n\t@Override\n\tpublic String id() {\n\t\treturn entity.get().id();\n\t}\n\n\t@Override\n\tpublic boolean enabled() {\n\t\treturn entity.get().enabled();\n\t}\n\n\t@Override\n\tpublic ")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart datamart() {\n\t\treturn entity.get().datamart();\n\t}\n\n\t@Override\n\tpublic Attribute attribute(String name) {\n\t\treturn entity.get().attribute(name);\n\t}\n\n\t@Override\n\tpublic List<Attribute> attributes() {\n\t\treturn entity.get().attributes();\n\t}\n\n\t@Override\n\tpublic void addChangeListener(ChangeListener listener) {\n\t\tentity.get().addChangeListener(listener);\n\t}\n\n\t@Override\n\tpublic EntityDefinition getDefinition() {\n\t\treturn entity.get().getDefinition();\n\t}\n\n\tpublic final boolean isValidEntityReference() {\n\t\ttry {\n\t\t\treturn entity.get() != null;\n\t\t} catch (Throwable e) {\n\t\t\treturn false;\n\t\t}\n\t}\n\n\t@Override\n    public boolean equals(Object o) {\n    \tif (this == o) return true;\n    \tif (o == null || getClass() != o.getClass()) return false;\n    \treturn id().equals(((Entity) o).id());\n    }\n\n    @Override\n    public int hashCode() {\n    \treturn entity.get().hashCode();\n    }\n\n\t@Override\n\tpublic String toString() {\n\t\treturn entity.get().toString();\n\t}\n\n\tpublic static class InvalidEntityReferenceException extends NoSuchElementException {\n\t\tpublic InvalidEntityReferenceException() {}\n\n\t\tpublic InvalidEntityReferenceException(String s, Throwable cause) {\n\t\t\tsuper(s, cause);\n\t\t}\n\n\t\tpublic InvalidEntityReferenceException(Throwable cause) {\n\t\t\tsuper(cause);\n\t\t}\n\n\t\tpublic InvalidEntityReferenceException(String s) {\n\t\t\tsuper(s);\n\t\t}\n\t}\n}"))
		);
	}
}