/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.terminal;

import io.intino.Configuration;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Measurement;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Terminal;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Layer;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.DatamartsRenderer;
import io.intino.ness.datahubterminalplugin.terminal.TerminalTemplate;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class TerminalRenderer {
    private final Terminal terminal;
    private final File srcDir;
    private final String rootPackage;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final String ontologyPackage;

    TerminalRenderer(Terminal terminal, File srcDir, String rootPackage, Configuration conf, PrintStream logger, PluginLauncher.Notifier notifier, String ontologyPackage) {
        this.terminal = terminal;
        this.srcDir = srcDir;
        this.rootPackage = rootPackage;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.ontologyPackage = ontologyPackage;
    }

    void render() {
        File packageFolder = new File(this.srcDir, this.rootPackage.replace(".", File.separator));
        Commons.writeFrame(packageFolder, Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString(), this.template().render((Object)this.createTerminalFrame()));
    }

    private Frame createTerminalFrame() {
        Datalake datalake = this.terminal.graph().datalake();
        FrameBuilder builder = new FrameBuilder(new String[]{"terminal"}).add("package", (Object)this.rootPackage).add("name", (Object)this.terminal.name$());
        if (datalake != null) {
            builder.add("datalake", (Object)"").add("scale", (Object)datalake.scale().name());
        }
        builder.add("message", (Object)this.messageFrames());
        builder.add("measurement", (Object)this.measurementFrames());
        if (this.terminal.datamarts() != null) {
            this.renderDatamarts(builder);
        }
        if (this.terminal.publish() != null) {
            this.addPublish(builder);
        }
        if (this.terminal.subscribe() != null) {
            this.addSubscribe(builder);
        }
        if (this.terminal.bpm() != null) {
            this.addBpm(builder);
        }
        return builder.toFrame();
    }

    private void addSubscribe(FrameBuilder builder) {
        this.terminal.subscribe().messageTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
        if (this.terminal.datamarts() != null) {
            this.addSubscribeForThedevents(builder);
        }
        this.terminal.subscribe().measurementTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
    }

    private void addSubscribeForThedevents(FrameBuilder builder) {
        Set tanksAlreadySubscribedTo = this.terminal.subscribe().messageTanks().stream().map(Layer::name$).collect(Collectors.toSet());
        for (Datamart datamart : this.terminal.datamarts().list()) {
            List tanks = datamart.entityList().stream().map(Entity::from).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            for (Datalake.Tank.Message tank : tanks) {
                if (!tanksAlreadySubscribedTo.add(tank.name$())) continue;
                builder.add("subscribe", (Object)this.frameOf(tank));
            }
        }
    }

    private void addPublish(FrameBuilder builder) {
        this.terminal.publish().messageTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Message)tank)));
        this.terminal.publish().measurementTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
    }

    private void renderDatamarts(FrameBuilder builder) {
        for (Datamart datamart : this.terminal.datamarts().list()) {
            builder.add("datamart", (Object)this.frameOf(datamart));
        }
        new DatamartsRenderer(this.srcDir, this.terminal.graph(), this.conf, this.logger, this.notifier, this.ontologyPackage).render(this.terminal, this.rootPackage);
    }

    private FrameBuilder frameOf(Datamart datamart) {
        return new FrameBuilder(new String[]{"datamart"}).add("name", (Object)datamart.name$()).add("package", (Object)(this.ontologyPackage + ".datamarts." + Formatters.javaValidName().format((Object)datamart.name$().toLowerCase()).toString())).add("devent", (Object)this.eventsOf(datamart));
    }

    private FrameBuilder[] eventsOf(Datamart datamart) {
        return (FrameBuilder[])datamart.entityList().stream().map(Entity::from).filter(Objects::nonNull).distinct().map(tank -> this.frameOf((Datalake.Tank.Message)tank, datamart)).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder frameOf(Datalake.Tank.Message tank, Datamart datamart) {
        return new FrameBuilder(new String[]{"devent"}).add("message", (Object)tank.message().name$()).add("namespaceQn", (Object)this.namespace((Layer)tank.message()).replace(".", "")).add("datamart", (Object)datamart.name$());
    }

    private Frame[] messageFrames() {
        return (Frame[])this.messageTanks().stream().map(Datalake.Tank.Message::message).distinct().map(m -> new FrameBuilder(new String[]{"message"}).add("namespace", (Object)this.namespace((Layer)m)).add("namespaceQn", (Object)this.namespace((Layer)m).replace(".", "")).add("name", (Object)m.name$()).add("typename", (Object)Formatters.firstUpperCase(m.name$())).add("type", (Object)(this.messagePackage((Message)m) + "." + Formatters.firstUpperCase(m.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] measurementFrames() {
        return (Frame[])this.measurementTanks().stream().map(Datalake.Tank.Measurement::measurement).distinct().map(m -> new FrameBuilder(new String[]{"measurement"}).add("namespace", (Object)this.namespace((Layer)m)).add("namespaceQn", (Object)this.namespace((Layer)m).replace(".", "")).add("name", (Object)m.name$()).add("typename", (Object)Formatters.firstUpperCase(m.name$())).add("type", (Object)(this.measurementPackage((Measurement)m) + "." + Formatters.firstUpperCase(m.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private void addBpm(FrameBuilder builder) {
        String statusQn = this.terminal.bpm().processStatusClass();
        String processStatusQName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
        FrameBuilder bpmBuilder = new FrameBuilder(new String[]{"default", "bpm"}).add("type", (Object)statusQn).add("typeName", (Object)processStatusQName);
        bpmBuilder.add("channel", (Object)processStatusQName);
        builder.add("subscribe", (Object)bpmBuilder);
        builder.add("publish", (Object)bpmBuilder);
        builder.add("event", (Object)new FrameBuilder(new String[]{"event"}).add("name", (Object)processStatusQName).add("type", (Object)statusQn).toFrame());
    }

    private Frame frameOf(Datalake.Tank.Message tank) {
        String messagesPackage = this.messagePackage(tank.message());
        String namespace = this.namespace((Layer)tank.message());
        return new FrameBuilder(new String[]{"message"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.message().name$()))).add("message", (Object)tank.message().name$()).add("typeName", (Object)tank.name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private Frame frameOf(Datalake.Tank.Measurement tank) {
        String messagesPackage = this.measurementPackage(tank.measurement());
        String namespace = this.namespace((Layer)tank.measurement());
        return new FrameBuilder(new String[]{"measurement"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.measurement().name$()))).add("message", (Object)tank.measurement().name$()).add("typeName", (Object)tank.name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private String messagePackage(Message event) {
        String aPackage = this.rootPackage + ".messages";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String measurementPackage(Measurement event) {
        String aPackage = this.rootPackage + ".measurements";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String namespace(Layer event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn().toLowerCase() : "";
    }

    private Collection<Datalake.Tank.Message> messageTanks() {
        LinkedHashSet<Datalake.Tank.Message> tanks = new LinkedHashSet<Datalake.Tank.Message>();
        if (this.terminal.publish() != null) {
            tanks.addAll(this.terminal.publish().messageTanks());
        }
        if (this.terminal.subscribe() != null) {
            tanks.addAll(this.terminal.subscribe().messageTanks());
        }
        if (this.terminal.datamarts() != null) {
            tanks.addAll(this.messageTanksOf(this.terminal.datamarts()));
        }
        return tanks;
    }

    private Collection<Datalake.Tank.Message> messageTanksOf(Terminal.Datamarts datamarts) {
        return datamarts.list().stream().flatMap(d -> d.entityList().stream()).map(Entity::from).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private List<Datalake.Tank.Measurement> measurementTanks() {
        ArrayList<Datalake.Tank.Measurement> tanks = new ArrayList<Datalake.Tank.Measurement>();
        if (this.terminal.publish() != null) {
            tanks.addAll(this.terminal.publish().measurementTanks());
        }
        if (this.terminal.subscribe() != null) {
            tanks.addAll(this.terminal.subscribe().measurementTanks());
        }
        return tanks;
    }

    private Template template() {
        return Formatters.customize(new TerminalTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

