/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.terminal;

import com.google.gson.Gson;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Terminal;
import io.intino.magritte.framework.Layer;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.IntinoException;
import io.intino.ness.datahubterminalplugin.Manifest;
import io.intino.ness.datahubterminalplugin.MavenTerminalExecutor;
import io.intino.ness.datahubterminalplugin.Version;
import io.intino.ness.datahubterminalplugin.terminal.TerminalRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TerminalPublisher {
    private final File root;
    private final Terminal terminal;
    private final Configuration conf;
    private final Map<String, String> versions;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;

    public TerminalPublisher(File root, Terminal terminal, Configuration configuration, Map<String, String> versions, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger, PluginLauncher.Notifier notifier) {
        this.root = root;
        this.terminal = terminal;
        this.conf = configuration;
        this.versions = versions;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
        this.notifier = notifier;
    }

    public boolean publish() {
        try {
            if (!this.createSources()) {
                return false;
            }
            this.logger.println("Publishing " + this.terminal.name$() + "...");
            new MavenTerminalExecutor(this.root, this.basePackage, this.targets(), this.terminalNameArtifact(), this.versions, this.conf, this.systemProperties, this.logger).mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Terminal " + this.terminal.name$() + " published!");
            return true;
        }
        catch (Throwable e) {
            this.logger.println(e.getMessage() == null ? e.toString() : e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private ArrayList<MavenTerminalExecutor.Target> targets() {
        ArrayList<MavenTerminalExecutor.Target> targets = new ArrayList<MavenTerminalExecutor.Target>();
        targets.add(MavenTerminalExecutor.Target.Events);
        if (this.terminal.bpm() != null) {
            targets.add(MavenTerminalExecutor.Target.Bpm);
        }
        return targets;
    }

    private boolean checkPublish() {
        try {
            Version version = new Version(this.conf.artifact().version());
            if (!(version.isSnapshot() || this.invokedPhase != PluginLauncher.Phase.DISTRIBUTE && this.invokedPhase != PluginLauncher.Phase.DEPLOY)) {
                return false;
            }
        }
        catch (IntinoException e) {
            return false;
        }
        return true;
    }

    private boolean createSources() {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        if (this.duplicatedEvents()) {
            return false;
        }
        new TerminalRenderer(this.terminal, srcDirectory, this.basePackage, this.conf, this.logger, this.notifier, this.conf.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.conf.artifact().name()).toString().toLowerCase()).render();
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        this.writeManifest(resDirectory);
        return true;
    }

    private boolean duplicatedEvents() {
        Set duplicatedSubscribe;
        Set duplicatedPublish = this.terminal.publish() != null ? this.findDuplicates(this.terminal.publish().messageTanks().stream().map(Datalake.Tank.Message::qn).collect(Collectors.toList())) : Collections.emptySet();
        Set<Object> set = duplicatedSubscribe = this.terminal.subscribe() != null ? this.findDuplicates(this.terminal.subscribe().messageTanks().stream().map(Datalake.Tank.Message::qn).collect(Collectors.toList())) : Collections.emptySet();
        if (!duplicatedPublish.isEmpty()) {
            this.logger.println("Duplicated publishing event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            this.notifier.notifyError("Duplicated publishing event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            return true;
        }
        if (!duplicatedSubscribe.isEmpty()) {
            this.logger.println("Duplicated subscription event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            this.notifier.notifyError("Duplicated subscription event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            return true;
        }
        return false;
    }

    public Set<String> findDuplicates(List<String> listContainingDuplicates) {
        HashSet set = new HashSet();
        return listContainingDuplicates.stream().filter(yourInt -> !set.add(yourInt)).collect(Collectors.toSet());
    }

    private void writeManifest(File srcDirectory) {
        ArrayList<String> subscribe;
        ArrayList<String> publish;
        List<String> list = publish = this.terminal.publish() != null ? this.terminal.publish().messageTanks().stream().map(this::eventQn).collect(Collectors.toList()) : new ArrayList<String>();
        if (this.terminal.publish() != null) {
            publish.addAll(this.terminal.publish().measurementTanks().stream().map(this::eventQn).collect(Collectors.toList()));
        }
        List<String> list2 = subscribe = this.terminal.subscribe() != null ? this.terminal.subscribe().messageTanks().stream().map(this::eventQn).collect(Collectors.toList()) : new ArrayList<String>();
        if (this.terminal.subscribe() != null) {
            subscribe.addAll(this.terminal.subscribe().measurementTanks().stream().map(this::eventQn).collect(Collectors.toList()));
        }
        Manifest manifest = new Manifest(this.terminal.name$(), this.basePackage + "." + Formatters.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString()), publish, subscribe, this.tankClasses());
        try {
            Files.write(new File(srcDirectory, "terminal.mf").toPath(), new Gson().toJson((Object)manifest).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String terminalNameArtifact() {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)this.terminal.name$()).toString());
    }

    private Map<String, String> tankClasses() {
        HashMap<String, String> tankClasses = new HashMap<String, String>();
        if (this.terminal.publish() != null) {
            this.terminal.publish().messageTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Message)t), this.basePackage + ".message." + this.eventQn((Datalake.Tank.Message)t)));
            this.terminal.publish().measurementTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Measurement)t), this.basePackage + ".measurements." + this.eventQn((Datalake.Tank.Measurement)t)));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().messageTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Message)t), this.basePackage + ".messages." + this.eventQn((Datalake.Tank.Message)t)));
            this.terminal.subscribe().measurementTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Measurement)t), this.basePackage + ".measurements." + this.eventQn((Datalake.Tank.Measurement)t)));
        }
        if (this.terminal.bpm() != null) {
            tankClasses.put(this.terminal.bpm().processStatusClass().substring(this.terminal.bpm().processStatusClass().lastIndexOf(".") + 1), this.terminal.bpm().processStatusClass());
        }
        return tankClasses;
    }

    private String eventQn(Datalake.Tank.Message tank) {
        return this.namespace((Layer)tank.message()) + tank.message().name$();
    }

    private String eventQn(Datalake.Tank.Measurement tank) {
        return this.namespace((Layer)tank.measurement()) + tank.measurement().name$();
    }

    private String namespace(Layer event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn() + "." : "";
    }
}

