/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.ConceptAttribute;
import io.intino.ness.datahubterminalplugin.master.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityMounterFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    private final String destinationPackage;
    private final String ontologyPackage;
    private final Datamart datamart;

    public EntityMounterFrameFactory(String destinationPackage, String ontologyPackage, Datamart datamart) {
        this.destinationPackage = destinationPackage;
        this.ontologyPackage = ontologyPackage;
        this.datamart = datamart;
    }

    public Map<String, Frame> create(Entity entity) {
        if (entity.isAbstract()) {
            return new HashMap<String, Frame>(0);
        }
        return Map.of(this.getMounterPath(entity, this.destinationPackage), this.frameOf(entity).toFrame());
    }

    private FrameBuilder frameOf(Entity entity) {
        Parameter parent;
        FrameBuilder builder = new FrameBuilder(new String[]{"mounter"}).add("message").add("package", (Object)this.destinationPackage).add("ontologypackage", (Object)this.ontologyPackage).add("datamart", (Object)this.datamart.name$()).add("name", (Object)entity.core$().name()).add("attribute", this.attributesOf(entity).stream().map(this::attrFrameOf).toArray(FrameBuilder[]::new));
        if (!this.datamart.structList().isEmpty()) {
            builder.add("hasStructs", (Object)new FrameBuilder().add("package", (Object)this.destinationPackage));
        }
        builder.add("parent", (Object)((parent = this.parameter(entity.core$(), "entity")) != null ? ((Entity)parent.values().get(0)).name$() : "io.intino.ness.master.model.Entity"));
        builder.add("normalizeId", (Object)new FrameBuilder(new String[]{"normalizeId", entity.isAbstract() || entity.isDecorable() ? "abstract" : ""}).add("package", (Object)this.destinationPackage).add("name", (Object)entity.name$()).toFrame());
        if (entity.isDecorable() || entity.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (entity.isDecorable()) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private FrameBuilder attrFrameOf(ConceptAttribute attr) {
        FrameBuilder builder = new FrameBuilder().add("attribute");
        attr.conceptList().forEach(aspect -> builder.add(aspect.name()));
        Node owner = (Node)attr.owner();
        if (owner.is(Entity.Abstract.class) || owner.is(Entity.Decorable.class)) {
            builder.add("castToSubclass", (Object)("(" + owner.name() + ")"));
        }
        Object type = attr.type();
        builder.add("typename", type);
        if (attr.isEntity()) {
            type = this.entitiesPackage() + (String)type;
        } else if (attr.isStruct()) {
            type = this.structsPackage() + (String)type;
        }
        EntityMounterFrameFactory.handleCollectionType(attr, builder, (String)type);
        builder.add("name", (Object)attr.name$()).add("owner", (Object)owner.name()).add("package", (Object)this.ontologyPackage).add("index", (Object)owner.componentList().indexOf(attr.core$())).add("entityOwner", (Object)owner.name());
        this.processParameters(attr.core$(), builder, (String)type);
        return builder;
    }

    private String entitiesPackage() {
        return this.ontologyPackage + ".entities.";
    }

    private String structsPackage() {
        return this.ontologyPackage + ".structs.";
    }

    private static void handleCollectionType(ConceptAttribute attr, FrameBuilder builder, String type) {
        if (attr.isList() || attr.isSet()) {
            String collectionType = attr.isList() ? "List" : "Set";
            builder.add("type", (Object)(collectionType + "<" + type + ">"));
            builder.add("typeParameter", (Object)type);
            builder.add("collectionType", (Object)collectionType);
        } else if (attr.isMap()) {
            builder.add("type", (Object)"Map<String, String>");
            builder.add("typeParameter", (Object)"java.lang.String");
            builder.add("collectionType", (Object)"Map");
        } else {
            builder.add("type", (Object)type);
        }
    }

    private void processParameters(Node node, FrameBuilder builder, String type) {
        Parameter struct;
        Parameter format;
        Parameter defaultValue;
        Parameter values = this.parameter(node, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(node)) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
        }
        if ((format = this.parameter(node, "format")) != null) {
            builder.add("format", format.values().get(0));
        } else if (type.startsWith("Date")) {
            builder.add("format", (Object)this.defaultFormat(type));
        }
        Parameter entity = this.parameter(node, "entity");
        if (entity != null) {
            String name = ((Entity)entity.values().get(0)).name$();
            builder.add("entity", (Object)name);
            Entity reference = this.datamart.entityList().stream().filter(e -> e.name$().equals(name)).findFirst().orElse(null);
            if (reference != null && reference.core$().conceptList().stream().anyMatch(c -> c.name().equals("Component"))) {
                builder.add("component");
            }
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            Struct structNode = (Struct)struct.values().get(0);
            builder.add("struct", (Object)this.structFrame(structNode)).add("structLength", (Object)String.valueOf(structNode.attributeList().size()));
        }
        builder.add("attribute", (Object)builder.toFrame());
    }

    private String defaultFormat(String type) {
        return type.equals("Date") ? "dd/MM/yyyy" : "dd/MM/yyyy HH:mm:ss";
    }

    private Frame structFrame(Struct struct) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)struct.core$().name()).add("package", (Object)this.destinationPackage).add("attribute", (Object)this.attributesOf(struct).stream().map(this::attrFrameOf).toArray()).toFrame();
    }

    private Frame defaultValue(Node c, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])c.conceptList().stream().map(Predicate::name).toArray(String[]::new));
        return builder.add("type", (Object)type).add("package", (Object)this.destinationPackage).add("value", (Object)EntityMounterFrameFactory.defaultValueOf(type, defaultValue)).toFrame();
    }

    private static String defaultValueOf(String type, Parameter defaultValue) {
        if (type.contains("List<")) {
            return "null";
        }
        if (type.contains("Set<")) {
            return "null";
        }
        if (type.contains("Map<")) {
            return "null";
        }
        return defaultValue.values().get(0).toString();
    }

    private Parameter parameter(Node c, String name) {
        List values = (List)c.variables().get(name);
        return values == null ? null : Parameter.of(values);
    }

    private String getMounterPath(Entity entity, String aPackage) {
        return aPackage + ".mounters." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)(entity.core$().name() + "Mounter")).toString());
    }
}

