package io.intino.ness.datahubterminalplugin.lookups;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class LookupsTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((type("lookups"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(";\n\nimport java.util.Map;\n\npublic class Lookups {\n\tprivate final java.io.File directory;\n\t")).output(mark("namespace").multiple("\n")).output(literal("\n\t")).output(mark("lookup", "field").multiple("\n")).output(literal("\n\n\tpublic Lookups(java.io.File directory) {\n\t\tthis.directory = directory;\n\t}\n\n\t")).output(mark("lookup", "getter").multiple("\n\n")).output(literal("\n}")),
			rule().condition((trigger("namespace"))).output(literal("private Map<String, java.sql.Connection> ")).output(mark("", "validName", "firstLowerCase")).output(literal(" = new java.util.HashMap<>();")),
			rule().condition((type("lookup")), (trigger("field"))).output(literal("private Map<String, ")).output(mark("qn")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(" = new java.util.HashMap<>();")),
			rule().condition((type("lookup")), (trigger("getter"))).output(literal("public ")).output(mark("qn")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\tif (!this.")).output(mark("namespace", "validName", "firstLowerCase")).output(literal(".containsKey(\"")).output(mark("namespace", "firstLowerCase")).output(literal("\")) {\n\t\ttry {\n\t\t\tjava.sql.Connection connection = java.sql.DriverManager.getConnection(\"jdbc:sqlite:\" + new java.io.File(directory, \"")).output(mark("namespace", "firstLowerCase")).output(literal("\" + \".db\"));\n\t\t\tconnection.setAutoCommit(false);\n\t\t\tthis.")).output(mark("namespace", "validName", "firstLowerCase")).output(literal(".put(\"")).output(mark("namespace", "firstLowerCase")).output(literal("\", connection);\n\t\t} catch (java.sql.SQLException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e);\n\t\t}\n\t}\n\tif (!this.")).output(mark("name", "firstLowerCase")).output(literal(".containsKey(\"")).output(mark("namespace", "firstLowerCase")).output(literal("\"))\n\t\tthis.")).output(mark("name", "firstLowerCase")).output(literal(".put(\"")).output(mark("namespace", "firstLowerCase")).output(literal("\", new ")).output(mark("qn")).output(literal("(")).output(mark("namespace", "validName", "firstLowerCase")).output(literal(".get(\"")).output(mark("namespace", "firstLowerCase")).output(literal("\")));\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(".get(\"")).output(mark("namespace", "firstLowerCase")).output(literal("\");\n}\n\npublic ")).output(mark("qn")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(String split) {\n\tif (!this.")).output(mark("namespace", "validName", "firstLowerCase")).output(literal(".containsKey(\"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split)) {\n\t\ttry {\n\t\t\tjava.sql.Connection connection = java.sql.DriverManager.getConnection(\"jdbc:sqlite:\" + new java.io.File(directory, \"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split + \".db\"));\n\t\t\tconnection.setAutoCommit(false);\n\t\t\tthis.")).output(mark("namespace", "validName", "firstLowerCase")).output(literal(".put(\"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split, connection);\n\t\t} catch (java.sql.SQLException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e);\n\t\t}\n\t}\n\tif (!this.")).output(mark("name", "firstLowerCase")).output(literal(".containsKey(\"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split))\n\t\tthis.")).output(mark("name", "firstLowerCase")).output(literal(".put(\"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split, new ")).output(mark("qn")).output(literal("(")).output(mark("namespace", "validName", "firstLowerCase")).output(literal(".get(\"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split)));\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(".get(\"")).output(mark("namespace", "firstLowerCase")).output(literal(".\" + split);\n}"))
		);
	}
}