package io.intino.ness.datahubterminalplugin.master;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class EntityTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((allTypes("entity","decorable"))).output(literal("package ")).output(mark("package")).output(literal(".entities;\n\npublic class ")).output(mark("name", "FirstUpperCase")).output(literal(" extends Abstract")).output(mark("name", "FirstUpperCase")).output(literal(" {\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("(String id) {\n\t\tsuper(id);\n\t}\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("(io.intino.ness.master.model.TripletRecord record) {\n\t\tsuper(record);\n\t}\n}")),
			rule().condition((allTypes("entity","class"))).output(literal("package ")).output(mark("package")).output(literal(".entities;\n\nimport io.intino.ness.master.model.Triplet;\nimport io.intino.ness.master.model.TripletRecord;\nimport io.intino.ness.master.model.Entity;\n\nimport java.time.*;\nimport java.util.*;\nimport java.util.stream.*;\n\npublic")).output(expression().output(literal(" ")).output(mark("isAbstract", "firstLowerCase"))).output(literal(" class ")).output(mark("abstract")).output(mark("name", "FirstUpperCase")).output(literal(" extends ")).output(mark("parent")).output(literal(" {\n\n\tprotected static final String LIST_SEP = \",\";\n\n\t")).output(expression().output(mark("attribute", "wordDeclaration").multiple("\n"))).output(literal("\n\n\tprotected transient final ")).output(mark("package")).output(literal(".Entities master;\n\n\t")).output(expression().output(mark("attribute", "field").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("abstract")).output(mark("name", "FirstUpperCase")).output(literal("(String id) {\n\t\t")).output(mark("parent", "super")).output(literal("\n\t\tthis.master = ")).output(mark("package")).output(literal(".Entities.get();\n\t}\n\n\tpublic ")).output(mark("abstract")).output(mark("name", "FirstUpperCase")).output(literal("(TripletRecord record) {\n\t\tthis(normalizeId(record.id()));\n\t\trecord.triplets().forEach(this::add);\n\t}\n\n\t")).output(expression().output(mark("attribute", "getterAndSetter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("expression", "expressionDeclaration").multiple("\n\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal(" add(Triplet triplet) {\n\t\tswitch(triplet.predicate()) {\n\t\t\t")).output(expression().output(mark("attribute", "addSwitchCase").multiple("\n"))).output(literal("\n\t\t\tdefault: super.add(triplet); break;\n\t\t}\n\t\treturn (")).output(mark("name", "FirstUpperCase")).output(literal(") this;\n\t}\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal(" remove(Triplet triplet) {\n\t\tswitch(triplet.predicate()) {\n\t\t\t")).output(expression().output(mark("attribute", "removeSwitchCase").multiple("\n"))).output(literal("\n\t\t\tdefault: super.remove(triplet); break;\n\t\t}\n\t\treturn (")).output(mark("name", "FirstUpperCase")).output(literal(") this;\n\t}\n\n\t")).output(expression().output(literal("public List<Triplet> triplets() {\r")).output(literal("\n")).output(literal("\tfinal java.util.ArrayList<Triplet> triplets = new java.util.ArrayList<>();\r")).output(literal("\n")).output(literal("\t")).output(mark("attribute", "astriplet").multiple("\n")).output(literal("\n")).output(literal("\ttriplets.addAll(super.triplets());\r")).output(literal("\n")).output(literal("\treturn triplets;\r")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(mark("attribute", "addAndRemoveMethod").multiple("\n\n"))).output(literal("\n\n\t")).output(mark("normalizeId", "normalizeIdMethod")).output(literal("\n}")),
			rule().condition((allTypes("normalizeId","abstract")), (trigger("normalizeidmethod"))).output(literal("private static String normalizeId(String fullId) {\n\treturn fullId;\n}")),
			rule().condition((type("normalizeId")), (trigger("normalizeidmethod"))).output(literal("private static String normalizeId(String fullId) {\n\tEntity.Id id = new Entity.Id(fullId);\n\tif(id.type().isEmpty()) return id.value() + \":")).output(mark("name", "firstLowerCase")).output(literal("\";\n\tif(!id.type().equals(\"")).output(mark("name", "firstLowerCase")).output(literal("\")) throw new IllegalArgumentException(\"Attempting to create an ")).output(mark("name", "firstUpperCase")).output(literal(" with an invalid id: \" + fullId);\n\treturn fullId;\n}")),
			rule().condition((attribute("", "io.intino.ness.master.model.Entity")), (trigger("super"))).output(literal("super(normalizeId(id));")),
			rule().condition((trigger("super"))).output(literal("super(normalizeId(id));")),
			rule().condition((trigger("addswitchcase"))).output(literal("case \"")).output(mark("name")).output(literal("\": add")).output(mark("name", "FirstUpperCase")).output(literal("(triplet); break;")),
			rule().condition((trigger("removeswitchcase"))).output(literal("case \"")).output(mark("name")).output(literal("\": remove")).output(mark("name", "FirstUpperCase")).output(literal("(triplet); break;")),
			rule().condition((trigger("addandremovemethod"))).output(literal("protected void add")).output(mark("name", "FirstUpperCase")).output(literal("(Triplet triplet) {\n\t")).output(mark("attribute", "add")).output(literal("\n}\n\nprotected void remove")).output(mark("name", "FirstUpperCase")).output(literal("(Triplet triplet) {\n\t")).output(mark("attribute", "remove")).output(literal("\n}")),
			rule().condition((type("boolean")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Boolean::parseBoolean).collect(Collectors.toList());")),
			rule().condition((type("integer")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Integer::parseInt).collect(Collectors.toList());")),
			rule().condition((type("double")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Double::parseDouble).collect(Collectors.toList());")),
			rule().condition((type("long")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Long::parseLong).collect(Collectors.toList());")),
			rule().condition((type("word")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(")).output(mark("typeParameter", "firstUpperCase")).output(literal("::valueOf).collect(Collectors.toList());")),
			rule().condition((type("word")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(")).output(mark("typeParameter", "firstUpperCase")).output(literal("::valueOf).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("string")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).collect(Collectors.toList());")),
			rule().condition((type("entity")), (type("list")), (type("component")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nio.intino.ness.master.serialization.MasterSerializer serializer = master.serializer();\nString[] items = triplet.value().split(LIST_SEP);\nthis.")).output(mark("name", "firstLowerCase")).output(literal(" = new ArrayList<>(items.length);\n\nfor(String serializedItem : items) {\n\tTripletRecord item = serializer.deserialize(serializedItem.trim());\n\t")).output(mark("entity", "FirstUpperCase")).output(literal(" entity = new ")).output(mark("entity", "FirstUpperCase")).output(literal("(item.id());\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(".add(entity);\n}")),
			rule().condition((type("entity")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).collect(Collectors.toList());")),
			rule().condition((type("struct")), (type("list")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nif(triplet.value().isEmpty()) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = new ArrayList<>(0);\n\treturn;\n}\n\nString[] items = triplet.value().split(LIST_SEP);\n")).output(mark("name", "firstLowerCase")).output(literal(" = new ArrayList<>();\n\nfor(int i = 0;i < items.length;i += ")).output(mark("structLength")).output(literal(") {\n\tfinal int offset = i;\n\tList<String> values = new java.util.AbstractList<>() {\n\t\t@Override public String get(int index) {return items[index + offset];}\n\t\t@Override public int size() { return ")).output(mark("structLength")).output(literal(";}\n\t};\n\t")).output(mark("name", "firstLowerCase")).output(literal(".add(")).output(mark("struct", "call")).output(literal(");\n}")),
			rule().condition((type("struct")), (type("set")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nif(triplet.value().isEmpty()) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = new LinkedHashSet<>(0);\n\treturn;\n}\n\nString[] items = triplet.value().split(LIST_SEP);\n")).output(mark("name", "firstLowerCase")).output(literal(" = new LinkedHashSet<>();\n\nfor(int i = 0;i < items.length;i += ")).output(mark("structLength")).output(literal(") {\n\tfinal int offset = i;\n\tList<String> values = new java.util.AbstractList<>() {\n\t\t@Override public String get(int index) {return items[index + offset];}\n\t\t@Override public int size() { return ")).output(mark("structLength")).output(literal(";}\n\t};\n\t")).output(mark("name", "firstLowerCase")).output(literal(".add(")).output(mark("struct", "call")).output(literal(");\n}")),
			rule().condition((type("date")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(s -> java.time.LocalDate.parse(s, java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"))).collect(Collectors.toList()));")),
			rule().condition((type("datetime")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(s -> java.time.LocalDateTime.parse(s, java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"))).collect(Collectors.toList()));")),
			rule().condition((type("instant")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(s -> java.time.Instant.ofEpochMilli(Long.parseLong(s))).collect(Collectors.toList()));")),
			rule().condition((type("boolean")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Boolean::parseBoolean).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("integer")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Integer::parseInt).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("double")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Double::parseDouble).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("long")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(Long::parseLong).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("word")), (type("list")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(")).output(mark("type", "firstUpperCase")).output(literal("::valueOf).collect(Collectors.toList());")),
			rule().condition((type("word")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(")).output(mark("type", "firstUpperCase")).output(literal("::valueOf).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("string")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("entity")), (type("set")), (type("component")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nio.intino.ness.master.serialization.MasterSerializer serializer = master.serializer();\nString[] items = triplet.value().split(LIST_SEP);\nthis.")).output(mark("name", "firstLowerCase")).output(literal(" = new ArrayList<>(items.length);\n\nfor(String serializedItem : items) {\n\tTripletRecord item = serializer.deserialize(serializedItem.trim());\n\t")).output(mark("entity", "FirstUpperCase")).output(literal(" entity = new ")).output(mark("entity", "FirstUpperCase")).output(literal("(item.id());\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(".add(entity);\n}")),
			rule().condition((type("entity")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).collect(Collectors.toCollection(LinkedHashSet::new));")),
			rule().condition((type("date")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(s -> java.time.LocalDate.parse(s, java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"))).collect(Collectors.toCollection(LinkedHashSet::new)));")),
			rule().condition((type("datetime")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(s -> java.time.LocalDateTime.parse(s, java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"))).collect(Collectors.toCollection(LinkedHashSet::new)));")),
			rule().condition((type("instant")), (type("set")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : Arrays.stream(triplet.value().split(LIST_SEP)).map(String::trim).map(s -> java.time.Instant.ofEpochMilli(Long.parseLong(s))).collect(Collectors.toCollection(LinkedHashSet::new)));")),
			rule().condition((type("boolean")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? false : Boolean.parseBoolean(triplet.value());")),
			rule().condition((type("integer")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? 0 : Integer.parseInt(triplet.value());")),
			rule().condition((type("double")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? 0.0 : Double.parseDouble(triplet.value());")),
			rule().condition((type("long")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? 0L : Long.parseLong(triplet.value());")),
			rule().condition((type("word")), (type("list")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nif(triplet.value().isEmpty()) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = new ArrayList<>(0);\n\treturn;\n}\n\nString[] items = triplet.value().split(LIST_SEP);\n")).output(mark("name", "firstLowerCase")).output(literal(" = new ArrayList<>(items.length);\n\nfor(String item : items) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(".add(")).output(mark("type", "firstUpperCase")).output(literal(".valueOf(item));\n}")),
			rule().condition((type("word")), (type("set")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nif(triplet.value().isEmpty()) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(" = new LinkedHashSet<>(0);\n\treturn;\n}\n\nString[] items = triplet.value().split(LIST_SEP);\n")).output(mark("name", "firstLowerCase")).output(literal(" = new LinkedHashSet<>(items.length);\n\nfor(String item : items) {\n\t")).output(mark("name", "firstLowerCase")).output(literal(".add(")).output(mark("type", "firstUpperCase")).output(literal(".valueOf(item));\n}")),
			rule().condition((type("word")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : ")).output(mark("type", "firstUpperCase")).output(literal(".valueOf(triplet.value());")),
			rule().condition((type("string")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value();")),
			rule().condition((type("entity")), (type("component")), (trigger("add"))).output(literal("if(triplet.value() == null) {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n\treturn;\n}\n\nTripletRecord r = master.serializer().deserialize(triplet.value().trim());\nthis.")).output(mark("name", "firstLowerCase")).output(literal(" = new ")).output(mark("entity", "FirstUpperCase")).output(literal("(r.id());")),
			rule().condition((type("entity")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal("Reference = triplet.value();")),
			rule().condition((type("date")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : java.time.LocalDate.parse(triplet.value(), java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"));")),
			rule().condition((type("datetime")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : java.time.LocalDateTime.parse(triplet.value(), java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"));")),
			rule().condition((type("instant")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : java.time.Instant.ofEpochMilli(Long.parseLong(triplet.value()));")),
			rule().condition((type("map")), (trigger("add"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null\n\t? null\n\t: java.util.Arrays.stream(triplet.value().split(\";\"))\n\t\t.map(e -> e.split(\"=\"))\n\t\t.collect(java.util.stream.Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));")),
			rule().condition((type("struct")), (trigger("add"))).output(literal("if (triplet.value() == null) {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = null;\n} else {\n\tList<String> values = java.util.Arrays.stream(triplet.value().split(\",\", -1)).map(v -> v.trim()).collect(java.util.stream.Collectors.toList());\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = triplet.value() == null ? null : ")).output(mark("struct", "call")).output(literal(";\n}")),
			rule().condition((type("list")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = null;")),
			rule().condition((type("set")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = null;")),
			rule().condition((type("boolean")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = false;")),
			rule().condition((type("integer")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = 0;")),
			rule().condition((type("double")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = 0;")),
			rule().condition((type("long")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = 0;")),
			rule().condition((type("entity")), (type("component")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = null;")),
			rule().condition((type("entity")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal("Reference = null;")),
			rule().condition((trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = null;")),
			rule().condition((type("struct")), (trigger("remove"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = null;")),
			rule().condition((type("word")), (anyTypes("list","set")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(".stream().map(e -> e.name()).collect(Collectors.joining(LIST_SEP))));")),
			rule().condition((type("word")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : ")).output(mark("name", "firstLowerCase")).output(literal(".name()));")),
			rule().condition((type("struct")), (anyTypes("list","set")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : ")).output(mark("name", "firstLowerCase")).output(literal(".stream().map(Triplet::stringValueOf).collect(Collectors.joining(LIST_SEP))));")),
			rule().condition((type("struct")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : Triplet.stringValueOf(")).output(mark("name", "firstLowerCase")).output(literal(")));")),
			rule().condition((type("entity")), (type("component")), (type("list")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", master.serializer().serialize(new TripletRecord(")).output(mark("name", "firstLowerCase")).output(literal(".stream().flatMap(e -> e.triplets().stream()).collect(Collectors.toMap(Triplet::subject, t->t))))));")),
			rule().condition((type("entity")), (type("component")), (type("set")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", master.serializer().serialize(new TripletRecord(")).output(mark("name", "firstLowerCase")).output(literal(".stream().flatMap(e -> e.triplets().stream()).collect(Collectors.toMap(Triplet::subject, t->t))))));")),
			rule().condition((type("entity")), (type("component")), (type("set")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", master.serializer().serialize(new TripletRecord(")).output(mark("name", "firstLowerCase")).output(literal(".stream().flatMap(e -> e.triplets().stream()).collect(Collectors.toMap(Triplet::subject, t->t))))));")),
			rule().condition((type("entity")), (type("component")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : Triplet.stringValueOf(")).output(mark("name", "firstLowerCase")).output(literal(")));")),
			rule().condition((type("entity")), (type("list")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : String.join(LIST_SEP, ")).output(mark("name", "firstLowerCase")).output(literal(")));")),
			rule().condition((type("entity")), (type("set")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : String.join(LIST_SEP, ")).output(mark("name", "firstLowerCase")).output(literal(")));")),
			rule().condition((type("entity")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal("Reference == null ? null : Triplet.stringValueOf(")).output(mark("name", "firstLowerCase")).output(literal("Reference)));")),
			rule().condition((anyTypes("date","datetime")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : ")).output(mark("name", "firstLowerCase")).output(literal(".format(java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"))));")),
			rule().condition((type("instant")), (trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(" == null ? null : Triplet.stringValueOf(")).output(mark("name", "firstLowerCase")).output(literal(".toEpochMilli())));")),
			rule().condition((trigger("astriplet"))).output(literal("triplets.add(new Triplet(id().get(), \"")).output(mark("name", "firstLowerCase")).output(literal("\", Triplet.stringValueOf(")).output(mark("name", "firstLowerCase")).output(literal(")));")),
			rule().condition((type("word")), (trigger("worddeclaration"))).output(literal("public enum ")).output(mark("name", "firstUpperCase")).output(literal(" {")).output(mark("value").multiple(", ")).output(literal("}")),
			rule().condition((type("struct")), (type("list")), (trigger("field"))).output(literal("protected List<")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(expression().output(literal(" = ")).output(mark("defaultValue"))).output(literal(";")),
			rule().condition((type("struct")), (type("set")), (trigger("field"))).output(literal("protected Set<")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(expression().output(literal(" = ")).output(mark("defaultValue"))).output(literal(";")),
			rule().condition((type("struct")), (trigger("field"))).output(literal("protected ")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(expression().output(literal(" = ")).output(mark("defaultValue"))).output(literal(";")),
			rule().condition((type("entity")), (type("component")), (type("list")), (trigger("field"))).output(literal("protected List<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("entity")), (type("component")), (type("set")), (trigger("field"))).output(literal("protected Set<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("entity")), (type("component")), (trigger("field"))).output(literal("protected ")).output(mark("entity", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("entity")), (type("list")), (trigger("field"))).output(literal("protected List<String> ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("entity")), (type("set")), (trigger("field"))).output(literal("protected Set<String> ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("entity")), (trigger("field"))).output(literal("protected String ")).output(mark("name", "firstLowerCase")).output(literal("Reference;")),
			rule().condition((type("date")), (trigger("field"))).output(literal("protected java.time.LocalDate ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("datetime")), (trigger("field"))).output(literal("protected java.time.LocalDateTime ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition((type("instant")), (trigger("field"))).output(literal("protected java.time.Instant ")).output(mark("name", "firstLowerCase")).output(literal(";")),
			rule().condition(not(type("entity")), (trigger("field"))).output(literal("protected ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(expression().output(literal(" = ")).output(mark("defaultValue"))).output(literal(";")),
			rule().condition((type("word")), (trigger("defaultvalue"))).output(mark("type")).output(literal(".")).output(mark("value")),
			rule().condition((trigger("defaultvalue"))).output(mark("value")),
			rule().condition((type("struct")), (type("list")), (trigger("getterandsetter"))).output(literal("public List<")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(List<")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("struct")), (type("set")), (trigger("getterandsetter"))).output(literal("public Set<")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(Set<")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("struct")), (trigger("getterandsetter"))).output(literal("public ")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("package")).output(literal(".structs.")).output(mark("struct", "structName")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("entity")), (type("component")), (type("list")), (trigger("getterandsetter"))).output(literal("public List<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(List<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("entity")), (type("component")), (type("set")), (trigger("getterandsetter"))).output(literal("public Set<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(Set<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("entity")), (type("component")), (trigger("getterandsetter"))).output(literal("public ")).output(mark("entity", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("entity", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("entity")), (type("list")), (trigger("getterandsetter"))).output(literal("public List<String> ")).output(mark("name", "firstLowerCase")).output(literal("Ids() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic List<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(".stream().map(master::")).output(mark("entity", "firstLowerCase")).output(literal(").collect(Collectors.toList());\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(List<String> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("entity")), (type("set")), (trigger("getterandsetter"))).output(literal("public Set<String> ")).output(mark("name", "firstLowerCase")).output(literal("Ids() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic Set<")).output(mark("entity", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(".stream().map(master::")).output(mark("entity", "firstLowerCase")).output(literal(").collect(Collectors.toCollection(LinkedHashSet::new));\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(Set<String> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("entity")), (trigger("getterandsetter"))).output(literal("public String ")).output(mark("name", "firstLowerCase")).output(literal("Id() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal("Reference;\n}\n\npublic ")).output(mark("entity", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn master.")).output(mark("entity", "firstLowerCase")).output(literal("(")).output(mark("name", "firstLowerCase")).output(literal("Reference);\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(String ")).output(mark("name", "firstLowerCase")).output(literal("Id) {\n\t")).output(mark("name", "firstLowerCase")).output(literal("Reference = ")).output(mark("name", "firstLowerCase")).output(literal("Id;\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("date")), (trigger("getterandsetter"))).output(literal("public java.time.LocalDate ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(java.time.LocalDate ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("datetime")), (trigger("getterandsetter"))).output(literal("public java.time.LocalDateTime ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(java.time.LocalDateTime ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((type("instant")), (trigger("getterandsetter"))).output(literal("public java.time.Instant ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(java.time.Instant ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((trigger("getterandsetter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\npublic ")).output(mark("entityOwner")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";\n\treturn ")).output(mark("castToSubclass")).output(literal("this;\n}")),
			rule().condition((trigger("abstract"))).output(literal("Abstract")),
			rule().condition((trigger("structname"))).output(mark("name", "firstUpperCase")),
			rule().condition((trigger("call"))).output(literal("new ")).output(mark("package")).output(literal(".structs.")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("attribute", "parse").multiple(", ")).output(literal(")")),
			rule().condition((type("boolean")), (trigger("parse"))).output(literal("Boolean.parseBoolean(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("int")), (trigger("parse"))).output(literal("Integer.parseInt(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("long")), (trigger("parse"))).output(literal("Long.parseLong(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("double")), (trigger("parse"))).output(literal("Double.parseDouble(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("date")), (trigger("parse"))).output(literal("java.time.LocalDate.parse(values.get(")).output(mark("index")).output(literal("));")),
			rule().condition((type("datetime")), (trigger("parse"))).output(literal("java.time.LocalDateTime.parse(values.get(")).output(mark("index")).output(literal("));")),
			rule().condition((type("instant")), (trigger("parse"))).output(literal("java.time.Instant.parse(values.get(")).output(mark("index")).output(literal("));")),
			rule().condition((trigger("parse"))).output(literal("values.get(")).output(mark("index")).output(literal(")")),
			rule().condition((trigger("expressiondeclaration"))).output(mark("modifier")).output(literal(" ")).output(mark("returnType")).output(literal(" ")).output(mark("name")).output(literal("(")).output(expression().output(mark("parameter", "parameterDeclaration").multiple(", "))).output(literal(") {\n\t")).output(mark("expression")).output(literal("\n}")),
			rule().condition((trigger("parameterdeclaration"))).output(mark("type")).output(literal(" ")).output(mark("name"))
		);
	}
}