/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.event;

import io.intino.datahub.graph.Table;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.event.TableTemplate;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class TableRenderer {
    private final Table table;
    private final File destination;
    private final String rootPackage;

    public TableRenderer(Table table, File destination, String rootPackage) {
        this.table = table;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        String rootPackage = this.eventsPackage();
        File packageFolder = new File(this.destination, rootPackage.replace(".", File.separator));
        Frame frame = this.createTableFrame(this.table);
        Commons.writeFrame(packageFolder, this.table.name$(), this.template().render((Object)frame));
    }

    private Frame createTableFrame(Table table) {
        return new FrameBuilder(new String[]{"table"}).add("package", (Object)this.eventsPackage()).add("name", (Object)table.name$()).add("column", (Object)this.columns(table.columnList())).add("type", (Object)"table").toFrame();
    }

    private Frame[] columns(List<Table.Column> columns) {
        AtomicInteger index = new AtomicInteger();
        return (Frame[])columns.stream().map(c -> {
            FrameBuilder builder = new FrameBuilder(new String[]{"column", c.asType().getClass().getSimpleName()}).add("name", (Object)c.name$()).add("simpleType", (Object)this.simpleType((Table.Column)c)).add("index", (Object)index.getAndIncrement()).add("type", (Object)c.asType().type());
            if (c.isWord()) {
                builder.add("word", c.asWord().values().toArray(String[]::new));
            }
            return builder.toFrame();
        }).toArray(Frame[]::new);
    }

    private String simpleType(Table.Column c) {
        if (c.isWord()) {
            return c.name$();
        }
        String type = c.asType().type();
        return type.contains(".") ? type.substring(type.lastIndexOf(".") + 1) : type;
    }

    private String eventsPackage() {
        return this.rootPackage + ".events";
    }

    private Template template() {
        return Formatters.customize(new TableTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

