/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class TerminalTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("terminal"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.Scale;\nimport io.intino.alexandria.event.Event;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".events.*;\nimport java.util.List;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\tprivate static final Scale scale = Scale.")}).output(new Rule.Output[]{this.mark("scale", new String[0])}).output(new Rule.Output[]{this.literal(";\n\tprivate final io.intino.alexandria.terminal.Connector connector;\n\tprivate java.util.Map<java.util.function.Consumer<?>, java.util.function.Consumer<io.intino.alexandria.event.Event>> consumers = new java.util.HashMap<>();\n\t")}).output(new Rule.Output[]{this.mark("bpm", new String[]{"splits"})}).output(new Rule.Output[]{this.literal("\n\tpublic static String[] subscriptionChannels = new String[]{")}).output(new Rule.Output[]{this.mark("subscribe", new String[]{"channel"})}).output(new Rule.Output[]{this.literal("};\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(io.intino.alexandria.terminal.Connector connector) {\n\t\tthis.connector = connector;\n\t}\n\n\tpublic void publish(Object event, String split) {\n\t\t")}).output(new Rule.Output[]{this.mark("publish", new String[]{"if"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datalake", new String[0])}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("public BatchSession batch(java.io.File dataHubStageDirectory, java.io.File temporalStageDirectory) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\treturn new BatchSession(dataHubStageDirectory, temporalStageDirectory);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\n\tpublic void publish(io.intino.alexandria.event.SessionEvent session) {\n\t\tconnector.sendEvent(io.intino.alexandria.event.SessionEvent.PATH, session);\n\t}\n\n\tpublic void subscribe(SessionEventConsumer onEventReceived) {\n\t\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.alexandria.event.SessionEvent(event.toMessage())));\n\t\tconnector.attachListener(io.intino.alexandria.event.SessionEvent.PATH, consumers.get(onEventReceived));\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("publish", new String[0]).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.mark("subscribe", new String[0]).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate static final Object monitor = new Object();\n\n\tpublic class BatchSession {\n\t\tprivate final java.io.File dataHubStage;\n\t\tprivate final java.io.File temporalStage;\n\t\tprivate final io.intino.alexandria.ingestion.SessionHandler sessionHandler;\n\t\tprivate final io.intino.alexandria.ingestion.EventSession eventSession;\n\t\tprivate final io.intino.alexandria.ingestion.SetSession setSession;\n\n\t\tpublic BatchSession(java.io.File dataHubStage, java.io.File temporalStage) {\n\t\t\tthis.dataHubStage = dataHubStage;\n\t\t\tthis.temporalStage = temporalStage;\n\t\t\tthis.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);\n\t\t\tthis.eventSession = sessionHandler.createEventSession();\n\t\t\tthis.setSession = sessionHandler.createSetSession();\n\t\t}\n\n\t\tpublic void feed(Event event, String split) {\n            eventSession.put(tankOf(event, split), Timetag.of(event.ts(), scale), event);\n\t\t}\n\n\t\tpublic void feed(String tank, Timetag timetag, String set, java.util.stream.Stream<Long> ids) {\n            setSession.put(tank, timetag, set, ids);\n\t\t}\n\n\t\tpublic void push() {\n\t\t\teventSession.close();\n\t\t\tsetSession.close();\n\t\t\tsessionHandler.pushTo(this.dataHubStage);\n\t\t\t//connector.sendEvent(\"service.ness.push\", new Event(new io.intino.alexandria.message.Message(\"Push\").set(\"stage\", temporalStage.getName())));\n\t\t}\n\n\t\tpublic synchronized void seal() {\n\t\t\tsynchronized(monitor) {\n\t\t\t\tconnector.requestResponse(\"service.ness.seal\", new Event(new io.intino.alexandria.message.Message(\"Seal\").set(\"stage\", temporalStage.getName())).ts(java.time.Instant.now()).toString(), s -> {\n\t\t\t\t\t\tsynchronized(monitor) {\n\t\t\t\t\t\t\tmonitor.notify();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t);\n\t\t\t\ttry {\n\t\t\t\t\tmonitor.wait();\n\t\t\t\t} catch (InterruptedException e) {\n\t\t\t\t\tio.intino.alexandria.logger.Logger.error(e);\n\t\t\t\t}\n\t\t\t}\n        }\n\n        private String tankOf(Event event, String split) {\n        \t")}).output(new Rule.Output[]{this.mark("publish", new String[]{"tankOf"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n        \treturn event.toMessage().type();\n        }\n\t}\n\n\tpublic interface SessionEventConsumer extends java.util.function.Consumer<io.intino.alexandria.event.SessionEvent> {\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("event", new String[]{"interface"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.type("bpm"), new Rule.Condition[]{this.trigger("splits")}).output(new Rule.Output[]{this.literal("public enum BpmSplit {\n\t")}).output(new Rule.Output[]{this.mark("split", new String[]{"asEnum"}).multiple(", ")}).output(new Rule.Output[]{this.literal(";\n\n\tpublic abstract String qn();\n\n\tpublic static BpmSplit splitByQn(String qn) {\n\t\treturn java.util.Arrays.stream(values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);\n\t}\n}")}), this.rule().condition(this.trigger("asenum"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("value", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(" {\n\tpublic String qn() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("qn", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"multisplit", "bpm"}), new Rule.Condition[]{this.trigger("if")}).output(new Rule.Output[]{this.literal("if (event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") publish((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event, BpmSplit.splitByQn(split));")}), this.rule().condition(this.type("multisplit"), new Rule.Condition[]{this.trigger("if")}).output(new Rule.Output[]{this.literal("if (event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") publish((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split.splitByQn(split));")}), this.rule().condition(this.trigger("if"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("if (event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") publish((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event);")}), this.rule().condition(this.type("multisplit"), new Rule.Condition[]{this.not(this.type("bpm")), this.trigger("tankof")}).output(new Rule.Output[]{this.literal("if (event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") return \"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split.splitByQn(split).qn();")}), this.rule().condition(this.not(this.type("bpm")), new Rule.Condition[]{this.trigger("tankof")}).output(new Rule.Output[]{this.literal("if (event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") return \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\";")}), this.rule().condition(this.allTypes(new String[]{"bpm", "multisplit"}), new Rule.Condition[]{this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(", BpmSplit split, BpmSplit... moreSplits) {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + split.qn(), ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\tfor (BpmSplit c : moreSplits) connector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + c.qn(), ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.type("bpm"), new Rule.Condition[]{this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.type("multisplit"), new Rule.Condition[]{this.not(this.type("bpm")), this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split split, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split... moreSplits) {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + split.qn(), ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\tfor (")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split c : moreSplits)\n\t\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + c.qn(), ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.not(this.type("bpm")), new Rule.Condition[]{this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.allTypes(new String[]{"bpm", "multiSplit"}), new Rule.Condition[]{this.trigger("subscribe")}).output(new Rule.Output[]{this.literal("public void subscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, BpmSplit split, BpmSplit... moreSplits) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(event)));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".\" + split.qn(), subscriberId, consumers.get(onEventReceived));\n\tfor (BpmSplit c : moreSplits)\n\t\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".\" + c.qn(), subscriberId, consumers.get(onEventReceived));\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, BpmSplit split, BpmSplit... moreSplits) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(event)));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".\" + split.qn(), consumers.get(onEventReceived));\n\tfor (BpmSplit c : moreSplits)\n\t\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".\" + c.qn(), consumers.get(onEventReceived));\n}\n\npublic void unsubscribe(ProcessStatusConsumer onEventReceived) {\n\tconnector.detachListeners(consumers.get(onEventReceived));\n}")}), this.rule().condition(this.type("multiSplit"), new Rule.Condition[]{this.not(this.type("bpm")), this.trigger("subscribe")}).output(new Rule.Output[]{this.literal("public void subscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split split, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split... moreSplits) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(event)));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + split.qn(), subscriberId, consumers.get(onEventReceived));\n\tfor (")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split c : moreSplits)\n\t\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + c.qn(), subscriberId, consumers.get(onEventReceived));\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split split, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split... moreSplits) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(event)));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + split.qn(), consumers.get(onEventReceived));\n\tfor (")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".Split c : moreSplits)\n\t\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("typeWithNamespace", new String[0])}).output(new Rule.Output[]{this.literal(".\" + c.qn(), consumers.get(onEventReceived));\n}\n\npublic void unsubscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[0])}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconnector.detachListeners(consumers.get(onEventReceived));\n}")}), this.rule().condition(this.trigger("subscribe"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public void subscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(event)));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived));\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(event)));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", consumers.get(onEventReceived));\n}\n\npublic void unsubscribe(")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("typeName", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconnector.detachListeners(consumers.get(onEventReceived));\n}")}), this.rule().condition(this.trigger("quoted"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("", new String[0])}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.trigger("interface"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public interface ")}).output(new Rule.Output[]{this.mark("namespace", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer extends java.util.function.Consumer<")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("> {\n}")})});
    }
}

