/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import com.google.gson.Gson;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Namespace;
import io.intino.datahub.graph.Terminal;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.AccessorPomTemplate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.Manifest;
import io.intino.ness.datahubterminalplugin.TerminalRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

class TerminalPublisher {
    private final File root;
    private final Terminal terminal;
    private final Configuration conf;
    private final String terminalJmsVersion;
    private final String bpmVersion;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private final List<Datalake.Tank.Event> tanks;

    TerminalPublisher(File root, Terminal terminal, List<Datalake.Tank.Event> tanks, Configuration configuration, String terminalJmsVersion, String bpmVersion, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger) {
        this.root = root;
        this.terminal = terminal;
        this.tanks = tanks;
        this.conf = configuration;
        this.terminalJmsVersion = terminalJmsVersion;
        this.bpmVersion = bpmVersion;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
    }

    boolean publish() {
        if (!this.createSources()) {
            return false;
        }
        try {
            this.logger.println("Publishing " + this.terminal.name$() + "...");
            this.mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Terminal " + this.terminal.name$() + " published!");
        }
        catch (Exception e) {
            this.logger.println(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean createSources() {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        Map<Event, Datalake.Split> eventSplitMap = this.collectEvents(this.tanks);
        new TerminalRenderer(this.terminal, eventSplitMap, srcDirectory, this.basePackage).render();
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        this.writeManifest(resDirectory);
        return true;
    }

    private void writeManifest(File srcDirectory) {
        List<String> publish = this.terminal.publish() != null ? this.terminal.publish().tanks().stream().map(this::eventQn).collect(Collectors.toList()) : Collections.emptyList();
        List<String> subscribe = this.terminal.subscribe() != null ? this.terminal.subscribe().tanks().stream().map(this::eventQn).collect(Collectors.toList()) : Collections.emptyList();
        Manifest manifest = new Manifest(this.terminal.name$(), this.basePackage + "." + Formatters.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString()), publish, subscribe, this.tankClasses(), this.eventSplits());
        try {
            Files.write(new File(srcDirectory, "terminal.mf").toPath(), new Gson().toJson((Object)manifest).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String namespace(Event event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn() + "." : "";
    }

    private String terminalNameArtifact() {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)this.terminal.name$()).toString());
    }

    private Map<String, Set<String>> eventSplits() {
        HashMap<String, Set<String>> eventSplits;
        Map<String, Set<String>> map = eventSplits = this.terminal.publish() == null ? new HashMap<String, Set<String>>() : this.eventSplitOf(this.terminal.publish().tanks());
        if (this.terminal.subscribe() == null) {
            return eventSplits;
        }
        Map<String, Set<String>> subscribeEventSplits = this.eventSplitOf(this.terminal.subscribe().tanks());
        for (String eventType : subscribeEventSplits.keySet()) {
            if (!eventSplits.containsKey(eventType)) {
                eventSplits.put(eventType, new HashSet());
            }
            ((Set)eventSplits.get(eventType)).addAll((Collection)subscribeEventSplits.get(eventType));
        }
        return eventSplits;
    }

    private Map<String, Set<String>> eventSplitOf(List<Datalake.Tank.Event> tanks) {
        return tanks.stream().collect(Collectors.toMap(this::eventQn, tank -> tank.asTank().isSplitted() ? tank.asTank().asSplitted().split().leafs().stream().map(Datalake.Split::qn).collect(Collectors.toSet()) : Collections.emptySet(), (a, b) -> b));
    }

    private Map<String, String> tankClasses() {
        HashMap<String, String> tankClasses = new HashMap<String, String>();
        if (this.terminal.publish() != null) {
            this.terminal.publish().tanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Event)t), this.basePackage + ".events." + this.namespace(t.event()).toLowerCase() + t.event().name$()));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().tanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Event)t), this.basePackage + ".events." + this.namespace(t.event()).toLowerCase() + t.event().name$()));
        }
        if (this.terminal.bpm() != null) {
            Datalake.Split split = this.terminal.bpm().split();
            String statusQn = this.terminal.bpm().processStatusClass();
            String statusClassName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
            tankClasses.put((String)(split != null ? split.qn() + "." : "") + statusClassName, statusQn);
        }
        return tankClasses;
    }

    private String eventQn(Datalake.Tank.Event t) {
        return this.namespace(t.event()) + t.event().name$();
    }

    private Map<Event, Datalake.Split> collectEvents(List<Datalake.Tank.Event> tanks) {
        HashMap<Event, Datalake.Split> events = new HashMap<Event, Datalake.Split>();
        for (Datalake.Tank.Event tank : tanks) {
            List<Event> hierarchy = this.hierarchy(tank.event());
            Datalake.Split split = tank.asTank().isSplitted() ? tank.asTank().asSplitted().split() : null;
            events.put(hierarchy.get(0), split);
            hierarchy.remove(0);
            hierarchy.forEach(e -> events.put((Event)e, (Datalake.Split)null));
        }
        return events;
    }

    private List<Event> hierarchy(Event event) {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.add(event);
        if (event.isExtensionOf()) {
            events.addAll(this.hierarchy(event.asExtensionOf().parent()));
        }
        return new ArrayList<Event>(events);
    }

    private void mvn(String goal) throws IOException, MavenInvocationException {
        File pom = this.createPom(this.root, this.basePackage, this.terminalNameArtifact(), this.conf.artifact().version());
        InvocationResult result = this.invoke(pom, goal);
        if (result != null && result.getExitCode() != 0) {
            if (result.getExecutionException() != null) {
                throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
            }
            throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
        }
        if (result == null) {
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private InvocationResult invoke(File pom, String goal) throws MavenInvocationException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        if (!goal.isEmpty()) {
            goals.add(goal);
        }
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(goals);
        Invoker invoker = new DefaultInvoker().setMavenHome(this.systemProperties.mavenHome);
        this.log(invoker);
        this.config(request, this.systemProperties.mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) {
        invoker.setErrorHandler(l -> {
            if (!l.startsWith("[WARN]")) {
                this.logger.println(l);
            }
        });
        invoker.setOutputHandler(s -> {});
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        request.setJavaHome(this.systemProperties.javaHome);
    }

    private File createPom(File root, String group, String artifact, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)artifact).add("version", (Object)version);
        this.conf.repositories().forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r));
        if (this.conf.artifact().distribution() != null) {
            if (this.isSnapshotVersion()) {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().snapshot());
            } else {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().release());
            }
        }
        builder.add("ontology", (Object)this.ontologyFrame(group, version));
        if (this.terminal.bpm() != null) {
            builder.add("hasBpm", (Object)this.bpmVersion);
        }
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new AccessorPomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private boolean isSnapshotVersion() {
        return this.conf.artifact().version().contains("SNAPSHOT");
    }

    private FrameBuilder ontologyFrame(String group, String version) {
        return new FrameBuilder(new String[]{"ontology"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("terminalVersion", (Object)this.terminalJmsVersion).add("version", (Object)version);
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).toFrame());
    }

    private void buildDistroFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).add("distribution").toFrame());
    }

    private FrameBuilder createRepositoryFrame(Configuration.Repository repository) {
        return new FrameBuilder(new String[]{"repository", repository.getClass().getSimpleName()}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url());
    }
}

