/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.event;

import io.intino.datahub.graph.Attribute;
import io.intino.datahub.graph.Component;
import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Namespace;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.event.EventTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EventRenderer {
    private static final String EVENT = "io.intino.alexandria.event.Event";
    private final Event event;
    private final Datalake.Context context;
    private final File destination;
    private final String rootPackage;

    public EventRenderer(Event event, Datalake.Context context, File destination, String rootPackage) {
        this.event = event;
        this.context = context;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        Object rootPackage = this.eventsPackage();
        if (this.event.core$().owner().is(Namespace.class)) {
            rootPackage = (String)rootPackage + "." + ((Namespace)this.event.core$().ownerAs(Namespace.class)).name$();
        }
        File packageFolder = new File(this.destination, ((String)rootPackage).replace(".", File.separator));
        Frame frame = this.createEventFrame(this.event, (String)rootPackage);
        Commons.writeFrame(packageFolder, this.event.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", rootPackage).add("package", rootPackage).add("event", (Object)frame)));
    }

    private Frame createEventFrame(Event event, String packageName) {
        FrameBuilder eventFrame = new FrameBuilder(new String[]{"event"}).add("name", (Object)event.name$()).add("package", (Object)packageName).add("parent", (Object)(event.isExtensionOf() ? event.asExtensionOf().parent().name$() : EVENT));
        if (event.isExtensionOf()) {
            eventFrame.add("parentSuper", (Object)event.name$());
        }
        eventFrame.add("attribute", (Object)this.processAttributes(event.attributeList(), event.name$()));
        Map<Component, Boolean> components = this.collectComponents(event);
        if (!components.isEmpty()) {
            eventFrame.add("component", (Object)this.processComponents(components, event.name$()));
        }
        if (this.context != null) {
            List leafs = this.context.isLeaf() != false ? Collections.singletonList(this.context) : this.context.leafs();
            eventFrame.add("context", (Object)new FrameBuilder().add("context").add("enum", (Object)this.enums(this.context, leafs)));
        }
        return eventFrame.toFrame();
    }

    private FrameBuilder[] processAttributes(List<Attribute> attributes, String owner) {
        FrameBuilder[] frames = (FrameBuilder[])attributes.stream().map(this::process).toArray(FrameBuilder[]::new);
        Arrays.stream(frames).forEach(f -> f.add("owner", (Object)owner));
        return frames;
    }

    private FrameBuilder[] processComponents(Map<Component, Boolean> components, String owner) {
        return (FrameBuilder[])components.entrySet().stream().map(e -> this.processComponent((Component)e.getKey(), owner, (Boolean)e.getValue())).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder processComponent(Component component, String owner, boolean multiple) {
        Map<Component, Boolean> components;
        FrameBuilder builder = new FrameBuilder(new String[]{"component", multiple ? "multiple" : "single"}).add("name", (Object)component.name$()).add("type", (Object)component.name$()).add("owner", (Object)owner).add("attribute", (Object)this.processAttributes(component.attributeList(), component.name$()));
        if (component.isExtensionOf()) {
            builder.add("parent", (Object)component.asExtensionOf().parent().name$());
        }
        if (!(components = this.collectComponents(component)).isEmpty()) {
            builder.add("component", (Object)this.processComponents(components, component.name$()));
        }
        return builder;
    }

    private Map<Component, Boolean> collectComponents(Event event) {
        Map<Component, Boolean> components = event.componentList().stream().collect(Collectors.toMap(c -> c, Component::multiple));
        components.putAll(event.hasList().stream().collect(Collectors.toMap(Event.Has::element, Event.Has::multiple)));
        return components;
    }

    private Map<Component, Boolean> collectComponents(Component component) {
        Map<Component, Boolean> components = component.componentList().stream().collect(Collectors.toMap(c -> c, Component::multiple));
        components.putAll(component.hasList().stream().collect(Collectors.toMap(Component.Has::element, Component.Has::multiple)));
        return components;
    }

    private FrameBuilder process(Attribute attribute) {
        if (attribute.isReal()) {
            return this.process(attribute.asReal());
        }
        if (attribute.isInteger()) {
            return this.process(attribute.asInteger());
        }
        if (attribute.isBool()) {
            return this.process(attribute.asBool());
        }
        if (attribute.isText()) {
            return this.process(attribute.asText());
        }
        if (attribute.isDateTime()) {
            return this.process(attribute.asDateTime());
        }
        if (attribute.isDate()) {
            return this.process(attribute.asDate());
        }
        if (attribute.isLongInteger()) {
            return this.process(attribute.asLongInteger());
        }
        if (attribute.isWord()) {
            return this.process(attribute.asWord());
        }
        if (attribute.isTable()) {
            return this.process(attribute.asTable());
        }
        return null;
    }

    private Frame[] enums(Datalake.Context realContext, List<Datalake.Context> leafs) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        if (!leafs.contains(realContext) && !realContext.label().isEmpty()) {
            frames.add(new FrameBuilder(new String[]{"enum"}).add("value", (Object)realContext.qn().replace(".", "-")).toFrame());
        }
        for (Datalake.Context leaf : leafs) {
            FrameBuilder builder = new FrameBuilder(new String[]{"enum"}).add("value", (Object)leaf.qn().replace(".", "-")).add("qn", (Object)leaf.qn());
            frames.add(builder.toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private FrameBuilder process(Data.Real attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", "double"}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)(!this.multiple((Data.Type)attribute) ? "double" : attribute.type())).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("objectType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Integer attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)(!this.multiple((Data.Type)attribute) ? "int" : attribute.type())).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("objectType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.LongInteger attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("defaultValue", (Object)(attribute.defaultValue() + "L"));
    }

    private FrameBuilder process(Data.Bool attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Text attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.DateTime attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("defaultValue", (Object)"null");
    }

    private FrameBuilder process(Data.Date attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("type", (Object)attribute.type());
    }

    private FrameBuilder process(Data.Word attribute) {
        Attribute a = (Attribute)attribute.a$(Attribute.class);
        return new FrameBuilder(new String[]{"primitive", "word", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)a.name$()).add("words", (Object)attribute.values().toArray(new String[0])).add("type", (Object)a.name$());
    }

    private FrameBuilder process(Data.Table attribute) {
        return new FrameBuilder(new String[]{"table"}).add("name", (Object)attribute.name$()).add("table", (Object)attribute.table().name$()).add("package", (Object)this.eventsPackage()).add("type", (Object)"table");
    }

    private String eventsPackage() {
        return this.rootPackage + ".events";
    }

    private boolean multiple(Data.Type attribute) {
        return attribute.asData().isList();
    }

    private Template template() {
        return Formatters.customize(new EventTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

