/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Namespace;
import io.intino.datahub.graph.Terminal;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.TerminalTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class TerminalRenderer {
    private final Terminal terminal;
    private final Map<Event, Datalake.Context> eventWithContext;
    private final File srcDir;
    private final String rootPackage;

    TerminalRenderer(Terminal terminal, Map<Event, Datalake.Context> eventWithContext, File srcDir, String rootPackage) {
        this.terminal = terminal;
        this.eventWithContext = eventWithContext;
        this.srcDir = srcDir;
        this.rootPackage = rootPackage;
    }

    void render() {
        File packageFolder = new File(this.srcDir, this.rootPackage.replace(".", File.separator));
        Commons.writeFrame(packageFolder, Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString(), this.template().render((Object)this.createTerminalFrame()));
    }

    private Frame createTerminalFrame() {
        Datalake datalake = this.terminal.graph().datalake();
        FrameBuilder builder = new FrameBuilder(new String[]{"terminal"}).add("package", (Object)this.rootPackage).add("name", (Object)this.terminal.name$());
        if (datalake != null) {
            builder.add("scale", (Object)datalake.scale().name());
        }
        builder.add("event", this.eventWithContext.keySet().stream().map(e -> new FrameBuilder(new String[]{"event"}).add("name", (Object)e.name$()).add("type", (Object)(this.eventPackage((Event)e) + "." + Formatters.firstUpperCase(e.name$()))).toFrame()).toArray(Frame[]::new));
        if (this.terminal.publish() != null) {
            this.terminal.publish().tanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Event)tank)));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().tanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Event)tank)));
        }
        if (this.terminal.allowsBpmIn() != null) {
            this.addBpm(builder);
        }
        return builder.toFrame();
    }

    private void addBpm(FrameBuilder builder) {
        Datalake.Context context = this.terminal.allowsBpmIn().context();
        ArrayList<Datalake.Context> leafs = new ArrayList<Datalake.Context>();
        if (context != null) {
            leafs.addAll(context.isLeaf() != false ? Collections.singletonList(context) : context.leafs());
            builder.add("bpm", (Object)new FrameBuilder(new String[]{"bpm"}).add("context", (Object)this.enums(context, leafs)));
        }
        String statusQn = this.terminal.allowsBpmIn().processStatusClass();
        String processStatusQName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
        FrameBuilder bpmBuilder = new FrameBuilder(new String[]{leafs.size() > 1 ? "multicontext" : "default", "bpm"}).add("type", (Object)statusQn).add("typeName", (Object)processStatusQName);
        if (leafs.size() <= 1) {
            bpmBuilder.add("channel", (Object)((String)(leafs.size() == 1 ? ((Datalake.Context)leafs.get(0)).qn() + "." : "") + processStatusQName));
        }
        builder.add("subscribe", (Object)bpmBuilder);
        builder.add("publish", (Object)bpmBuilder);
        builder.add("event", (Object)new FrameBuilder(new String[]{"event"}).add("name", (Object)processStatusQName).add("type", (Object)statusQn).toFrame());
    }

    private Frame[] enums(Datalake.Context realContext, List<Datalake.Context> leafs) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        if (!leafs.contains(realContext) && !realContext.label().isEmpty()) {
            frames.add(new FrameBuilder(new String[]{"enum"}).add("value", (Object)realContext.qn().replace(".", "-")).toFrame());
        }
        for (Datalake.Context leaf : leafs) {
            FrameBuilder builder = new FrameBuilder(new String[]{"enum"}).add("value", (Object)leaf.qn().replace(".", "-")).add("qn", (Object)leaf.qn());
            frames.add(builder.toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame frameOf(Datalake.Tank.Event eventTank) {
        String eventPackage = this.eventPackage(eventTank.event());
        String namespace = this.eventNamespace(eventTank.event());
        return new FrameBuilder(new String[]{this.contextsOf(eventTank).size() > 1 ? "multicontext" : "default"}).add("type", (Object)(eventPackage + "." + Formatters.firstUpperCase(eventTank.event().name$()))).add("typeName", (Object)eventTank.event().name$()).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(eventTank.event().name$()))).add("channel", (Object)eventTank.qn()).toFrame();
    }

    private String eventPackage(Event event) {
        Object eventPackage = this.eventsPackage();
        if (event.core$().owner().is(Namespace.class)) {
            eventPackage = (String)eventPackage + "." + this.eventNamespace(event);
        }
        return eventPackage;
    }

    private String eventNamespace(Event event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).name$().toLowerCase() : "";
    }

    private String eventsPackage() {
        return this.rootPackage + ".events";
    }

    private List<Datalake.Context> contextsOf(Datalake.Tank.Event tank) {
        return tank.asTank().isContextual() ? tank.asTank().asContextual().context().leafs() : Collections.emptyList();
    }

    private Template template() {
        return Formatters.customize(new TerminalTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

