package io.intino.ness.datahubterminalplugin.event;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class EventTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((type("root"))).output(literal("package ")).output(mark("package", "ValidPackage")).output(literal(";\n\n")).output(mark("event")),
			rule().condition((trigger("event"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(expression().output(literal("extends ")).output(mark("parent"))).output(literal(" implements java.io.Serializable {\n\t")).output(mark("context")).output(literal("\n\n\t")).output(expression().output(mark("attribute", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("() {\n\t\t")).output(expression().output(literal("super(new io.intino.alexandria.event.Event(\"")).output(mark("parentSuper")).output(literal("\"))")).next(expression().output(literal("super(\"")).output(mark("name")).output(literal("\")")))).output(literal(";\n\t}\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(io.intino.alexandria.event.Event event) {\n\t\tthis(event.toMessage());\n\t}\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(io.intino.alexandria.message.Message message) {\n\t\tsuper(message);\n\t}\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal(" ts(java.time.Instant ts) {\n\t\tsuper.ts(ts);\n\t\treturn this;\n\t}\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal(" ss(String ss) {\n\t\tsuper.ss(ss);\n\t\treturn this;\n\t}\n\n\t")).output(expression().output(mark("attribute", "getter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("component", "getter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("attribute", "setter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("component", "setter").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("attribute", "table").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("component").multiple("\n\n"))).output(literal("\n}")),
			rule().condition((trigger("component"))).output(literal("public static class ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(expression().output(literal("extends ")).output(mark("parent"))).output(literal(" implements java.io.Serializable {\n\t")).output(expression().output(mark("attribute", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("parent", "delegate")).next(expression().output(literal("protected io.intino.alexandria.message.Message message;")))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("() {\n\t\t")).output(expression().output(literal("this(new io.intino.alexandria.message.Message(\"")).output(mark("parentSuper")).output(literal("\")")).next(expression().output(literal("this.message = new io.intino.alexandria.message.Message(\"")).output(mark("name")).output(literal("\");")))).output(literal("\n\t}\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(io.intino.alexandria.message.Message message) {\n\t\t")).output(expression().output(literal("super(message)")).output(mark("parent", "delegate")).next(expression().output(literal("this.message = message;")))).output(literal("\n\t}\n\n\t")).output(mark("attribute", "getter").multiple("\n\n")).output(literal("\n\n\t")).output(mark("component", "getter").multiple("\n\n")).output(literal("\n\n\t")).output(mark("attribute", "setter").multiple("\n\n")).output(literal("\n\n\t")).output(mark("component", "setter").multiple("\n\n")).output(literal("\n\n\t")).output(expression().output(mark("component").multiple("\n\n"))).output(literal("\n\n\tpublic io.intino.alexandria.message.Message toMessage() {\n\t\treturn this.message;\n\t}\n}")),
			rule().condition((type("table")), (trigger("table"))).output(literal("public static class ")).output(mark("name", "firstUpperCase")).output(literal("Table implements java.io.Serializable {\n\tprivate final java.util.List<io.intino.alexandria.message.Message.Value[]> table;\n\tpublic enum Column {")).output(mark("column", "name").multiple(", ")).output(literal("}\n\n\t")).output(mark("column", "enum").multiple("\n\n")).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("Table(java.util.List<io.intino.alexandria.message.Message.Value[]> table) {\n\t\tthis.table = table;\n\t}\n\n\tpublic Row row(int index) {\n\t\treturn new Row(table.get(index));\n\t}\n\n\tpublic java.util.stream.Stream<Row> rows() {\n\t\treturn table.stream().map(r -> new Row(r));\n\t}\n\n\t")).output(mark("column", "getter").multiple("\n\n")).output(literal("\n\n\tpublic String toString() {\n\t\treturn table.stream().\n\t\t\tmap(r->String.join(\"\\t\", java.util.Arrays.stream(r).map(io.intino.alexandria.message.Message.Value::asString).toArray(String[]::new))).\n\t\t\tcollect(java.util.stream.Collectors.joining(\"\\n\"));\n\t}\n\n\tpublic static class Row {\n\t\tprivate io.intino.alexandria.message.Message.Value[] values;\n\n\t\tRow(io.intino.alexandria.message.Message.Value[] values) {\n\t\t\tthis.values = values;\n\t\t}\n\n\n\t\t")).output(mark("column", "rowGetter").multiple("\n\n")).output(literal("\n\n\t\t")).output(mark("column", "rowSetter").multiple("\n\n")).output(literal("\n\t}\n}")),
			rule().condition((type("column")), (trigger("name"))).output(mark("name")),
			rule().condition((allTypes("column","word")), (trigger("enum"))).output(literal("public enum ")).output(mark("name", "FirstUpperCase")).output(literal(" {\n\t")).output(mark("word").multiple(", ")).output(literal(";\n}")),
			rule().condition((type("default")), (trigger("super"))).output(literal("super(\")")),
			rule().condition((trigger("context"))).output(literal("public enum Context {\n\t")).output(mark("enum", "asEnum").multiple(", ")).output(literal(";\n\n\tpublic abstract String qn();\n\n\tpublic static Context contextByQn(String qn) {\n\t\treturn java.util.Arrays.stream(values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);\n\t}\n}")),
			rule().condition((trigger("asenum"))).output(mark("value", "snakeCaseToCamelCase")).output(literal(" {\n\tpublic String qn() {\n\t\treturn \"")).output(mark("qn")).output(literal("\";\n\t}\n}")),
			rule().condition((trigger("delegate"))).output(literal(";\n")),
			rule().condition((allTypes("word","single")), (trigger("declaration"))).output(literal("public enum ")).output(mark("name", "FirstUpperCase")).output(literal(" {\n\t")).output(mark("words").multiple(", ")).output(literal("\n}\n")),
			rule().condition((allTypes("word","multiple")), (trigger("declaration"))).output(literal("public enum ")).output(mark("name", "FirstUpperCase")).output(literal(" {\n\t")).output(mark("words").multiple(", ")).output(literal("\n}\n")),
			rule().condition((type("component")), (trigger("declaration"))).output(literal("private java.util.List<")).output(mark("type")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("List = null;")),
			rule().condition((allTypes("word","single")), (trigger("getter"))).output(literal("public ")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "FirstLowerCase")).output(literal("() {\n\treturn !message.contains(\"")).output(mark("name", "FirstLowerCase")).output(literal("\") ? null : ")).output(mark("name", "FirstUpperCase")).output(literal(".valueOf(message.get(\"")).output(mark("name", "FirstLowerCase")).output(literal("\").asString());\n}")),
			rule().condition((allTypes("word","multiple")), (trigger("getter"))).output(literal("public java.util.List<")).output(mark("type", "FirstUpperCase")).output(literal("> ")).output(mark("name", "FirstLowerCase")).output(literal("() {\n\tif (!message.contains(\"")).output(mark("name", "FirstLowerCase")).output(literal("\")) return java.util.Collections.emptyList();\n\treturn java.util.Collections.unmodifiableList(java.util.Arrays.asList(message.get(\"")).output(mark("name", "FirstLowerCase")).output(literal("\").as(String[].class)).map(v -> ")).output(mark("name", "FirstUpperCase")).output(literal(".valueOf(v)).collect(java.util.stream.Collectors.toList()));\n}")),
			rule().condition((type("table")), (trigger("getter"))).output(literal("public ")).output(mark("name", "FirstUpperCase")).output(literal("Table ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn new ")).output(mark("name", "FirstUpperCase")).output(literal("Table(message.get(\"")).output(mark("name")).output(literal("\").asTable());\n}")),
			rule().condition((allTypes("column","word")), (trigger("getter"))).output(literal("public ")).output(mark("simpleType", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(int index) {\n\treturn ")).output(mark("name", "FirstUpperCase")).output(literal(".valueOf(table.get(Column.")).output(mark("name")).output(literal(".ordinal())[index].asString());\n}\n\npublic java.util.stream.Stream<")).output(mark("simpleType", "FirstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn java.util.List.of(table.get(Column.errorTag.ordinal())).stream().map(v -> ErrorTag.valueOf(v.asString()));\n}")),
			rule().condition((allTypes("column","word")), (trigger("rowgetter"))).output(literal("public ")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "FirstUpperCase")).output(literal(".valueOf(values[(Column.")).output(mark("name")).output(literal(".ordinal())].asString());\n}")),
			rule().condition((type("column")), (trigger("rowgetter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn values[(Column.")).output(mark("name")).output(literal(".ordinal())].as")).output(mark("simpleType")).output(literal("();\n}")),
			rule().condition((type("column")), (trigger("getter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(int index) {\n\treturn table.get(index)[(Column.")).output(mark("name")).output(literal(".ordinal())].as")).output(mark("simpleType")).output(literal("();\n}\n\npublic java.util.stream.Stream<")).output(mark("type")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn table.stream().map(r -> r[Column.")).output(mark("name")).output(literal(".ordinal()].as")).output(mark("simpleType")).output(literal("());\n}")),
			rule().condition((allTypes("primitive","single")), not(attribute("defaultvalue", "null")), (trigger("getter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn message.get(\"")).output(mark("name", "FirstLowerCase")).output(literal("\").as")).output(mark("simpleType")).output(literal("();\n}")),
			rule().condition((allTypes("primitive","single")), (trigger("getter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn !message.contains(\"")).output(mark("name", "FirstLowerCase")).output(literal("\") ? ")).output(mark("defaultValue")).output(literal(" : message.get(\"")).output(mark("name", "FirstLowerCase")).output(literal("\").as")).output(mark("simpleType")).output(literal("();\n}")),
			rule().condition((allTypes("primitive","multiple")), (trigger("getter"))).output(literal("public java.util.List<")).output(mark("type")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn new java.util.ArrayList<")).output(mark("type")).output(literal(">(message.contains(\"")).output(mark("name", "FirstLowerCase")).output(literal("\") ? java.util.Arrays.asList(message.get(\"")).output(mark("name", "FirstLowerCase")).output(literal("\").as(")).output(mark("type")).output(literal("[].class)) : java.util.Collections.emptyList()) {\n\t\t@Override\n\t\tpublic boolean add(")).output(mark("type")).output(literal(" value) {\n\t\t\tsuper.add(value);\n\t\t\tmessage.append(\"")).output(mark("name", "FirstLowerCase")).output(literal("\", value);\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic void add(int index, ")).output(mark("type")).output(literal(" element) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean remove(Object value) {\n\t\t\tif (!(value instanceof ")).output(mark("type")).output(literal(")) return false;\n\t\t\tsuper.remove(value);\n\t\t\tmessage.remove(\"")).output(mark("name", "FirstLowerCase")).output(literal("\", value);\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic ")).output(mark("type")).output(literal(" remove(int index) {\n\t\t\t")).output(mark("type")).output(literal(" type = get(index);\n\t\t\tremove(type);\n\t\t\treturn type;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean removeIf(java.util.function.Predicate<? super ")).output(mark("type")).output(literal("> filter) {\n\t\t\treturn removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean removeAll(java.util.Collection<?> c) {\n\t\t\tc.forEach(this::remove);\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean addAll(java.util.Collection<? extends ")).output(mark("type")).output(literal("> c) {\n\t\t\tc.forEach(this::add);\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean addAll(int index, java.util.Collection<? extends ")).output(mark("type")).output(literal("> c) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\t};\n}")),
			rule().condition((allTypes("word","single")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("type", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tif (")).output(mark("name", "firstLowerCase")).output(literal(" == null) this.message.remove(\"")).output(mark("name", "firstLowerCase")).output(literal("\");\n\telse this.message.set(\"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(".name());\n\treturn this;\n}")),
			rule().condition((allTypes("word","multiple")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(java.util.List<")).output(mark("type", "FirstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.message.remove(\"")).output(mark("name", "firstLowerCase")).output(literal("\");\n\t")).output(mark("name", "firstLowerCase")).output(literal(".forEach(v -> this.message.append(\"")).output(mark("name", "firstLowerCase")).output(literal("\", v.name()));\n\treturn this;\n}")),
			rule().condition((allTypes("primitive","single")), (anyTypes("integer","double")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.message.set(\"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")),
			rule().condition((allTypes("primitive","single")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tif (")).output(mark("name", "firstLowerCase")).output(literal(" == null) this.message.remove(\"")).output(mark("name", "firstLowerCase")).output(literal("\");\n\telse this.message.set(\"")).output(mark("name", "firstLowerCase")).output(literal("\", ")).output(mark("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")),
			rule().condition((allTypes("primitive","multiple")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(java.util.List<")).output(mark("type")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.message.remove(\"")).output(mark("name", "firstLowerCase")).output(literal("\");\n\t")).output(mark("name", "firstLowerCase")).output(literal(".forEach(v -> this.message.append(\"")).output(mark("name", "firstLowerCase")).output(literal("\", v));\n\treturn this;\n}")),
			rule().condition((type("component")), not(type("single")), (trigger("getter"))).output(literal("public java.util.List<")).output(mark("type")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("List() {\n\tif (this.")).output(mark("name", "firstLowerCase")).output(literal("List != null) return this.")).output(mark("name", "firstLowerCase")).output(literal("List;\n\treturn this.")).output(mark("name", "firstLowerCase")).output(literal("List = new java.util.ArrayList<")).output(mark("type")).output(literal(">(message.components(\"")).output(mark("type")).output(literal("\").stream().map(c -> new ")).output(mark("type")).output(literal("(c)).collect(java.util.stream.Collectors.toList())) {\n\t\t@Override\n\t\tpublic boolean add(")).output(mark("type")).output(literal(" element) {\n\t\t\tsuper.add(element);\n\t\t\tmessage.add(element.toMessage());\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic void add(int index, ")).output(mark("type")).output(literal(" element) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean remove(Object o) {\n\t\t\tif (!(o instanceof ")).output(mark("type")).output(literal(")) return false;\n\t\t\tsuper.remove(o);\n\t\t\tmessage.remove(((")).output(mark("type")).output(literal(") o).toMessage());\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic ")).output(mark("type")).output(literal(" remove(int index) {\n\t\t\t")).output(mark("type")).output(literal(" type = get(index);\n\t\t\tremove(type);\n\t\t\treturn type;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean removeIf(java.util.function.Predicate<? super ")).output(mark("type")).output(literal("> filter) {\n\t\t\treturn removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean removeAll(java.util.Collection<?> c) {\n\t\t\tc.forEach(this::remove);\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean addAll(java.util.Collection<? extends ")).output(mark("type")).output(literal("> c) {\n\t\t\tc.forEach(this::add);\n\t\t\treturn true;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean addAll(int index, java.util.Collection<? extends ")).output(mark("type")).output(literal("> c) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\t};\n}")),
			rule().condition((type("component")), (type("single")), (trigger("getter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\tjava.util.List<io.intino.alexandria.message.Message> components = message.components(\"")).output(mark("type")).output(literal("\");\n\treturn components.isEmpty() ? null : new ")).output(mark("type")).output(literal("(components.get(0));\n}")),
			rule().condition((type("component")), (type("single")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(")).output(mark("type", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tthis.message.components(\"")).output(mark("type")).output(literal("\").forEach(v -> this.message.remove(v));\n\tif (")).output(mark("name", "firstLowerCase")).output(literal(" != null) this.message.add(")).output(mark("name", "firstLowerCase")).output(literal(".toMessage());\n\treturn this;\n}")),
			rule().condition((allTypes("multiple","component")), (trigger("setter"))).output(literal("public ")).output(mark("owner", "firstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("List(java.util.List<")).output(mark("type", "firstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal(") {\n\tnew java.util.ArrayList(this.")).output(mark("name", "firstLowerCase")).output(literal("List()).forEach(v -> this.")).output(mark("name", "firstLowerCase")).output(literal("List.remove(v));\n\tthis.")).output(mark("name", "firstLowerCase")).output(literal("List.addAll(")).output(mark("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}"))
		);
	}
}