/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.transaction;

import io.intino.Configuration;
import io.intino.datahub.graph.Attribute;
import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Dimension;
import io.intino.datahub.graph.Namespace;
import io.intino.datahub.graph.Transaction;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.transaction.TransactionTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionRenderer {
    private final Transaction transaction;
    private final Configuration conf;
    private final Datalake.Split split;
    private final File destination;
    private final String rootPackage;
    private final Map<String, Integer> dimensionSizes = new HashMap<String, Integer>();

    public TransactionRenderer(Transaction transaction, Configuration conf, Datalake.Split split, File destination, String rootPackage) {
        this.transaction = transaction;
        this.conf = conf;
        this.split = split;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        Object transactionsPackage = this.transactionsPackage();
        if (this.transaction.core$().owner().is(Namespace.class)) {
            transactionsPackage = (String)transactionsPackage + "." + ((Namespace)this.transaction.core$().ownerAs(Namespace.class)).qn();
        }
        File packageFolder = new File(this.destination, ((String)transactionsPackage).replace(".", File.separator));
        Frame frame = this.createTransactionFrame(this.transaction, (String)transactionsPackage);
        FrameBuilder builder = new FrameBuilder(new String[]{"root"}).add("root", transactionsPackage).add("package", transactionsPackage).add("transaction", (Object)frame);
        if (!this.transaction.graph().dimensionList().isEmpty()) {
            builder.add("dimensionsImport", (Object)this.rootPackage);
        }
        Commons.writeFrame(packageFolder, this.transaction.name$(), this.template().render((Object)builder));
    }

    private Frame createTransactionFrame(Transaction transaction, String packageName) {
        this.calculateAttributeSizes(transaction.attributeList());
        FrameBuilder builder = new FrameBuilder(new String[]{"transaction"}).add("name", (Object)transaction.name$()).add("package", (Object)packageName).add("size", (Object)((int)Math.ceil((float)this.sizeOf(transaction) / 8.0f)));
        builder.add("id", transaction.attributeList().stream().filter(Data::isId).map(Layer::name$).findFirst().orElse(null));
        builder.add("attribute", (Object)this.processAttributes(new ArrayList<Attribute>(transaction.attributeList()), transaction.name$()));
        if (this.split != null) {
            List leafs = this.split.isLeaf() != false ? Collections.singletonList(this.split) : this.split.leafs();
            builder.add("split", (Object)new FrameBuilder().add("split").add("enum", (Object)this.enums(this.split, leafs)));
        }
        return builder.toFrame();
    }

    private int sizeOf(Transaction transaction) {
        return transaction.attributeList().stream().map(a -> a.asType().size()).reduce(Integer::sum).get();
    }

    private FrameBuilder[] processAttributes(List<Attribute> attributes, String owner) {
        ArrayList<FrameBuilder> frameBuilders = new ArrayList<FrameBuilder>();
        int offset = 0;
        Attribute idAttribute = attributes.stream().filter(Data::isId).findFirst().orElse(null);
        if (idAttribute != null) {
            offset = this.processAttribute(owner, frameBuilders, offset, idAttribute);
        }
        attributes.remove(idAttribute);
        attributes.sort(Comparator.comparingInt(a -> a.asType().size()));
        Collections.reverse(attributes);
        for (Attribute attribute : attributes) {
            offset = this.processAttribute(owner, frameBuilders, offset, attribute);
        }
        return frameBuilders.toArray(new FrameBuilder[0]);
    }

    private int processAttribute(String owner, List<FrameBuilder> frameBuilders, int offset, Attribute attribute) {
        FrameBuilder b = this.process(attribute, offset);
        if (b != null) {
            offset += attribute.asType().size();
            frameBuilders.add(b.add("owner", (Object)owner));
        }
        return offset;
    }

    private void calculateAttributeSizes(List<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (!attribute.isDimension()) continue;
            attribute.asType().size(this.sizeOf(attribute.asDimension().dimension()).intValue());
        }
    }

    private FrameBuilder process(Attribute attribute, int offset) {
        if (attribute.isDimension()) {
            return this.process(attribute.asDimension(), offset);
        }
        return this.processAttribute(attribute.asType(), offset);
    }

    private FrameBuilder processAttribute(Data.Type attribute, int offset) {
        FrameBuilder builder = new FrameBuilder(new String[]{"attribute"}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("offset", (Object)offset).add("type", (Object)(this.isPrimitive(attribute) ? attribute.primitive() : attribute.type()));
        attribute.core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        if (this.isAligned(attribute, offset)) {
            builder.add("aligned", (Object)"Aligned");
        } else {
            builder.add("bits", (Object)attribute.size());
        }
        builder.add("size", (Object)attribute.size());
        if (attribute.asData().isDateTime()) {
            builder.add("precision", (Object)"");
        } else if (attribute.asData().isDate()) {
            builder.add("precision", (Object)"");
        }
        return builder;
    }

    private Frame[] enums(Datalake.Split realSplit, List<Datalake.Split> leafs) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        if (!leafs.contains(realSplit) && !realSplit.label().isEmpty()) {
            frames.add(new FrameBuilder(new String[]{"enum"}).add("value", (Object)realSplit.qn().replace(".", "-")).toFrame());
        }
        for (Datalake.Split leaf : leafs) {
            FrameBuilder builder = new FrameBuilder(new String[]{"enum"}).add("value", (Object)leaf.qn().replace(".", "-")).add("qn", (Object)leaf.qn());
            frames.add(builder.toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private boolean isAligned(Data.Type attribute, int offset) {
        return offset % 8 == 0 && attribute.maxSize() == attribute.size();
    }

    private FrameBuilder process(Data.Dimension attribute, int offset) {
        FrameBuilder builder = new FrameBuilder(new String[]{"attribute", "dimension"}).add("name", (Object)attribute.name$()).add("type", (Object)attribute.dimension().name$()).add("offset", (Object)offset).add("bits", (Object)attribute.size());
        if (attribute.dimension().isInResource()) {
            builder.add("resource").add("resource", (Object)this.resource(attribute.dimension()));
        } else {
            builder.add("category", (Object)this.categories(attribute.dimension()));
        }
        return builder;
    }

    private String resource(Dimension dimension) {
        String s = dimension.asInResource().tsv().toString();
        return this.conf.artifact().groupId().replace(".", "/") + "/ontology/" + new File(s).getName();
    }

    private boolean isPrimitive(Data.Type attribute) {
        Data data = attribute.asData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isId() || data.isReal();
    }

    private String[] categories(Dimension wordBag) {
        return (String[])wordBag.asInline().categoryList().stream().map(w -> w.name$() + "(" + w.value() + ")").toArray(String[]::new);
    }

    private Integer sizeOf(Dimension dimension) {
        try {
            if (dimension.isInline()) {
                return (int)Math.ceil(TransactionRenderer.log2(dimension.asInline().categoryList().size() + 1));
            }
            if (!this.dimensionSizes.containsKey(dimension.name$())) {
                this.dimensionSizes.put(dimension.name$(), (int)Math.ceil(TransactionRenderer.log2(this.countLines(dimension.asInResource()) + 1)));
            }
            return this.dimensionSizes.get(dimension.name$());
        }
        catch (IOException e) {
            return 0;
        }
    }

    private int countLines(Dimension.InResource dimension) throws IOException {
        return (int)new BufferedReader(new InputStreamReader(dimension.tsv().openStream())).lines().count();
    }

    private String transactionsPackage() {
        return this.rootPackage + ".transaction";
    }

    private Template template() {
        return Formatters.customize(new TransactionTemplate());
    }

    public static double log2(int N) {
        return Math.log(N) / Math.log(2.0);
    }
}

