/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.transaction;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.Dimension;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.transaction.DimensionTemplate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class DimensionRenderer {
    private final Dimension dimension;
    private final Configuration conf;
    private final File destination;
    private final List<File> resDirectories;
    private final String rootPackage;

    public DimensionRenderer(Dimension dimension, Configuration conf, File destination, List<File> resDirectories, String rootPackage) {
        this.dimension = dimension;
        this.conf = conf;
        this.destination = destination;
        this.resDirectories = resDirectories;
        this.rootPackage = rootPackage;
    }

    public void render() {
        String rootPackage = this.wordBagPackage();
        File packageFolder = new File(this.destination, rootPackage.replace(".", File.separator));
        Frame frame = this.process(this.dimension);
        Commons.writeFrame(packageFolder, this.dimension.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", (Object)rootPackage).add("package", (Object)rootPackage).add("dimension", (Object)frame)));
    }

    private Frame process(Dimension dimension) {
        FrameBuilder builder = new FrameBuilder(new String[]{"dimension"}).add("name", (Object)dimension.name$()).add("type", (Object)(dimension.isInResource() ? String.class.getSimpleName() : dimension.name$()));
        if (dimension.isInResource()) {
            builder.add("resource").add("resource", (Object)this.resource(dimension));
            List columnList = dimension.asInResource().attributeList();
            for (int i = 0; i < columnList.size(); ++i) {
                boolean primitive = this.isPrimitive(((Dimension.InResource.Attribute)columnList.get(i)).asType());
                FrameBuilder b = new FrameBuilder(new String[]{"column"}).add("name", (Object)((Dimension.InResource.Attribute)columnList.get(i)).name$()).add("index", (Object)i).add("type", (Object)(primitive ? ((Dimension.InResource.Attribute)columnList.get(i)).asType().primitive() : ((Dimension.InResource.Attribute)columnList.get(i)).asType().type()));
                ((Dimension.InResource.Attribute)columnList.get(i)).core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)b).add(arg_0));
                if (primitive) {
                    b.add("primitive");
                }
                builder.add("column", (Object)b.toFrame());
            }
        } else {
            builder.add("category", (Object)this.categories(dimension));
        }
        return builder.toFrame();
    }

    private boolean isPrimitive(Data.Type attribute) {
        Data data = attribute.asData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isReal();
    }

    private String resource(Dimension dimension) {
        try {
            Path source = new File(dimension.asInResource().tsv().getPath()).getCanonicalFile().toPath();
            for (File resDirectory : this.resDirectories) {
                try {
                    return resDirectory.toPath().relativize(source).toFile().getPath().replace("\\", "/");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return null;
    }

    private Frame[] categories(Dimension dimension) {
        return (Frame[])dimension.asInline().categoryList().stream().map(w -> new FrameBuilder(new String[]{"category"}).add("name", (Object)w.name$()).add("index", (Object)w.value()).add("label", (Object)w.label()).toFrame()).toArray(Frame[]::new);
    }

    private Template template() {
        return Formatters.customize(new DimensionTemplate());
    }

    private String wordBagPackage() {
        return this.rootPackage + ".dimension";
    }
}

