/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.wordbag;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Municipios {
    private static final Map<Integer, Word> words = new HashMap<Integer, Word>();
    private static final Map<String, Word> wordsByName = new HashMap<String, Word>();

    public static List<Word> words() {
        return new ArrayList<Word>(words.values());
    }

    public static List<Word> words(Predicate<Word> filter) {
        return words.values().stream().filter(filter).collect(Collectors.toList());
    }

    public static Word wordByIndex(int index) {
        return words.get(index);
    }

    public static Word wordByName(String name) {
        return wordsByName.get(name);
    }

    public static Word wordByRfc(String rfc) {
        return words.values().stream().filter(c -> c.rfc.equals(rfc)).findFirst().orElse(null);
    }

    public static Word wordByMunicipio(String municipio) {
        return words.values().stream().filter(c -> c.municipio.equals(municipio)).findFirst().orElse(null);
    }

    public static Word wordByDireccion(String direccion) {
        return words.values().stream().filter(c -> c.direccion.equals(direccion)).findFirst().orElse(null);
    }

    public static Word wordByCodigoPostal(String codigoPostal) {
        return words.values().stream().filter(c -> c.codigoPostal.equals(codigoPostal)).findFirst().orElse(null);
    }

    public static Word wordByEstado(String estado) {
        return words.values().stream().filter(c -> c.estado.equals(estado)).findFirst().orElse(null);
    }

    public static Word wordByPais(String pais) {
        return words.values().stream().filter(c -> c.pais.equals(pais)).findFirst().orElse(null);
    }

    static {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Municipios.class.getResourceAsStream("/io/provista/datahub/municipios.tsv")));){
            reader.lines().map(l -> l.split("\t")).map(l -> new Word(((String[])l).length > 0 ? Integer.valueOf(Integer.parseInt(l[0])) : null, ((String[])l).length > 1 ? l[1] : null, ((String[])l).length > 2 ? l[2] : null, ((String[])l).length > 3 ? l[3] : null, ((String[])l).length > 4 ? l[4] : null, ((String[])l).length > 5 ? l[5] : null, ((String[])l).length > 6 ? l[6] : null, ((String[])l).length > 7 ? l[7] : null)).forEach(w -> {
                words.put(w.index, (Word)w);
                wordsByName.put(w.name, (Word)w);
            });
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static class Word {
        public final int index;
        public final String name;
        public final String rfc;
        public final String municipio;
        public final String direccion;
        public final String codigoPostal;
        public final String estado;
        public final String pais;

        Word(int index, String name, String rfc, String municipio, String direccion, String codigoPostal, String estado, String pais) {
            this.index = index;
            this.name = name;
            this.rfc = rfc;
            this.municipio = municipio;
            this.direccion = direccion;
            this.codigoPostal = codigoPostal;
            this.estado = estado;
            this.pais = pais;
        }
    }
}

