/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.wordbag;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Estados {
    private static final Map<Integer, Word> words = new HashMap<Integer, Word>();
    private static final Map<String, Word> wordsByName = new HashMap<String, Word>();

    public static List<Word> words() {
        return new ArrayList<Word>(words.values());
    }

    public static List<Word> words(Predicate<Word> filter) {
        return words.values().stream().filter(filter).collect(Collectors.toList());
    }

    public static Word wordByIndex(int index) {
        return words.get(index);
    }

    public static Word wordByName(String name) {
        return wordsByName.get(name);
    }

    public static Word wordByLabel(String label) {
        return words.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(null);
    }

    static {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Estados.class.getResourceAsStream("/io/provista/datahub/estados.tsv")));){
            reader.lines().map(l -> l.split("\t")).map(l -> new Word(((String[])l).length > 0 ? Integer.valueOf(Integer.parseInt(l[0])) : null, ((String[])l).length > 1 ? l[1] : null, ((String[])l).length > 2 ? l[2] : null)).forEach(w -> {
                words.put(w.index, (Word)w);
                wordsByName.put(w.name, (Word)w);
            });
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static class Word {
        public final int index;
        public final String name;
        public final String label;

        Word(int index, String name, String label) {
            this.index = index;
            this.name = name;
            this.label = label;
        }
    }
}

