/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.wordbag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CentroGestor {
    private static final Map<Short, Word> words = new HashMap<Short, Word>();
    private static final Map<String, Word> wordsByName = new HashMap<String, Word>();

    public static List<Word> words() {
        return new ArrayList<Word>(words.values());
    }

    public static List<Word> words(Predicate<Word> filter) {
        return words.values().stream().filter(filter).collect(Collectors.toList());
    }

    public static Word wordByIndex(short index) {
        return words.get(index);
    }

    public static Word wordByName(String name) {
        return wordsByName.get(name);
    }

    public static Word wordByLabel(String label) {
        return words.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(new Word(0, null));
    }

    static {
        Word w = new Word(1, "DA");
        words.put((short)1, w);
        wordsByName.put("DA", w);
        w = new Word(2, "MB");
        words.put((short)2, w);
        wordsByName.put("MB", w);
    }

    public static class Word {
        public final short index;
        public final String name;
        public final String label;

        Word(short index, String name) {
            this(index, name, name);
        }

        Word(short index, String name, String label) {
            this.index = index;
            this.name = name;
            this.label = label;
        }
    }
}

