/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.transaction;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import io.provista.datahub.wordbag.Conceptos;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class VentaPendienteCobro
extends Transaction {
    public static final int SIZE = 17;

    public VentaPendienteCobro() {
        super(VentaPendienteCobro.defaultByteStore());
    }

    public VentaPendienteCobro(ByteStore store) {
        super(store);
    }

    public int size() {
        return 17;
    }

    protected long id() {
        return this.ocr();
    }

    public long ocr() {
        return this.bitBuffer.getAlignedLong(0);
    }

    public Integer importe() {
        return this.bitBuffer.getAlignedInteger(64);
    }

    public Integer diasVencidos() {
        return this.bitBuffer.getIntegerNBits(96, 16);
    }

    public Integer kwh() {
        return this.bitBuffer.getIntegerNBits(112, 16);
    }

    public Conceptos.Word concepto() {
        int value = this.bitBuffer.getIntegerNBits(128, 8);
        return (long)value == 0L ? null : Conceptos.wordByIndex(value);
    }

    public VentaPendienteCobro ocr(long ocr) {
        this.bitBuffer.setAlignedLong(0, ocr);
        return this;
    }

    public VentaPendienteCobro importe(int importe) {
        this.bitBuffer.setAlignedInteger(64, importe);
        return this;
    }

    public VentaPendienteCobro diasVencidos(int diasVencidos) {
        this.bitBuffer.setIntegerNBits(96, 16, diasVencidos);
        return this;
    }

    public VentaPendienteCobro kwh(int kwh) {
        this.bitBuffer.setIntegerNBits(112, 16, kwh);
        return this;
    }

    public VentaPendienteCobro concepto(String concepto) {
        this.bitBuffer.setIntegerNBits(128, 8, concepto == null ? 0 : Conceptos.wordByName((String)concepto).index);
        return this;
    }

    public VentaPendienteCobro concepto(Conceptos.Word concepto) {
        this.bitBuffer.setIntegerNBits(128, 8, concepto == null ? 0 : concepto.index);
        return this;
    }

    private static ByteStore defaultByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer((long)17L);
        MemoryAddress address = MemoryAddress.of((ByteBuffer)buffer);
        return new ByteBufferStore(buffer, address, 0, buffer.capacity());
    }

    public static enum Split {
        D2{

            @Override
            public String qn() {
                return "D2";
            }
        }
        ,
        DA{

            @Override
            public String qn() {
                return "DA";
            }
        }
        ,
        DB{

            @Override
            public String qn() {
                return "DB";
            }
        }
        ,
        DC{

            @Override
            public String qn() {
                return "DC";
            }
        }
        ,
        DD{

            @Override
            public String qn() {
                return "DD";
            }
        }
        ,
        DF{

            @Override
            public String qn() {
                return "DF";
            }
        }
        ,
        DG{

            @Override
            public String qn() {
                return "DG";
            }
        }
        ,
        DJ{

            @Override
            public String qn() {
                return "DJ";
            }
        }
        ,
        DK{

            @Override
            public String qn() {
                return "DK";
            }
        }
        ,
        DL{

            @Override
            public String qn() {
                return "DL";
            }
        }
        ,
        DM{

            @Override
            public String qn() {
                return "DM";
            }
        }
        ,
        DN{

            @Override
            public String qn() {
                return "DN";
            }
        }
        ,
        DP{

            @Override
            public String qn() {
                return "DP";
            }
        }
        ,
        DU{

            @Override
            public String qn() {
                return "DU";
            }
        }
        ,
        DV{

            @Override
            public String qn() {
                return "DV";
            }
        }
        ,
        DW{

            @Override
            public String qn() {
                return "DW";
            }
        }
        ,
        DX{

            @Override
            public String qn() {
                return "DX";
            }
        };


        public abstract String qn();

        public static Split splitByQn(String qn) {
            return Arrays.stream(Split.values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
        }
    }
}

