/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.transaction;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import io.provista.datahub.wordbag.CentroCoste;
import io.provista.datahub.wordbag.CentroGestor;
import io.provista.datahub.wordbag.Codigo;
import io.provista.datahub.wordbag.Convenio;
import io.provista.datahub.wordbag.Divisiones;
import io.provista.datahub.wordbag.Municipios;
import io.provista.datahub.wordbag.Tipo;
import java.nio.ByteBuffer;
import java.time.Instant;

public class SolicitudGestionComercial
extends Transaction {
    public static final int SIZE = 61;

    public SolicitudGestionComercial() {
        super(SolicitudGestionComercial.defaultByteStore());
    }

    public SolicitudGestionComercial(ByteStore store) {
        super(store);
    }

    public int size() {
        return 61;
    }

    public long dap() {
        return this.bitBuffer.getAlignedLong(0);
    }

    public long importe() {
        return this.bitBuffer.getAlignedLong(64);
    }

    public long consumo() {
        return this.bitBuffer.getAlignedLong(128);
    }

    public Instant hasta() {
        return Instant.ofEpochMilli(this.bitBuffer.getLongNBits(192, 64));
    }

    public Instant desde() {
        return Instant.ofEpochMilli(this.bitBuffer.getAlignedLong(256));
    }

    public long rpu() {
        return this.bitBuffer.getLongNBits(320, 64);
    }

    public Integer tasaIva() {
        return this.bitBuffer.getIntegerNBits(384, 32);
    }

    public Integer periodo() {
        return this.bitBuffer.getIntegerNBits(416, 32);
    }

    public Tipo.Word tipo() {
        short value = this.bitBuffer.getShortNBits(448, 2);
        return (long)value == 0L ? null : Tipo.wordByIndex(value);
    }

    public Codigo.Word codigo() {
        short value = this.bitBuffer.getShortNBits(450, 2);
        return (long)value == 0L ? null : Codigo.wordByIndex(value);
    }

    public Municipios.Word municipio() {
        int value = this.bitBuffer.getIntegerNBits(452, 12);
        return (long)value == 0L ? null : Municipios.wordByIndex(value);
    }

    public CentroCoste.Word centroCoste() {
        short value = this.bitBuffer.getShortNBits(464, 2);
        return (long)value == 0L ? null : CentroCoste.wordByIndex(value);
    }

    public CentroGestor.Word centroGestor() {
        short value = this.bitBuffer.getShortNBits(466, 2);
        return (long)value == 0L ? null : CentroGestor.wordByIndex(value);
    }

    public Divisiones.Word division() {
        int value = this.bitBuffer.getIntegerNBits(468, 5);
        return (long)value == 0L ? null : Divisiones.wordByIndex(value);
    }

    public Convenio.Word convenio() {
        short value = this.bitBuffer.getShortNBits(473, 2);
        return (long)value == 0L ? null : Convenio.wordByIndex(value);
    }

    public long id() {
        return this.bitBuffer.getLongNBits(475, 8);
    }

    public SolicitudGestionComercial dap(long dap) {
        this.bitBuffer.setAlignedLong(0, dap);
        return this;
    }

    public SolicitudGestionComercial importe(long importe) {
        this.bitBuffer.setAlignedLong(64, importe);
        return this;
    }

    public SolicitudGestionComercial consumo(long consumo) {
        this.bitBuffer.setAlignedLong(128, consumo);
        return this;
    }

    public SolicitudGestionComercial hasta(Instant hasta) {
        this.bitBuffer.setLongNBits(192, 64, hasta.toEpochMilli());
        return this;
    }

    public SolicitudGestionComercial desde(Instant desde) {
        this.bitBuffer.setAlignedLong(256, desde.toEpochMilli());
        return this;
    }

    public SolicitudGestionComercial rpu(long rpu) {
        this.bitBuffer.setLongNBits(320, 64, rpu);
        return this;
    }

    public SolicitudGestionComercial tasaIva(int tasaIva) {
        this.bitBuffer.setIntegerNBits(384, 32, tasaIva);
        return this;
    }

    public SolicitudGestionComercial periodo(int periodo) {
        this.bitBuffer.setIntegerNBits(416, 32, periodo);
        return this;
    }

    public SolicitudGestionComercial tipo(String tipo) {
        this.bitBuffer.setIntegerNBits(448, 2, tipo == null ? 0 : (int)Tipo.wordByName((String)tipo).index);
        return this;
    }

    public SolicitudGestionComercial tipo(Tipo.Word tipo) {
        this.bitBuffer.setIntegerNBits(448, 2, (int)(tipo == null ? (short)0 : tipo.index));
        return this;
    }

    public SolicitudGestionComercial codigo(String codigo) {
        this.bitBuffer.setIntegerNBits(450, 2, codigo == null ? 0 : (int)Codigo.wordByName((String)codigo).index);
        return this;
    }

    public SolicitudGestionComercial codigo(Codigo.Word codigo) {
        this.bitBuffer.setIntegerNBits(450, 2, (int)(codigo == null ? (short)0 : codigo.index));
        return this;
    }

    public SolicitudGestionComercial municipio(String municipio) {
        this.bitBuffer.setIntegerNBits(452, 12, municipio == null ? 0 : Municipios.wordByName((String)municipio).index);
        return this;
    }

    public SolicitudGestionComercial municipio(Municipios.Word municipio) {
        this.bitBuffer.setIntegerNBits(452, 12, municipio == null ? 0 : municipio.index);
        return this;
    }

    public SolicitudGestionComercial centroCoste(String centroCoste) {
        this.bitBuffer.setIntegerNBits(464, 2, centroCoste == null ? 0 : (int)CentroCoste.wordByName((String)centroCoste).index);
        return this;
    }

    public SolicitudGestionComercial centroCoste(CentroCoste.Word centroCoste) {
        this.bitBuffer.setIntegerNBits(464, 2, (int)(centroCoste == null ? (short)0 : centroCoste.index));
        return this;
    }

    public SolicitudGestionComercial centroGestor(String centroGestor) {
        this.bitBuffer.setIntegerNBits(466, 2, centroGestor == null ? 0 : (int)CentroGestor.wordByName((String)centroGestor).index);
        return this;
    }

    public SolicitudGestionComercial centroGestor(CentroGestor.Word centroGestor) {
        this.bitBuffer.setIntegerNBits(466, 2, (int)(centroGestor == null ? (short)0 : centroGestor.index));
        return this;
    }

    public SolicitudGestionComercial division(String division) {
        this.bitBuffer.setIntegerNBits(468, 5, division == null ? 0 : Divisiones.wordByName((String)division).index);
        return this;
    }

    public SolicitudGestionComercial division(Divisiones.Word division) {
        this.bitBuffer.setIntegerNBits(468, 5, division == null ? 0 : division.index);
        return this;
    }

    public SolicitudGestionComercial convenio(String convenio) {
        this.bitBuffer.setIntegerNBits(473, 2, convenio == null ? 0 : (int)Convenio.wordByName((String)convenio).index);
        return this;
    }

    public SolicitudGestionComercial convenio(Convenio.Word convenio) {
        this.bitBuffer.setIntegerNBits(473, 2, (int)(convenio == null ? (short)0 : convenio.index));
        return this;
    }

    public SolicitudGestionComercial id(long id) {
        this.bitBuffer.setLongNBits(475, 8, id);
        return this;
    }

    private static ByteStore defaultByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer((long)61L);
        MemoryAddress address = MemoryAddress.of((ByteBuffer)buffer);
        return new ByteBufferStore(buffer, address, 0, buffer.capacity());
    }
}

