/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.transaction;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import java.nio.ByteBuffer;

public class Movimiento
extends Transaction {
    public static final int SIZE = 16;

    public Movimiento() {
        super(Movimiento.defaultByteStore());
    }

    public Movimiento(ByteStore store) {
        super(store);
    }

    public int size() {
        return 16;
    }

    protected long id() {
        return this.ocr();
    }

    public long ocr() {
        return this.bitBuffer.getAlignedLong(0);
    }

    public Integer tag() {
        return this.bitBuffer.getAlignedInteger(64);
    }

    public Integer importe() {
        return this.bitBuffer.getIntegerNBits(96, 32);
    }

    public Movimiento ocr(long ocr) {
        this.bitBuffer.setAlignedLong(0, ocr);
        return this;
    }

    public Movimiento tag(int tag) {
        this.bitBuffer.setAlignedInteger(64, tag);
        return this;
    }

    public Movimiento importe(int importe) {
        this.bitBuffer.setIntegerNBits(96, 32, importe);
        return this;
    }

    private static ByteStore defaultByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer((long)16L);
        MemoryAddress address = MemoryAddress.of((ByteBuffer)buffer);
        return new ByteBufferStore(buffer, address, 0, buffer.capacity());
    }
}

