/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.transaction;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import java.nio.ByteBuffer;

public class ContratoAnalizado
extends Transaction {
    public static final int SIZE = 14;

    public ContratoAnalizado() {
        super(ContratoAnalizado.defaultByteStore());
    }

    public ContratoAnalizado(ByteStore store) {
        super(store);
    }

    public int size() {
        return 14;
    }

    protected long id() {
        return this.rpu();
    }

    public long rpu() {
        return this.bitBuffer.getAlignedLong(0);
    }

    public Integer cpd3() {
        return this.bitBuffer.getIntegerNBits(64, 8);
    }

    public Integer cpd2() {
        return this.bitBuffer.getIntegerNBits(72, 8);
    }

    public Integer cpd1() {
        return this.bitBuffer.getIntegerNBits(80, 8);
    }

    public Integer cpd0() {
        return this.bitBuffer.getIntegerNBits(88, 8);
    }

    public Integer indiceMorosidad() {
        return this.bitBuffer.getIntegerNBits(96, 8);
    }

    public Integer indiceRentabilidad() {
        return this.bitBuffer.getIntegerNBits(104, 8);
    }

    public ContratoAnalizado rpu(long rpu) {
        this.bitBuffer.setAlignedLong(0, rpu);
        return this;
    }

    public ContratoAnalizado cpd3(int cpd3) {
        this.bitBuffer.setIntegerNBits(64, 8, cpd3);
        return this;
    }

    public ContratoAnalizado cpd2(int cpd2) {
        this.bitBuffer.setIntegerNBits(72, 8, cpd2);
        return this;
    }

    public ContratoAnalizado cpd1(int cpd1) {
        this.bitBuffer.setIntegerNBits(80, 8, cpd1);
        return this;
    }

    public ContratoAnalizado cpd0(int cpd0) {
        this.bitBuffer.setIntegerNBits(88, 8, cpd0);
        return this;
    }

    public ContratoAnalizado indiceMorosidad(int indiceMorosidad) {
        this.bitBuffer.setIntegerNBits(96, 8, indiceMorosidad);
        return this;
    }

    public ContratoAnalizado indiceRentabilidad(int indiceRentabilidad) {
        this.bitBuffer.setIntegerNBits(104, 8, indiceRentabilidad);
        return this;
    }

    private static ByteStore defaultByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer((long)14L);
        MemoryAddress address = MemoryAddress.of((ByteBuffer)buffer);
        return new ByteBufferStore(buffer, address, 0, buffer.capacity());
    }
}

