/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.transaction;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import io.provista.datahub.wordbag.Agencias;
import io.provista.datahub.wordbag.Giros;
import io.provista.datahub.wordbag.Hilos;
import io.provista.datahub.wordbag.Municipios;
import io.provista.datahub.wordbag.Sectores;
import io.provista.datahub.wordbag.Tarifas;
import io.provista.datahub.wordbag.TiposPersona;
import java.nio.ByteBuffer;

public class Contrato
extends Transaction {
    public static final int SIZE = 29;

    public Contrato() {
        super(Contrato.defaultByteStore());
    }

    public Contrato(ByteStore store) {
        super(store);
    }

    public int size() {
        return 29;
    }

    protected long id() {
        return this.rpu();
    }

    public Double cargaContratada() {
        return this.bitBuffer.getAlignedReal64Bits(0);
    }

    public Double cargaInstalada() {
        return this.bitBuffer.getAlignedReal64Bits(64);
    }

    public long rpu() {
        return this.bitBuffer.getAlignedLong(128);
    }

    public Tarifas.Word tarifa() {
        int value = this.bitBuffer.getIntegerNBits(192, 7);
        return (long)value == 0L ? null : Tarifas.wordByIndex(value);
    }

    public TiposPersona.Word tipoPersona() {
        short value = this.bitBuffer.getShortNBits(199, 2);
        return (long)value == 0L ? null : TiposPersona.wordByIndex(value);
    }

    public Hilos.Word hilos() {
        short value = this.bitBuffer.getShortNBits(201, 2);
        return (long)value == 0L ? null : Hilos.wordByIndex(value);
    }

    public Sectores.Word sector() {
        short value = this.bitBuffer.getShortNBits(203, 3);
        return (long)value == 0L ? null : Sectores.wordByIndex(value);
    }

    public Giros.Word giro() {
        short value = this.bitBuffer.getShortNBits(206, 3);
        return (long)value == 0L ? null : Giros.wordByIndex(value);
    }

    public Agencias.Word agencia() {
        int value = this.bitBuffer.getIntegerNBits(209, 10);
        return (long)value == 0L ? null : Agencias.wordByIndex(value);
    }

    public Municipios.Word municipio() {
        int value = this.bitBuffer.getIntegerNBits(219, 12);
        return (long)value == 0L ? null : Municipios.wordByIndex(value);
    }

    public Contrato cargaContratada(double cargaContratada) {
        this.bitBuffer.setAlignedReal64Bits(0, cargaContratada);
        return this;
    }

    public Contrato cargaInstalada(double cargaInstalada) {
        this.bitBuffer.setAlignedReal64Bits(64, cargaInstalada);
        return this;
    }

    public Contrato rpu(long rpu) {
        this.bitBuffer.setAlignedLong(128, rpu);
        return this;
    }

    public Contrato tarifa(String tarifa) {
        this.bitBuffer.setIntegerNBits(192, 7, tarifa == null ? 0 : Tarifas.wordByName((String)tarifa).index);
        return this;
    }

    public Contrato tarifa(Tarifas.Word tarifa) {
        this.bitBuffer.setIntegerNBits(192, 7, tarifa == null ? 0 : tarifa.index);
        return this;
    }

    public Contrato tipoPersona(String tipoPersona) {
        this.bitBuffer.setIntegerNBits(199, 2, tipoPersona == null ? 0 : (int)TiposPersona.wordByName((String)tipoPersona).index);
        return this;
    }

    public Contrato tipoPersona(TiposPersona.Word tipoPersona) {
        this.bitBuffer.setIntegerNBits(199, 2, (int)(tipoPersona == null ? (short)0 : tipoPersona.index));
        return this;
    }

    public Contrato hilos(String hilos) {
        this.bitBuffer.setIntegerNBits(201, 2, hilos == null ? 0 : (int)Hilos.wordByName((String)hilos).index);
        return this;
    }

    public Contrato hilos(Hilos.Word hilos) {
        this.bitBuffer.setIntegerNBits(201, 2, (int)(hilos == null ? (short)0 : hilos.index));
        return this;
    }

    public Contrato sector(String sector) {
        this.bitBuffer.setIntegerNBits(203, 3, sector == null ? 0 : (int)Sectores.wordByName((String)sector).index);
        return this;
    }

    public Contrato sector(Sectores.Word sector) {
        this.bitBuffer.setIntegerNBits(203, 3, (int)(sector == null ? (short)0 : sector.index));
        return this;
    }

    public Contrato giro(String giro) {
        this.bitBuffer.setIntegerNBits(206, 3, giro == null ? 0 : (int)Giros.wordByName((String)giro).index);
        return this;
    }

    public Contrato giro(Giros.Word giro) {
        this.bitBuffer.setIntegerNBits(206, 3, (int)(giro == null ? (short)0 : giro.index));
        return this;
    }

    public Contrato agencia(String agencia) {
        this.bitBuffer.setIntegerNBits(209, 10, agencia == null ? 0 : Agencias.wordByName((String)agencia).index);
        return this;
    }

    public Contrato agencia(Agencias.Word agencia) {
        this.bitBuffer.setIntegerNBits(209, 10, agencia == null ? 0 : agencia.index);
        return this;
    }

    public Contrato municipio(String municipio) {
        this.bitBuffer.setIntegerNBits(219, 12, municipio == null ? 0 : Municipios.wordByName((String)municipio).index);
        return this;
    }

    public Contrato municipio(Municipios.Word municipio) {
        this.bitBuffer.setIntegerNBits(219, 12, municipio == null ? 0 : municipio.index);
        return this;
    }

    private static ByteStore defaultByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer((long)29L);
        MemoryAddress address = MemoryAddress.of((ByteBuffer)buffer);
        return new ByteBufferStore(buffer, address, 0, buffer.capacity());
    }
}

