/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.transaction;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.MemoryAddress;
import io.intino.alexandria.led.util.MemoryUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Cobro
extends Transaction {
    public static final int SIZE = 12;

    public Cobro() {
        super(Cobro.defaultByteStore());
    }

    public Cobro(ByteStore store) {
        super(store);
    }

    public int size() {
        return 12;
    }

    protected long id() {
        return this.ocr();
    }

    public long ocr() {
        return this.bitBuffer.getAlignedLong(0);
    }

    public Integer importe() {
        return this.bitBuffer.getAlignedInteger(64);
    }

    public Cobro ocr(long ocr) {
        this.bitBuffer.setAlignedLong(0, ocr);
        return this;
    }

    public Cobro importe(int importe) {
        this.bitBuffer.setAlignedInteger(64, importe);
        return this;
    }

    private static ByteStore defaultByteStore() {
        ByteBuffer buffer = MemoryUtils.allocBuffer((long)12L);
        MemoryAddress address = MemoryAddress.of((ByteBuffer)buffer);
        return new ByteBufferStore(buffer, address, 0, buffer.capacity());
    }

    public static enum Split {
        D2{

            @Override
            public String qn() {
                return "D2";
            }
        }
        ,
        DA{

            @Override
            public String qn() {
                return "DA";
            }
        }
        ,
        DB{

            @Override
            public String qn() {
                return "DB";
            }
        }
        ,
        DC{

            @Override
            public String qn() {
                return "DC";
            }
        }
        ,
        DD{

            @Override
            public String qn() {
                return "DD";
            }
        }
        ,
        DF{

            @Override
            public String qn() {
                return "DF";
            }
        }
        ,
        DG{

            @Override
            public String qn() {
                return "DG";
            }
        }
        ,
        DJ{

            @Override
            public String qn() {
                return "DJ";
            }
        }
        ,
        DK{

            @Override
            public String qn() {
                return "DK";
            }
        }
        ,
        DL{

            @Override
            public String qn() {
                return "DL";
            }
        }
        ,
        DM{

            @Override
            public String qn() {
                return "DM";
            }
        }
        ,
        DN{

            @Override
            public String qn() {
                return "DN";
            }
        }
        ,
        DP{

            @Override
            public String qn() {
                return "DP";
            }
        }
        ,
        DU{

            @Override
            public String qn() {
                return "DU";
            }
        }
        ,
        DV{

            @Override
            public String qn() {
                return "DV";
            }
        }
        ,
        DW{

            @Override
            public String qn() {
                return "DW";
            }
        }
        ,
        DX{

            @Override
            public String qn() {
                return "DX";
            }
        };


        public abstract String qn();

        public static Split splitByQn(String qn) {
            return Arrays.stream(Split.values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
        }
    }
}

