/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.events.ventanilla;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Cuenta
extends Event
implements Serializable {
    private List<Bloqueada> bloqueadaList = null;
    private List<Verificada> verificadaList = null;
    private List<MedioPago> medioPagoList = null;
    private List<ServicioGestionado> servicioGestionadoList = null;
    private List<PendienteVerificacion> pendienteVerificacionList = null;

    public Cuenta() {
        super("Cuenta");
    }

    public Cuenta(Event event) {
        this(event.toMessage());
    }

    public Cuenta(Message message) {
        super(message);
    }

    public Cuenta ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Cuenta ss(String ss) {
        super.ss(ss);
        return this;
    }

    public String correo() {
        return !this.message.contains("correo") ? null : this.message.get("correo").asString();
    }

    public String nombre() {
        return !this.message.contains("nombre") ? null : this.message.get("nombre").asString();
    }

    public String apellidos() {
        return !this.message.contains("apellidos") ? null : this.message.get("apellidos").asString();
    }

    public List<String> telefonos() {
        return new ArrayList<String>(this.message.contains("telefonos") ? Arrays.asList((String[])this.message.get("telefonos").as(String[].class)) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                Cuenta.this.message.append("telefonos", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                Cuenta.this.message.remove("telefonos", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                Cuenta.this.message.remove("telefonos");
            }
        };
    }

    public String contrasena() {
        return !this.message.contains("contrasena") ? null : this.message.get("contrasena").asString();
    }

    public Boolean notificaciones() {
        return this.message.get("notificaciones").asBoolean();
    }

    public Bloqueada bloqueada() {
        List components = this.message.components("Bloqueada");
        return components.isEmpty() ? null : new Bloqueada((Message)components.get(0));
    }

    public Verificada verificada() {
        List components = this.message.components("Verificada");
        return components.isEmpty() ? null : new Verificada((Message)components.get(0));
    }

    public List<MedioPago> medioPagoList() {
        if (this.medioPagoList != null) {
            return this.medioPagoList;
        }
        this.medioPagoList = new ArrayList<MedioPago>((Collection)this.message.components("MedioPago").stream().map(c -> new MedioPago((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(MedioPago element) {
                super.add(element);
                Cuenta.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, MedioPago element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof MedioPago)) {
                    return false;
                }
                super.remove(o);
                Cuenta.this.message.remove(((MedioPago)o).toMessage());
                return true;
            }

            @Override
            public MedioPago remove(int index) {
                MedioPago type = (MedioPago)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super MedioPago> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((MedioPago)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends MedioPago> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends MedioPago> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.medioPagoList;
    }

    public List<ServicioGestionado> servicioGestionadoList() {
        if (this.servicioGestionadoList != null) {
            return this.servicioGestionadoList;
        }
        this.servicioGestionadoList = new ArrayList<ServicioGestionado>((Collection)this.message.components("ServicioGestionado").stream().map(c -> new ServicioGestionado((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(ServicioGestionado element) {
                super.add(element);
                Cuenta.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, ServicioGestionado element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof ServicioGestionado)) {
                    return false;
                }
                super.remove(o);
                Cuenta.this.message.remove(((ServicioGestionado)o).toMessage());
                return true;
            }

            @Override
            public ServicioGestionado remove(int index) {
                ServicioGestionado type = (ServicioGestionado)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super ServicioGestionado> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((ServicioGestionado)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends ServicioGestionado> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends ServicioGestionado> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.servicioGestionadoList;
    }

    public PendienteVerificacion pendienteVerificacion() {
        List components = this.message.components("PendienteVerificacion");
        return components.isEmpty() ? null : new PendienteVerificacion((Message)components.get(0));
    }

    public Cuenta correo(String correo) {
        if (correo == null) {
            this.message.remove("correo");
        } else {
            this.message.set("correo", correo);
        }
        return this;
    }

    public Cuenta nombre(String nombre) {
        if (nombre == null) {
            this.message.remove("nombre");
        } else {
            this.message.set("nombre", nombre);
        }
        return this;
    }

    public Cuenta apellidos(String apellidos) {
        if (apellidos == null) {
            this.message.remove("apellidos");
        } else {
            this.message.set("apellidos", apellidos);
        }
        return this;
    }

    public Cuenta telefonos(List<String> telefonos) {
        this.message.remove("telefonos");
        telefonos.forEach(v -> this.message.append("telefonos", v));
        return this;
    }

    public Cuenta contrasena(String contrasena) {
        if (contrasena == null) {
            this.message.remove("contrasena");
        } else {
            this.message.set("contrasena", contrasena);
        }
        return this;
    }

    public Cuenta notificaciones(Boolean notificaciones) {
        if (notificaciones == null) {
            this.message.remove("notificaciones");
        } else {
            this.message.set("notificaciones", notificaciones);
        }
        return this;
    }

    public Cuenta bloqueada(Bloqueada bloqueada) {
        this.message.components("Bloqueada").forEach(v -> this.message.remove(v));
        if (bloqueada != null) {
            this.message.add(bloqueada.toMessage());
        }
        return this;
    }

    public Cuenta verificada(Verificada verificada) {
        this.message.components("Verificada").forEach(v -> this.message.remove(v));
        if (verificada != null) {
            this.message.add(verificada.toMessage());
        }
        return this;
    }

    public Cuenta medioPagoList(List<MedioPago> medioPago) {
        new ArrayList<MedioPago>(this.medioPagoList()).forEach((Consumer<MedioPago>)((Consumer<Object>)v -> this.medioPagoList.remove(v)));
        this.medioPagoList.addAll(medioPago);
        return this;
    }

    public Cuenta servicioGestionadoList(List<ServicioGestionado> servicioGestionado) {
        new ArrayList<ServicioGestionado>(this.servicioGestionadoList()).forEach((Consumer<ServicioGestionado>)((Consumer<Object>)v -> this.servicioGestionadoList.remove(v)));
        this.servicioGestionadoList.addAll(servicioGestionado);
        return this;
    }

    public Cuenta pendienteVerificacion(PendienteVerificacion pendienteVerificacion) {
        this.message.components("PendienteVerificacion").forEach(v -> this.message.remove(v));
        if (pendienteVerificacion != null) {
            this.message.add(pendienteVerificacion.toMessage());
        }
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class PendienteVerificacion
    implements Serializable {
        protected Message message;

        public PendienteVerificacion() {
            this.message = new Message("PendienteVerificacion");
        }

        public PendienteVerificacion(Message message) {
            this.message = message;
        }

        public String codigo() {
            return !this.message.contains("codigo") ? null : this.message.get("codigo").asString();
        }

        public PendienteVerificacion codigo(String codigo) {
            if (codigo == null) {
                this.message.remove("codigo");
            } else {
                this.message.set("codigo", codigo);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class ServicioGestionado
    implements Serializable {
        protected Message message;

        public ServicioGestionado() {
            this.message = new Message("ServicioGestionado");
        }

        public ServicioGestionado(Message message) {
            this.message = message;
        }

        public Long rpu() {
            return this.message.get("rpu").asLong();
        }

        public String alias() {
            return !this.message.contains("alias") ? null : this.message.get("alias").asString();
        }

        public ServicioGestionado rpu(Long rpu) {
            if (rpu == null) {
                this.message.remove("rpu");
            } else {
                this.message.set("rpu", rpu);
            }
            return this;
        }

        public ServicioGestionado alias(String alias) {
            if (alias == null) {
                this.message.remove("alias");
            } else {
                this.message.set("alias", alias);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class MedioPago
    implements Serializable {
        private List<Tokenized> tokenizedList = null;
        protected Message message;

        public MedioPago() {
            this.message = new Message("MedioPago");
        }

        public MedioPago(Message message) {
            this.message = message;
        }

        public String id() {
            return !this.message.contains("id") ? null : this.message.get("id").asString();
        }

        public String alias() {
            return !this.message.contains("alias") ? null : this.message.get("alias").asString();
        }

        public String titular() {
            return !this.message.contains("titular") ? null : this.message.get("titular").asString();
        }

        public Integer ultimos4Digitos() {
            return this.message.get("ultimos4Digitos").asInteger();
        }

        public Integer bin() {
            return this.message.get("bin").asInteger();
        }

        public Tipo tipo() {
            return !this.message.contains("tipo") ? null : Tipo.valueOf(this.message.get("tipo").asString());
        }

        public String banco() {
            return !this.message.contains("banco") ? null : this.message.get("banco").asString();
        }

        public Integer mesExpiracion() {
            return this.message.get("mesExpiracion").asInteger();
        }

        public Integer anioExpiracion() {
            return this.message.get("anioExpiracion").asInteger();
        }

        public Marca marca() {
            return !this.message.contains("marca") ? null : Marca.valueOf(this.message.get("marca").asString());
        }

        public Boolean cargosPeriodicos() {
            return this.message.get("cargosPeriodicos").asBoolean();
        }

        public Tokenized tokenized() {
            List components = this.message.components("Tokenized");
            return components.isEmpty() ? null : new Tokenized((Message)components.get(0));
        }

        public MedioPago id(String id) {
            if (id == null) {
                this.message.remove("id");
            } else {
                this.message.set("id", id);
            }
            return this;
        }

        public MedioPago alias(String alias) {
            if (alias == null) {
                this.message.remove("alias");
            } else {
                this.message.set("alias", alias);
            }
            return this;
        }

        public MedioPago titular(String titular) {
            if (titular == null) {
                this.message.remove("titular");
            } else {
                this.message.set("titular", titular);
            }
            return this;
        }

        public MedioPago ultimos4Digitos(Integer ultimos4Digitos) {
            this.message.set("ultimos4Digitos", ultimos4Digitos);
            return this;
        }

        public MedioPago bin(Integer bin) {
            this.message.set("bin", bin);
            return this;
        }

        public MedioPago tipo(Tipo tipo) {
            if (tipo == null) {
                this.message.remove("tipo");
            } else {
                this.message.set("tipo", tipo.name());
            }
            return this;
        }

        public MedioPago banco(String banco) {
            if (banco == null) {
                this.message.remove("banco");
            } else {
                this.message.set("banco", banco);
            }
            return this;
        }

        public MedioPago mesExpiracion(Integer mesExpiracion) {
            this.message.set("mesExpiracion", mesExpiracion);
            return this;
        }

        public MedioPago anioExpiracion(Integer anioExpiracion) {
            this.message.set("anioExpiracion", anioExpiracion);
            return this;
        }

        public MedioPago marca(Marca marca) {
            if (marca == null) {
                this.message.remove("marca");
            } else {
                this.message.set("marca", marca.name());
            }
            return this;
        }

        public MedioPago cargosPeriodicos(Boolean cargosPeriodicos) {
            if (cargosPeriodicos == null) {
                this.message.remove("cargosPeriodicos");
            } else {
                this.message.set("cargosPeriodicos", cargosPeriodicos);
            }
            return this;
        }

        public MedioPago tokenized(Tokenized tokenized) {
            this.message.components("Tokenized").forEach(v -> this.message.remove(v));
            if (tokenized != null) {
                this.message.add(tokenized.toMessage());
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Tokenized
        implements Serializable {
            protected Message message;

            public Tokenized() {
                this.message = new Message("Tokenized");
            }

            public Tokenized(Message message) {
                this.message = message;
            }

            public String token() {
                return !this.message.contains("token") ? null : this.message.get("token").asString();
            }

            public Instant fechaCreacion() {
                return !this.message.contains("fechaCreacion") ? null : this.message.get("fechaCreacion").asInstant();
            }

            public Instant fechaActualizacion() {
                return !this.message.contains("fechaActualizacion") ? null : this.message.get("fechaActualizacion").asInstant();
            }

            public Tokenized token(String token) {
                if (token == null) {
                    this.message.remove("token");
                } else {
                    this.message.set("token", token);
                }
                return this;
            }

            public Tokenized fechaCreacion(Instant fechaCreacion) {
                if (fechaCreacion == null) {
                    this.message.remove("fechaCreacion");
                } else {
                    this.message.set("fechaCreacion", fechaCreacion);
                }
                return this;
            }

            public Tokenized fechaActualizacion(Instant fechaActualizacion) {
                if (fechaActualizacion == null) {
                    this.message.remove("fechaActualizacion");
                } else {
                    this.message.set("fechaActualizacion", fechaActualizacion);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static enum Marca {
            Visa,
            MasterCard,
            AmericanExpress,
            Privada,
            Carnet;

        }

        public static enum Tipo {
            Debito,
            Credito,
            Prepago;

        }
    }

    public static class Verificada
    implements Serializable {
        protected Message message;

        public Verificada() {
            this.message = new Message("Verificada");
        }

        public Verificada(Message message) {
            this.message = message;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class Bloqueada
    implements Serializable {
        protected Message message;

        public Bloqueada() {
            this.message = new Message("Bloqueada");
        }

        public Bloqueada(Message message) {
            this.message = message;
        }

        public Instant desde() {
            return !this.message.contains("desde") ? null : this.message.get("desde").asInstant();
        }

        public Bloqueada desde(Instant desde) {
            if (desde == null) {
                this.message.remove("desde");
            } else {
                this.message.set("desde", desde);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

