/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.events.facturacion;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Cargo
extends Event
implements Serializable {
    private List<Importe> importeList = null;
    private List<Servicio> servicioList = null;

    public Cargo() {
        super("Cargo");
    }

    public Cargo(Event event) {
        this(event.toMessage());
    }

    public Cargo(Message message) {
        super(message);
    }

    public Cargo ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Cargo ss(String ss) {
        super.ss(ss);
        return this;
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    public Long contrato() {
        return this.message.get("contrato").asLong();
    }

    public String modo() {
        return !this.message.contains("modo") ? null : this.message.get("modo").asString();
    }

    public String division() {
        return !this.message.contains("division") ? null : this.message.get("division").asString();
    }

    public String centroGestor() {
        return !this.message.contains("centroGestor") ? null : this.message.get("centroGestor").asString();
    }

    public String centroCoste() {
        return !this.message.contains("centroCoste") ? null : this.message.get("centroCoste").asString();
    }

    public String municipio() {
        return !this.message.contains("municipio") ? null : this.message.get("municipio").asString();
    }

    public Integer tasaIva() {
        return this.message.get("tasaIva").asInteger();
    }

    public Long total() {
        return this.message.get("total").asLong();
    }

    public List<Importe> importeList() {
        if (this.importeList != null) {
            return this.importeList;
        }
        this.importeList = new ArrayList<Importe>((Collection)this.message.components("Importe").stream().map(c -> new Importe((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Importe element) {
                super.add(element);
                Cargo.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Importe element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Importe)) {
                    return false;
                }
                super.remove(o);
                Cargo.this.message.remove(((Importe)o).toMessage());
                return true;
            }

            @Override
            public Importe remove(int index) {
                Importe type = (Importe)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Importe> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Importe)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Importe> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Importe> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.importeList;
    }

    public Servicio servicio() {
        List components = this.message.components("Servicio");
        return components.isEmpty() ? null : new Servicio((Message)components.get(0));
    }

    public Cargo id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public Cargo contrato(Long contrato) {
        if (contrato == null) {
            this.message.remove("contrato");
        } else {
            this.message.set("contrato", contrato);
        }
        return this;
    }

    public Cargo modo(String modo) {
        if (modo == null) {
            this.message.remove("modo");
        } else {
            this.message.set("modo", modo);
        }
        return this;
    }

    public Cargo division(String division) {
        if (division == null) {
            this.message.remove("division");
        } else {
            this.message.set("division", division);
        }
        return this;
    }

    public Cargo centroGestor(String centroGestor) {
        if (centroGestor == null) {
            this.message.remove("centroGestor");
        } else {
            this.message.set("centroGestor", centroGestor);
        }
        return this;
    }

    public Cargo centroCoste(String centroCoste) {
        if (centroCoste == null) {
            this.message.remove("centroCoste");
        } else {
            this.message.set("centroCoste", centroCoste);
        }
        return this;
    }

    public Cargo municipio(String municipio) {
        if (municipio == null) {
            this.message.remove("municipio");
        } else {
            this.message.set("municipio", municipio);
        }
        return this;
    }

    public Cargo tasaIva(Integer tasaIva) {
        this.message.set("tasaIva", tasaIva);
        return this;
    }

    public Cargo total(Long total) {
        if (total == null) {
            this.message.remove("total");
        } else {
            this.message.set("total", total);
        }
        return this;
    }

    public Cargo importeList(List<Importe> importe) {
        new ArrayList<Importe>(this.importeList()).forEach((Consumer<Importe>)((Consumer<Object>)v -> this.importeList.remove(v)));
        this.importeList.addAll(importe);
        return this;
    }

    public Cargo servicio(Servicio servicio) {
        this.message.components("Servicio").forEach(v -> this.message.remove(v));
        if (servicio != null) {
            this.message.add(servicio.toMessage());
        }
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class Servicio
    implements Serializable {
        protected Message message;

        public Servicio() {
            this.message = new Message("Servicio");
        }

        public Servicio(Message message) {
            this.message = message;
        }

        public Long kwh() {
            return this.message.get("kwh").asLong();
        }

        public Instant desde() {
            return !this.message.contains("desde") ? null : this.message.get("desde").asInstant();
        }

        public Instant hasta() {
            return !this.message.contains("hasta") ? null : this.message.get("hasta").asInstant();
        }

        public String tarifa() {
            return !this.message.contains("tarifa") ? null : this.message.get("tarifa").asString();
        }

        public Servicio kwh(Long kwh) {
            if (kwh == null) {
                this.message.remove("kwh");
            } else {
                this.message.set("kwh", kwh);
            }
            return this;
        }

        public Servicio desde(Instant desde) {
            if (desde == null) {
                this.message.remove("desde");
            } else {
                this.message.set("desde", desde);
            }
            return this;
        }

        public Servicio hasta(Instant hasta) {
            if (hasta == null) {
                this.message.remove("hasta");
            } else {
                this.message.set("hasta", hasta);
            }
            return this;
        }

        public Servicio tarifa(String tarifa) {
            if (tarifa == null) {
                this.message.remove("tarifa");
            } else {
                this.message.set("tarifa", tarifa);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class Importe
    implements Serializable {
        protected Message message;

        public Importe() {
            this.message = new Message("Importe");
        }

        public Importe(Message message) {
            this.message = message;
        }

        public String tipo() {
            return !this.message.contains("tipo") ? null : this.message.get("tipo").asString();
        }

        public Long cantidad() {
            return this.message.get("cantidad").asLong();
        }

        public Importe tipo(String tipo) {
            if (tipo == null) {
                this.message.remove("tipo");
            } else {
                this.message.set("tipo", tipo);
            }
            return this;
        }

        public Importe cantidad(Long cantidad) {
            if (cantidad == null) {
                this.message.remove("cantidad");
            } else {
                this.message.set("cantidad", cantidad);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static enum Split {
        D2{

            @Override
            public String qn() {
                return "D2";
            }
        }
        ,
        DA{

            @Override
            public String qn() {
                return "DA";
            }
        }
        ,
        DB{

            @Override
            public String qn() {
                return "DB";
            }
        }
        ,
        DC{

            @Override
            public String qn() {
                return "DC";
            }
        }
        ,
        DD{

            @Override
            public String qn() {
                return "DD";
            }
        }
        ,
        DF{

            @Override
            public String qn() {
                return "DF";
            }
        }
        ,
        DG{

            @Override
            public String qn() {
                return "DG";
            }
        }
        ,
        DJ{

            @Override
            public String qn() {
                return "DJ";
            }
        }
        ,
        DK{

            @Override
            public String qn() {
                return "DK";
            }
        }
        ,
        DL{

            @Override
            public String qn() {
                return "DL";
            }
        }
        ,
        DM{

            @Override
            public String qn() {
                return "DM";
            }
        }
        ,
        DN{

            @Override
            public String qn() {
                return "DN";
            }
        }
        ,
        DP{

            @Override
            public String qn() {
                return "DP";
            }
        }
        ,
        DU{

            @Override
            public String qn() {
                return "DU";
            }
        }
        ,
        DV{

            @Override
            public String qn() {
                return "DV";
            }
        }
        ,
        DW{

            @Override
            public String qn() {
                return "DW";
            }
        }
        ,
        DX{

            @Override
            public String qn() {
                return "DX";
            }
        };


        public abstract String qn();

        public static Split splitByQn(String qn) {
            return Arrays.stream(Split.values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
        }
    }
}

