/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.events.contratacion;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Expediente
extends Event
implements Serializable {
    public Expediente() {
        super("Expediente");
    }

    public Expediente(Event event) {
        this(event.toMessage());
    }

    public Expediente(Message message) {
        super(message);
    }

    public Expediente ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Expediente ss(String ss) {
        super.ss(ss);
        return this;
    }

    public String numero() {
        return !this.message.contains("numero") ? null : this.message.get("numero").asString();
    }

    public String solicitud() {
        return !this.message.contains("solicitud") ? null : this.message.get("solicitud").asString();
    }

    public Resultado resultado() {
        return !this.message.contains("resultado") ? null : Resultado.valueOf(this.message.get("resultado").asString());
    }

    public Estado estado() {
        return !this.message.contains("estado") ? null : Estado.valueOf(this.message.get("estado").asString());
    }

    public List<String> busquedas() {
        return new ArrayList<String>(this.message.contains("busquedas") ? Arrays.asList((String[])this.message.get("busquedas").as(String[].class)) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                Expediente.this.message.append("busquedas", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                Expediente.this.message.remove("busquedas", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                Expediente.this.message.remove("busquedas");
            }
        };
    }

    public List<String> comprobantes() {
        return new ArrayList<String>(this.message.contains("comprobantes") ? Arrays.asList((String[])this.message.get("comprobantes").as(String[].class)) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                Expediente.this.message.append("comprobantes", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                Expediente.this.message.remove("comprobantes", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                Expediente.this.message.remove("comprobantes");
            }
        };
    }

    public String firmante() {
        return !this.message.contains("firmante") ? null : this.message.get("firmante").asString();
    }

    public Expediente numero(String numero) {
        if (numero == null) {
            this.message.remove("numero");
        } else {
            this.message.set("numero", numero);
        }
        return this;
    }

    public Expediente solicitud(String solicitud) {
        if (solicitud == null) {
            this.message.remove("solicitud");
        } else {
            this.message.set("solicitud", solicitud);
        }
        return this;
    }

    public Expediente resultado(Resultado resultado) {
        if (resultado == null) {
            this.message.remove("resultado");
        } else {
            this.message.set("resultado", resultado.name());
        }
        return this;
    }

    public Expediente estado(Estado estado) {
        if (estado == null) {
            this.message.remove("estado");
        } else {
            this.message.set("estado", estado.name());
        }
        return this;
    }

    public Expediente busquedas(List<String> busquedas) {
        this.message.remove("busquedas");
        busquedas.forEach(v -> this.message.append("busquedas", v));
        return this;
    }

    public Expediente comprobantes(List<String> comprobantes) {
        this.message.remove("comprobantes");
        comprobantes.forEach(v -> this.message.append("comprobantes", v));
        return this;
    }

    public Expediente firmante(String firmante) {
        if (firmante == null) {
            this.message.remove("firmante");
        } else {
            this.message.set("firmante", firmante);
        }
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Estado {
        Pendiente,
        Descartado,
        Terminado;

    }

    public static enum Resultado {
        Negativo,
        Positivo,
        Mixto;

    }
}

