/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.events.contratacion;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import io.provista.datahub.events.contratacion.Acuerdo;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Convenio
extends Acuerdo
implements Serializable {
    private List<Recaudacion> recaudacionList = null;
    private List<CuentaMaestra> cuentaMaestraList = null;

    public Convenio() {
        super(new Event("Convenio"));
    }

    public Convenio(Event event) {
        this(event.toMessage());
    }

    public Convenio(Message message) {
        super(message);
    }

    @Override
    public Convenio ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Convenio ss(String ss) {
        super.ss(ss);
        return this;
    }

    public Tipo tipo() {
        return !this.message.contains("tipo") ? null : Tipo.valueOf(this.message.get("tipo").asString());
    }

    public String ejecutivo() {
        return !this.message.contains("ejecutivo") ? null : this.message.get("ejecutivo").asString();
    }

    public Recaudacion recaudacion() {
        List components = this.message.components("Recaudacion");
        return components.isEmpty() ? null : new Recaudacion((Message)components.get(0));
    }

    public CuentaMaestra cuentaMaestra() {
        List components = this.message.components("CuentaMaestra");
        return components.isEmpty() ? null : new CuentaMaestra((Message)components.get(0));
    }

    public Convenio tipo(Tipo tipo) {
        if (tipo == null) {
            this.message.remove("tipo");
        } else {
            this.message.set("tipo", tipo.name());
        }
        return this;
    }

    public Convenio ejecutivo(String ejecutivo) {
        if (ejecutivo == null) {
            this.message.remove("ejecutivo");
        } else {
            this.message.set("ejecutivo", ejecutivo);
        }
        return this;
    }

    public Convenio recaudacion(Recaudacion recaudacion) {
        this.message.components("Recaudacion").forEach(v -> this.message.remove(v));
        if (recaudacion != null) {
            this.message.add(recaudacion.toMessage());
        }
        return this;
    }

    public Convenio cuentaMaestra(CuentaMaestra cuentaMaestra) {
        this.message.components("CuentaMaestra").forEach(v -> this.message.remove(v));
        if (cuentaMaestra != null) {
            this.message.add(cuentaMaestra.toMessage());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class CuentaMaestra
    implements Serializable {
        private List<AnticipoPeriodico> anticipoPeriodicoList = null;
        protected Message message;

        public CuentaMaestra() {
            this.message = new Message("CuentaMaestra");
        }

        public CuentaMaestra(Message message) {
            this.message = message;
        }

        public TipoConvenio tipoConvenio() {
            return !this.message.contains("tipoConvenio") ? null : TipoConvenio.valueOf(this.message.get("tipoConvenio").asString());
        }

        public String facturacionTipoCobranza() {
            return !this.message.contains("facturacionTipoCobranza") ? null : this.message.get("facturacionTipoCobranza").asString();
        }

        public FacturaTipo facturaTipo() {
            return !this.message.contains("facturaTipo") ? null : FacturaTipo.valueOf(this.message.get("facturaTipo").asString());
        }

        public String facturaUsoCFDI() {
            return !this.message.contains("facturaUsoCFDI") ? null : this.message.get("facturaUsoCFDI").asString();
        }

        public String pagoReferenciaBancaria() {
            return !this.message.contains("pagoReferenciaBancaria") ? null : this.message.get("pagoReferenciaBancaria").asString();
        }

        public String pagoCuentaBancaria() {
            return !this.message.contains("pagoCuentaBancaria") ? null : this.message.get("pagoCuentaBancaria").asString();
        }

        public String pagoTipo() {
            return !this.message.contains("pagoTipo") ? null : this.message.get("pagoTipo").asString();
        }

        public Integer morosidadDiasVencimiento() {
            return this.message.get("morosidadDiasVencimiento").asInteger();
        }

        public Integer morosidadInteresDiferencial() {
            return this.message.get("morosidadInteresDiferencial").asInteger();
        }

        public Boolean anticiposPermitenPagarDap() {
            return this.message.get("anticiposPermitenPagarDap").asBoolean();
        }

        public List<AnticipoPeriodico> anticipoPeriodicoList() {
            if (this.anticipoPeriodicoList != null) {
                return this.anticipoPeriodicoList;
            }
            this.anticipoPeriodicoList = new ArrayList<AnticipoPeriodico>((Collection)this.message.components("AnticipoPeriodico").stream().map(c -> new AnticipoPeriodico((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(AnticipoPeriodico element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, AnticipoPeriodico element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof AnticipoPeriodico)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((AnticipoPeriodico)o).toMessage());
                    return true;
                }

                @Override
                public AnticipoPeriodico remove(int index) {
                    AnticipoPeriodico type = (AnticipoPeriodico)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super AnticipoPeriodico> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((AnticipoPeriodico)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends AnticipoPeriodico> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends AnticipoPeriodico> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.anticipoPeriodicoList;
        }

        public CuentaMaestra tipoConvenio(TipoConvenio tipoConvenio) {
            if (tipoConvenio == null) {
                this.message.remove("tipoConvenio");
            } else {
                this.message.set("tipoConvenio", tipoConvenio.name());
            }
            return this;
        }

        public CuentaMaestra facturacionTipoCobranza(String facturacionTipoCobranza) {
            if (facturacionTipoCobranza == null) {
                this.message.remove("facturacionTipoCobranza");
            } else {
                this.message.set("facturacionTipoCobranza", facturacionTipoCobranza);
            }
            return this;
        }

        public CuentaMaestra facturaTipo(FacturaTipo facturaTipo) {
            if (facturaTipo == null) {
                this.message.remove("facturaTipo");
            } else {
                this.message.set("facturaTipo", facturaTipo.name());
            }
            return this;
        }

        public CuentaMaestra facturaUsoCFDI(String facturaUsoCFDI) {
            if (facturaUsoCFDI == null) {
                this.message.remove("facturaUsoCFDI");
            } else {
                this.message.set("facturaUsoCFDI", facturaUsoCFDI);
            }
            return this;
        }

        public CuentaMaestra pagoReferenciaBancaria(String pagoReferenciaBancaria) {
            if (pagoReferenciaBancaria == null) {
                this.message.remove("pagoReferenciaBancaria");
            } else {
                this.message.set("pagoReferenciaBancaria", pagoReferenciaBancaria);
            }
            return this;
        }

        public CuentaMaestra pagoCuentaBancaria(String pagoCuentaBancaria) {
            if (pagoCuentaBancaria == null) {
                this.message.remove("pagoCuentaBancaria");
            } else {
                this.message.set("pagoCuentaBancaria", pagoCuentaBancaria);
            }
            return this;
        }

        public CuentaMaestra pagoTipo(String pagoTipo) {
            if (pagoTipo == null) {
                this.message.remove("pagoTipo");
            } else {
                this.message.set("pagoTipo", pagoTipo);
            }
            return this;
        }

        public CuentaMaestra morosidadDiasVencimiento(Integer morosidadDiasVencimiento) {
            this.message.set("morosidadDiasVencimiento", morosidadDiasVencimiento);
            return this;
        }

        public CuentaMaestra morosidadInteresDiferencial(Integer morosidadInteresDiferencial) {
            this.message.set("morosidadInteresDiferencial", morosidadInteresDiferencial);
            return this;
        }

        public CuentaMaestra anticiposPermitenPagarDap(Boolean anticiposPermitenPagarDap) {
            if (anticiposPermitenPagarDap == null) {
                this.message.remove("anticiposPermitenPagarDap");
            } else {
                this.message.set("anticiposPermitenPagarDap", anticiposPermitenPagarDap);
            }
            return this;
        }

        public CuentaMaestra anticipoPeriodicoList(List<AnticipoPeriodico> anticipoPeriodico) {
            new ArrayList<AnticipoPeriodico>(this.anticipoPeriodicoList()).forEach((Consumer<AnticipoPeriodico>)((Consumer<Object>)v -> this.anticipoPeriodicoList.remove(v)));
            this.anticipoPeriodicoList.addAll(anticipoPeriodico);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class AnticipoPeriodico
        implements Serializable {
            protected Message message;

            public AnticipoPeriodico() {
                this.message = new Message("AnticipoPeriodico");
            }

            public AnticipoPeriodico(Message message) {
                this.message = message;
            }

            public Long total() {
                return this.message.get("total").asLong();
            }

            public Integer tasaIVA() {
                return this.message.get("tasaIVA").asInteger();
            }

            public Boolean emitirSinAminorar() {
                return this.message.get("emitirSinAminorar").asBoolean();
            }

            public AnticipoPeriodico total(Long total) {
                if (total == null) {
                    this.message.remove("total");
                } else {
                    this.message.set("total", total);
                }
                return this;
            }

            public AnticipoPeriodico tasaIVA(Integer tasaIVA) {
                this.message.set("tasaIVA", tasaIVA);
                return this;
            }

            public AnticipoPeriodico emitirSinAminorar(Boolean emitirSinAminorar) {
                if (emitirSinAminorar == null) {
                    this.message.remove("emitirSinAminorar");
                } else {
                    this.message.set("emitirSinAminorar", emitirSinAminorar);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static enum FacturaTipo {
            PPD,
            PUE;

        }

        public static enum TipoConvenio {
            Normal,
            UsoPropio;

        }
    }

    public static class Recaudacion
    implements Serializable {
        protected Message message;

        public Recaudacion() {
            this.message = new Message("Recaudacion");
        }

        public Recaudacion(Message message) {
            this.message = message;
        }

        public TipoConvenio tipoConvenio() {
            return !this.message.contains("tipoConvenio") ? null : TipoConvenio.valueOf(this.message.get("tipoConvenio").asString());
        }

        public String gestor() {
            return !this.message.contains("gestor") ? null : this.message.get("gestor").asString();
        }

        public String ftp() {
            return !this.message.contains("ftp") ? null : this.message.get("ftp").asString();
        }

        public String afiliacion() {
            return !this.message.contains("afiliacion") ? null : this.message.get("afiliacion").asString();
        }

        public String carpeta() {
            return !this.message.contains("carpeta") ? null : this.message.get("carpeta").asString();
        }

        public String facturaUsoCFDI() {
            return !this.message.contains("facturaUsoCFDI") ? null : this.message.get("facturaUsoCFDI").asString();
        }

        public Integer cuentaContable() {
            return this.message.get("cuentaContable").asInteger();
        }

        public Recaudacion tipoConvenio(TipoConvenio tipoConvenio) {
            if (tipoConvenio == null) {
                this.message.remove("tipoConvenio");
            } else {
                this.message.set("tipoConvenio", tipoConvenio.name());
            }
            return this;
        }

        public Recaudacion gestor(String gestor) {
            if (gestor == null) {
                this.message.remove("gestor");
            } else {
                this.message.set("gestor", gestor);
            }
            return this;
        }

        public Recaudacion ftp(String ftp) {
            if (ftp == null) {
                this.message.remove("ftp");
            } else {
                this.message.set("ftp", ftp);
            }
            return this;
        }

        public Recaudacion afiliacion(String afiliacion) {
            if (afiliacion == null) {
                this.message.remove("afiliacion");
            } else {
                this.message.set("afiliacion", afiliacion);
            }
            return this;
        }

        public Recaudacion carpeta(String carpeta) {
            if (carpeta == null) {
                this.message.remove("carpeta");
            } else {
                this.message.set("carpeta", carpeta);
            }
            return this;
        }

        public Recaudacion facturaUsoCFDI(String facturaUsoCFDI) {
            if (facturaUsoCFDI == null) {
                this.message.remove("facturaUsoCFDI");
            } else {
                this.message.set("facturaUsoCFDI", facturaUsoCFDI);
            }
            return this;
        }

        public Recaudacion cuentaContable(Integer cuentaContable) {
            this.message.set("cuentaContable", cuentaContable);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static enum TipoConvenio {
            Domiciliacion,
            Ventanilla,
            Tarjeta,
            AdquiraTarjeta,
            AdquiraRecurrente;

        }
    }

    public static enum Tipo {
        CuentaMaestra,
        Recaudacion;

    }
}

