/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.events.contratacion;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import io.provista.datahub.events.contratacion.Acuerdo;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Contrato
extends Acuerdo
implements Serializable {
    private List<Generacion> generacionList = null;
    private List<Suministro> suministroList = null;
    private List<MediosContacto> mediosContactoList = null;

    public Contrato() {
        super(new Event("Contrato"));
    }

    public Contrato(Event event) {
        this(event.toMessage());
    }

    public Contrato(Message message) {
        super(message);
    }

    @Override
    public Contrato ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Contrato ss(String ss) {
        super.ss(ss);
        return this;
    }

    public Tipo tipo() {
        return !this.message.contains("tipo") ? null : Tipo.valueOf(this.message.get("tipo").asString());
    }

    public String agencia() {
        return !this.message.contains("agencia") ? null : this.message.get("agencia").asString();
    }

    public Generacion generacion() {
        List components = this.message.components("Generacion");
        return components.isEmpty() ? null : new Generacion((Message)components.get(0));
    }

    public Suministro suministro() {
        List components = this.message.components("Suministro");
        return components.isEmpty() ? null : new Suministro((Message)components.get(0));
    }

    public MediosContacto mediosContacto() {
        List components = this.message.components("MediosContacto");
        return components.isEmpty() ? null : new MediosContacto((Message)components.get(0));
    }

    public Contrato tipo(Tipo tipo) {
        if (tipo == null) {
            this.message.remove("tipo");
        } else {
            this.message.set("tipo", tipo.name());
        }
        return this;
    }

    public Contrato agencia(String agencia) {
        if (agencia == null) {
            this.message.remove("agencia");
        } else {
            this.message.set("agencia", agencia);
        }
        return this;
    }

    public Contrato generacion(Generacion generacion) {
        this.message.components("Generacion").forEach(v -> this.message.remove(v));
        if (generacion != null) {
            this.message.add(generacion.toMessage());
        }
        return this;
    }

    public Contrato suministro(Suministro suministro) {
        this.message.components("Suministro").forEach(v -> this.message.remove(v));
        if (suministro != null) {
            this.message.add(suministro.toMessage());
        }
        return this;
    }

    public Contrato mediosContacto(MediosContacto mediosContacto) {
        this.message.components("MediosContacto").forEach(v -> this.message.remove(v));
        if (mediosContacto != null) {
            this.message.add(mediosContacto.toMessage());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class MediosContacto
    implements Serializable {
        protected Message message;

        public MediosContacto() {
            this.message = new Message("MediosContacto");
        }

        public MediosContacto(Message message) {
            this.message = message;
        }

        public List<String> emails() {
            return new ArrayList<String>(this.message.contains("emails") ? Arrays.asList((String[])this.message.get("emails").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("emails", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("emails", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("emails");
                }
            };
        }

        public List<String> telefonos() {
            return new ArrayList<String>(this.message.contains("telefonos") ? Arrays.asList((String[])this.message.get("telefonos").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("telefonos", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("telefonos", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("telefonos");
                }
            };
        }

        public MediosContacto emails(List<String> emails) {
            this.message.remove("emails");
            emails.forEach(v -> this.message.append("emails", v));
            return this;
        }

        public MediosContacto telefonos(List<String> telefonos) {
            this.message.remove("telefonos");
            telefonos.forEach(v -> this.message.append("telefonos", v));
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class Suministro
    implements Serializable {
        private List<Instalacion> instalacionList = null;
        private List<Localizacion> localizacionList = null;
        protected Message message;

        public Suministro() {
            this.message = new Message("Suministro");
        }

        public Suministro(Message message) {
            this.message = message;
        }

        public TipoContrato tipoContrato() {
            return !this.message.contains("tipoContrato") ? null : TipoContrato.valueOf(this.message.get("tipoContrato").asString());
        }

        public TipoFacturacion tipoFacturacion() {
            return !this.message.contains("tipoFacturacion") ? null : TipoFacturacion.valueOf(this.message.get("tipoFacturacion").asString());
        }

        public String tarifa() {
            return !this.message.contains("tarifa") ? null : this.message.get("tarifa").asString();
        }

        public String tarifaAuxiliar() {
            return !this.message.contains("tarifaAuxiliar") ? null : this.message.get("tarifaAuxiliar").asString();
        }

        public String scian() {
            return !this.message.contains("scian") ? null : this.message.get("scian").asString();
        }

        public GiroCFE giroCFE() {
            return !this.message.contains("giroCFE") ? null : GiroCFE.valueOf(this.message.get("giroCFE").asString());
        }

        public Instalacion instalacion() {
            List components = this.message.components("Instalacion");
            return components.isEmpty() ? null : new Instalacion((Message)components.get(0));
        }

        public Localizacion localizacion() {
            List components = this.message.components("Localizacion");
            return components.isEmpty() ? null : new Localizacion((Message)components.get(0));
        }

        public Suministro tipoContrato(TipoContrato tipoContrato) {
            if (tipoContrato == null) {
                this.message.remove("tipoContrato");
            } else {
                this.message.set("tipoContrato", tipoContrato.name());
            }
            return this;
        }

        public Suministro tipoFacturacion(TipoFacturacion tipoFacturacion) {
            if (tipoFacturacion == null) {
                this.message.remove("tipoFacturacion");
            } else {
                this.message.set("tipoFacturacion", tipoFacturacion.name());
            }
            return this;
        }

        public Suministro tarifa(String tarifa) {
            if (tarifa == null) {
                this.message.remove("tarifa");
            } else {
                this.message.set("tarifa", tarifa);
            }
            return this;
        }

        public Suministro tarifaAuxiliar(String tarifaAuxiliar) {
            if (tarifaAuxiliar == null) {
                this.message.remove("tarifaAuxiliar");
            } else {
                this.message.set("tarifaAuxiliar", tarifaAuxiliar);
            }
            return this;
        }

        public Suministro scian(String scian) {
            if (scian == null) {
                this.message.remove("scian");
            } else {
                this.message.set("scian", scian);
            }
            return this;
        }

        public Suministro giroCFE(GiroCFE giroCFE) {
            if (giroCFE == null) {
                this.message.remove("giroCFE");
            } else {
                this.message.set("giroCFE", giroCFE.name());
            }
            return this;
        }

        public Suministro instalacion(Instalacion instalacion) {
            this.message.components("Instalacion").forEach(v -> this.message.remove(v));
            if (instalacion != null) {
                this.message.add(instalacion.toMessage());
            }
            return this;
        }

        public Suministro localizacion(Localizacion localizacion) {
            this.message.components("Localizacion").forEach(v -> this.message.remove(v));
            if (localizacion != null) {
                this.message.add(localizacion.toMessage());
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Localizacion
        implements Serializable {
            protected Message message;

            public Localizacion() {
                this.message = new Message("Localizacion");
            }

            public Localizacion(Message message) {
                this.message = message;
            }

            public String direccion() {
                return !this.message.contains("direccion") ? null : this.message.get("direccion").asString();
            }

            public List<String> callesAdyacentes() {
                return new ArrayList<String>(this.message.contains("callesAdyacentes") ? Arrays.asList((String[])this.message.get("callesAdyacentes").as(String[].class)) : Collections.emptyList()){

                    @Override
                    public boolean add(String value) {
                        super.add(value);
                        message.append("callesAdyacentes", value);
                        return true;
                    }

                    @Override
                    public void add(int index, String element) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object value) {
                        if (!(value instanceof String)) {
                            return false;
                        }
                        super.remove(value);
                        message.remove("callesAdyacentes", value);
                        return true;
                    }

                    @Override
                    public String remove(int index) {
                        String type = (String)this.get(index);
                        this.remove(type);
                        return type;
                    }

                    @Override
                    public boolean removeIf(Predicate<? super String> filter) {
                        return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        c.forEach(this::remove);
                        return true;
                    }

                    @Override
                    public boolean addAll(Collection<? extends String> c) {
                        c.forEach(this::add);
                        return true;
                    }

                    @Override
                    public boolean addAll(int index, Collection<? extends String> c) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void clear() {
                        super.clear();
                        message.remove("callesAdyacentes");
                    }
                };
            }

            public String colonia() {
                return !this.message.contains("colonia") ? null : this.message.get("colonia").asString();
            }

            public String municipio() {
                return !this.message.contains("municipio") ? null : this.message.get("municipio").asString();
            }

            public String estado() {
                return !this.message.contains("estado") ? null : this.message.get("estado").asString();
            }

            public String codigoPostal() {
                return !this.message.contains("codigoPostal") ? null : this.message.get("codigoPostal").asString();
            }

            public String coordenadas() {
                return !this.message.contains("coordenadas") ? null : this.message.get("coordenadas").asString();
            }

            public Localizacion direccion(String direccion) {
                if (direccion == null) {
                    this.message.remove("direccion");
                } else {
                    this.message.set("direccion", direccion);
                }
                return this;
            }

            public Localizacion callesAdyacentes(List<String> callesAdyacentes) {
                this.message.remove("callesAdyacentes");
                callesAdyacentes.forEach(v -> this.message.append("callesAdyacentes", v));
                return this;
            }

            public Localizacion colonia(String colonia) {
                if (colonia == null) {
                    this.message.remove("colonia");
                } else {
                    this.message.set("colonia", colonia);
                }
                return this;
            }

            public Localizacion municipio(String municipio) {
                if (municipio == null) {
                    this.message.remove("municipio");
                } else {
                    this.message.set("municipio", municipio);
                }
                return this;
            }

            public Localizacion estado(String estado) {
                if (estado == null) {
                    this.message.remove("estado");
                } else {
                    this.message.set("estado", estado);
                }
                return this;
            }

            public Localizacion codigoPostal(String codigoPostal) {
                if (codigoPostal == null) {
                    this.message.remove("codigoPostal");
                } else {
                    this.message.set("codigoPostal", codigoPostal);
                }
                return this;
            }

            public Localizacion coordenadas(String coordenadas) {
                if (coordenadas == null) {
                    this.message.remove("coordenadas");
                } else {
                    this.message.set("coordenadas", coordenadas);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static class Instalacion
        implements Serializable {
            protected Message message;

            public Instalacion() {
                this.message = new Message("Instalacion");
            }

            public Instalacion(Message message) {
                this.message = message;
            }

            public Double potenciaContratada() {
                return this.message.get("potenciaContratada").asDouble();
            }

            public Double potenciaInstalada() {
                return this.message.get("potenciaInstalada").asDouble();
            }

            public Integer hilos() {
                return this.message.get("hilos").asInteger();
            }

            public TipoSuministro tipoSuministro() {
                return !this.message.contains("tipoSuministro") ? null : TipoSuministro.valueOf(this.message.get("tipoSuministro").asString());
            }

            public Instalacion potenciaContratada(Double potenciaContratada) {
                this.message.set("potenciaContratada", potenciaContratada);
                return this;
            }

            public Instalacion potenciaInstalada(Double potenciaInstalada) {
                this.message.set("potenciaInstalada", potenciaInstalada);
                return this;
            }

            public Instalacion hilos(Integer hilos) {
                this.message.set("hilos", hilos);
                return this;
            }

            public Instalacion tipoSuministro(TipoSuministro tipoSuministro) {
                if (tipoSuministro == null) {
                    this.message.remove("tipoSuministro");
                } else {
                    this.message.set("tipoSuministro", tipoSuministro.name());
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }

            public static enum TipoSuministro {
                OrdinariaBajaBaja,
                EspecialAltaAlta,
                EspecialAltaBaja,
                EspecialBajaAlta;

            }
        }

        public static enum GiroCFE {
            IndustrialAgropecuaria,
            IndustrialExtractiva,
            IndustrialTransformacion,
            IndustrialMinera,
            IndustrialConstruccion,
            IndustrialEnergia,
            Comercial,
            Transporte,
            Residencial,
            GobiernoFederal,
            GobiernoEstatal,
            GobiernoMunicipal,
            Servicios,
            SectorParaestatal,
            Otros;

        }

        public static enum TipoFacturacion {
            Mensual,
            BimestralPares,
            BimestralNones,
            TetramestralEnero,
            TetramestralFebrero,
            TetramestralMarzo,
            TetramestralAbril,
            Temporales,
            CiclosEspeciales;

        }

        public static enum TipoContrato {
            Normal,
            UsoPropio,
            UltimoRecurso,
            Empleado;

        }
    }

    public static class Generacion
    implements Serializable {
        private List<Instalacion> instalacionList = null;
        private List<Localizacion> localizacionList = null;
        protected Message message;

        public Generacion() {
            this.message = new Message("Generacion");
        }

        public Generacion(Message message) {
            this.message = message;
        }

        public String medidor() {
            return !this.message.contains("medidor") ? null : this.message.get("medidor").asString();
        }

        public String rmu() {
            return !this.message.contains("rmu") ? null : this.message.get("rmu").asString();
        }

        public TipoContrato tipoContrato() {
            return !this.message.contains("tipoContrato") ? null : TipoContrato.valueOf(this.message.get("tipoContrato").asString());
        }

        public Instant fechaAlta() {
            return !this.message.contains("fechaAlta") ? null : this.message.get("fechaAlta").asInstant();
        }

        public Double facturacionEstimada() {
            return this.message.get("facturacionEstimada").asDouble();
        }

        public String codigoSolicitudInterconexion() {
            return !this.message.contains("codigoSolicitudInterconexion") ? null : this.message.get("codigoSolicitudInterconexion").asString();
        }

        public Instalacion instalacion() {
            List components = this.message.components("Instalacion");
            return components.isEmpty() ? null : new Instalacion((Message)components.get(0));
        }

        public Localizacion localizacion() {
            List components = this.message.components("Localizacion");
            return components.isEmpty() ? null : new Localizacion((Message)components.get(0));
        }

        public Generacion medidor(String medidor) {
            if (medidor == null) {
                this.message.remove("medidor");
            } else {
                this.message.set("medidor", medidor);
            }
            return this;
        }

        public Generacion rmu(String rmu) {
            if (rmu == null) {
                this.message.remove("rmu");
            } else {
                this.message.set("rmu", rmu);
            }
            return this;
        }

        public Generacion tipoContrato(TipoContrato tipoContrato) {
            if (tipoContrato == null) {
                this.message.remove("tipoContrato");
            } else {
                this.message.set("tipoContrato", tipoContrato.name());
            }
            return this;
        }

        public Generacion fechaAlta(Instant fechaAlta) {
            if (fechaAlta == null) {
                this.message.remove("fechaAlta");
            } else {
                this.message.set("fechaAlta", fechaAlta);
            }
            return this;
        }

        public Generacion facturacionEstimada(Double facturacionEstimada) {
            this.message.set("facturacionEstimada", facturacionEstimada);
            return this;
        }

        public Generacion codigoSolicitudInterconexion(String codigoSolicitudInterconexion) {
            if (codigoSolicitudInterconexion == null) {
                this.message.remove("codigoSolicitudInterconexion");
            } else {
                this.message.set("codigoSolicitudInterconexion", codigoSolicitudInterconexion);
            }
            return this;
        }

        public Generacion instalacion(Instalacion instalacion) {
            this.message.components("Instalacion").forEach(v -> this.message.remove(v));
            if (instalacion != null) {
                this.message.add(instalacion.toMessage());
            }
            return this;
        }

        public Generacion localizacion(Localizacion localizacion) {
            this.message.components("Localizacion").forEach(v -> this.message.remove(v));
            if (localizacion != null) {
                this.message.add(localizacion.toMessage());
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Localizacion
        implements Serializable {
            protected Message message;

            public Localizacion() {
                this.message = new Message("Localizacion");
            }

            public Localizacion(Message message) {
                this.message = message;
            }

            public String zona() {
                return !this.message.contains("zona") ? null : this.message.get("zona").asString();
            }

            public String zonaCarga() {
                return !this.message.contains("zonaCarga") ? null : this.message.get("zonaCarga").asString();
            }

            public String sistema() {
                return !this.message.contains("sistema") ? null : this.message.get("sistema").asString();
            }

            public String coordenadas() {
                return !this.message.contains("coordenadas") ? null : this.message.get("coordenadas").asString();
            }

            public Localizacion zona(String zona) {
                if (zona == null) {
                    this.message.remove("zona");
                } else {
                    this.message.set("zona", zona);
                }
                return this;
            }

            public Localizacion zonaCarga(String zonaCarga) {
                if (zonaCarga == null) {
                    this.message.remove("zonaCarga");
                } else {
                    this.message.set("zonaCarga", zonaCarga);
                }
                return this;
            }

            public Localizacion sistema(String sistema) {
                if (sistema == null) {
                    this.message.remove("sistema");
                } else {
                    this.message.set("sistema", sistema);
                }
                return this;
            }

            public Localizacion coordenadas(String coordenadas) {
                if (coordenadas == null) {
                    this.message.remove("coordenadas");
                } else {
                    this.message.set("coordenadas", coordenadas);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static class Instalacion
        implements Serializable {
            protected Message message;

            public Instalacion() {
                this.message = new Message("Instalacion");
            }

            public Instalacion(Message message) {
                this.message = message;
            }

            public Instant fechaInstalacion() {
                return !this.message.contains("fechaInstalacion") ? null : this.message.get("fechaInstalacion").asInstant();
            }

            public Integer unidadesGeneracion() {
                return this.message.get("unidadesGeneracion").asInteger();
            }

            public Double potenciaInstalada() {
                return this.message.get("potenciaInstalada").asDouble();
            }

            public String tension() {
                return !this.message.contains("tension") ? null : this.message.get("tension").asString();
            }

            public String tecnologia() {
                return !this.message.contains("tecnologia") ? null : this.message.get("tecnologia").asString();
            }

            public List<String> medidores() {
                return new ArrayList<String>(this.message.contains("medidores") ? Arrays.asList((String[])this.message.get("medidores").as(String[].class)) : Collections.emptyList()){

                    @Override
                    public boolean add(String value) {
                        super.add(value);
                        message.append("medidores", value);
                        return true;
                    }

                    @Override
                    public void add(int index, String element) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object value) {
                        if (!(value instanceof String)) {
                            return false;
                        }
                        super.remove(value);
                        message.remove("medidores", value);
                        return true;
                    }

                    @Override
                    public String remove(int index) {
                        String type = (String)this.get(index);
                        this.remove(type);
                        return type;
                    }

                    @Override
                    public boolean removeIf(Predicate<? super String> filter) {
                        return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        c.forEach(this::remove);
                        return true;
                    }

                    @Override
                    public boolean addAll(Collection<? extends String> c) {
                        c.forEach(this::add);
                        return true;
                    }

                    @Override
                    public boolean addAll(int index, Collection<? extends String> c) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void clear() {
                        super.clear();
                        message.remove("medidores");
                    }
                };
            }

            public Instalacion fechaInstalacion(Instant fechaInstalacion) {
                if (fechaInstalacion == null) {
                    this.message.remove("fechaInstalacion");
                } else {
                    this.message.set("fechaInstalacion", fechaInstalacion);
                }
                return this;
            }

            public Instalacion unidadesGeneracion(Integer unidadesGeneracion) {
                this.message.set("unidadesGeneracion", unidadesGeneracion);
                return this;
            }

            public Instalacion potenciaInstalada(Double potenciaInstalada) {
                this.message.set("potenciaInstalada", potenciaInstalada);
                return this;
            }

            public Instalacion tension(String tension) {
                if (tension == null) {
                    this.message.remove("tension");
                } else {
                    this.message.set("tension", tension);
                }
                return this;
            }

            public Instalacion tecnologia(String tecnologia) {
                if (tecnologia == null) {
                    this.message.remove("tecnologia");
                } else {
                    this.message.set("tecnologia", tecnologia);
                }
                return this;
            }

            public Instalacion medidores(List<String> medidores) {
                this.message.remove("medidores");
                medidores.forEach(v -> this.message.append("medidores", v));
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static enum TipoContrato {
            NetBilling,
            VentaTotal,
            NetMetering;

        }
    }

    public static enum Tipo {
        Suministro,
        Generacion;

    }
}

