/*
 * Decompiled with CFR 0.152.
 */
package io.provista.datahub.events;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Analysis
extends Event
implements Serializable {
    private List<Outcome> outcomeList = null;

    public Analysis() {
        super("Analysis");
    }

    public Analysis(Event event) {
        this(event.toMessage());
    }

    public Analysis(Message message) {
        super(message);
    }

    public Analysis ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Analysis ss(String ss) {
        super.ss(ss);
        return this;
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    public String timetag() {
        return !this.message.contains("timetag") ? null : this.message.get("timetag").asString();
    }

    public String context() {
        return !this.message.contains("context") ? null : this.message.get("context").asString();
    }

    public Type type() {
        return !this.message.contains("type") ? null : Type.valueOf(this.message.get("type").asString());
    }

    public Integer weight() {
        return this.message.get("weight").asInteger();
    }

    public List<Outcome> outcomeList() {
        if (this.outcomeList != null) {
            return this.outcomeList;
        }
        this.outcomeList = new ArrayList<Outcome>((Collection)this.message.components("Outcome").stream().map(c -> new Outcome((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Outcome element) {
                super.add(element);
                Analysis.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Outcome element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Outcome)) {
                    return false;
                }
                super.remove(o);
                Analysis.this.message.remove(((Outcome)o).toMessage());
                return true;
            }

            @Override
            public Outcome remove(int index) {
                Outcome type = (Outcome)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Outcome> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Outcome)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Outcome> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Outcome> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.outcomeList;
    }

    public Analysis id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public Analysis timetag(String timetag) {
        if (timetag == null) {
            this.message.remove("timetag");
        } else {
            this.message.set("timetag", timetag);
        }
        return this;
    }

    public Analysis context(String context) {
        if (context == null) {
            this.message.remove("context");
        } else {
            this.message.set("context", context);
        }
        return this;
    }

    public Analysis type(Type type) {
        if (type == null) {
            this.message.remove("type");
        } else {
            this.message.set("type", type.name());
        }
        return this;
    }

    public Analysis weight(Integer weight) {
        this.message.set("weight", weight);
        return this;
    }

    public Analysis outcomeList(List<Outcome> outcome) {
        new ArrayList<Outcome>(this.outcomeList()).forEach((Consumer<Outcome>)((Consumer<Object>)v -> this.outcomeList.remove(v)));
        this.outcomeList.addAll(outcome);
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class Outcome
    implements Serializable {
        protected Message message;

        public Outcome() {
            this.message = new Message("Outcome");
        }

        public Outcome(Message message) {
            this.message = message;
        }

        public String title() {
            return !this.message.contains("title") ? null : this.message.get("title").asString();
        }

        public Format format() {
            return !this.message.contains("format") ? null : Format.valueOf(this.message.get("format").asString());
        }

        public String value() {
            return !this.message.contains("value") ? null : this.message.get("value").asString();
        }

        public List<String> evidences() {
            return new ArrayList<String>(this.message.contains("evidences") ? Arrays.asList((String[])this.message.get("evidences").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("evidences", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("evidences", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("evidences");
                }
            };
        }

        public Outcome title(String title) {
            if (title == null) {
                this.message.remove("title");
            } else {
                this.message.set("title", title);
            }
            return this;
        }

        public Outcome format(Format format) {
            if (format == null) {
                this.message.remove("format");
            } else {
                this.message.set("format", format.name());
            }
            return this;
        }

        public Outcome value(String value) {
            if (value == null) {
                this.message.remove("value");
            } else {
                this.message.set("value", value);
            }
            return this;
        }

        public Outcome evidences(List<String> evidences) {
            this.message.remove("evidences");
            evidences.forEach(v -> this.message.append("evidences", v));
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static enum Format {
            text,
            metric;

        }
    }

    public static enum Type {
        summary,
        account,
        alert,
        statement,
        anomaly;

    }

    public static enum Split {
        D2{

            @Override
            public String qn() {
                return "D2";
            }
        }
        ,
        DA{

            @Override
            public String qn() {
                return "DA";
            }
        }
        ,
        DB{

            @Override
            public String qn() {
                return "DB";
            }
        }
        ,
        DC{

            @Override
            public String qn() {
                return "DC";
            }
        }
        ,
        DD{

            @Override
            public String qn() {
                return "DD";
            }
        }
        ,
        DF{

            @Override
            public String qn() {
                return "DF";
            }
        }
        ,
        DG{

            @Override
            public String qn() {
                return "DG";
            }
        }
        ,
        DJ{

            @Override
            public String qn() {
                return "DJ";
            }
        }
        ,
        DK{

            @Override
            public String qn() {
                return "DK";
            }
        }
        ,
        DL{

            @Override
            public String qn() {
                return "DL";
            }
        }
        ,
        DM{

            @Override
            public String qn() {
                return "DM";
            }
        }
        ,
        DN{

            @Override
            public String qn() {
                return "DN";
            }
        }
        ,
        DP{

            @Override
            public String qn() {
                return "DP";
            }
        }
        ,
        DU{

            @Override
            public String qn() {
                return "DU";
            }
        }
        ,
        DV{

            @Override
            public String qn() {
                return "DV";
            }
        }
        ,
        DW{

            @Override
            public String qn() {
                return "DW";
            }
        }
        ,
        DX{

            @Override
            public String qn() {
                return "DX";
            }
        };


        public abstract String qn();

        public static Split splitByQn(String qn) {
            return Arrays.stream(Split.values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
        }
    }
}

