/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.transaction;

import io.intino.Configuration;
import io.intino.datahub.graph.Attribute;
import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Namespace;
import io.intino.datahub.graph.Transaction;
import io.intino.datahub.graph.WordBag;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.transaction.TransactionTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TransactionRenderer {
    private final Transaction transaction;
    private final Configuration conf;
    private final Datalake.Split split;
    private final File destination;
    private final String rootPackage;

    public TransactionRenderer(Transaction transaction, Configuration conf, Datalake.Split split, File destination, String rootPackage) {
        this.transaction = transaction;
        this.conf = conf;
        this.split = split;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        Object transactionsPackage = this.transactionsPackage();
        if (this.transaction.core$().owner().is(Namespace.class)) {
            transactionsPackage = (String)transactionsPackage + "." + ((Namespace)this.transaction.core$().ownerAs(Namespace.class)).qn();
        }
        File packageFolder = new File(this.destination, ((String)transactionsPackage).replace(".", File.separator));
        Frame frame = this.createTransactionFrame(this.transaction, (String)transactionsPackage);
        FrameBuilder builder = new FrameBuilder(new String[]{"root"}).add("root", transactionsPackage).add("package", transactionsPackage).add("transaction", (Object)frame);
        if (!this.transaction.graph().wordBagList().isEmpty()) {
            builder.add("wordbagsImport", (Object)this.rootPackage);
        }
        Commons.writeFrame(packageFolder, this.transaction.name$(), this.template().render((Object)builder));
    }

    private Frame createTransactionFrame(Transaction transaction, String packageName) {
        FrameBuilder builder = new FrameBuilder(new String[]{"transaction"}).add("name", (Object)transaction.name$()).add("package", (Object)packageName).add("size", (Object)((int)Math.ceil((float)this.sizeOf(transaction) / 8.0f)));
        if (transaction.attributeList().stream().noneMatch(a -> a.name$().equals("id"))) {
            builder.add("id", transaction.attributeList().stream().filter(Data::isId).map(Layer::name$).findFirst().orElse(null));
        }
        builder.add("attribute", (Object)this.processAttributes(new ArrayList<Attribute>(transaction.attributeList()), transaction.name$()));
        if (this.split != null) {
            List leafs = this.split.isLeaf() != false ? Collections.singletonList(this.split) : this.split.leafs();
            builder.add("split", (Object)new FrameBuilder().add("split").add("enum", (Object)this.enums(this.split, leafs)));
        }
        return builder.toFrame();
    }

    private int sizeOf(Transaction transaction) {
        return transaction.attributeList().stream().map(a -> !a.isWordBag() ? a.asType().size() : this.sizeOf(a.asWordBag().wordBag()).intValue()).reduce(Integer::sum).get();
    }

    private FrameBuilder[] processAttributes(List<Attribute> attributes, String owner) {
        ArrayList<FrameBuilder> list = new ArrayList<FrameBuilder>();
        int offset = 0;
        attributes.sort(Comparator.comparingInt(a -> a.asType().size()));
        Collections.reverse(attributes);
        for (Attribute attribute : attributes) {
            FrameBuilder b = this.process(attribute, offset);
            if (b == null) continue;
            offset += attribute.isWordBag() ? this.sizeOf(attribute.asWordBag().wordBag()).intValue() : attribute.asType().size();
            list.add(b.add("owner", (Object)owner));
        }
        return list.toArray(new FrameBuilder[0]);
    }

    private FrameBuilder process(Attribute attribute, int offset) {
        if (attribute.isWordBag()) {
            return this.process(attribute.asWordBag().wordBag(), attribute.name$(), offset);
        }
        return this.processAttribute(attribute.asType(), offset);
    }

    private FrameBuilder processAttribute(Data.Type attribute, int offset) {
        FrameBuilder builder = new FrameBuilder(new String[]{"attribute"}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("offset", (Object)offset).add("type", (Object)(this.isPrimitive(attribute) ? attribute.primitive() : attribute.type()));
        attribute.core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        if (this.isAligned(attribute, offset)) {
            builder.add("aligned", (Object)"Aligned");
        } else {
            builder.add("bits", (Object)attribute.size());
        }
        builder.add("size", (Object)attribute.size());
        if (attribute.asData().isDateTime()) {
            builder.add("precision", (Object)"");
        } else if (attribute.asData().isDate()) {
            builder.add("precision", (Object)"");
        }
        return builder;
    }

    private Frame[] enums(Datalake.Split realSplit, List<Datalake.Split> leafs) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        if (!leafs.contains(realSplit) && !realSplit.label().isEmpty()) {
            frames.add(new FrameBuilder(new String[]{"enum"}).add("value", (Object)realSplit.qn().replace(".", "-")).toFrame());
        }
        for (Datalake.Split leaf : leafs) {
            FrameBuilder builder = new FrameBuilder(new String[]{"enum"}).add("value", (Object)leaf.qn().replace(".", "-")).add("qn", (Object)leaf.qn());
            frames.add(builder.toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private boolean isAligned(Data.Type attribute, int offset) {
        return (offset == 0 || TransactionRenderer.log2(offset) % 1.0 == 0.0) && attribute.maxSize() == attribute.size();
    }

    private FrameBuilder process(WordBag wordBag, String name, int offset) {
        FrameBuilder builder = new FrameBuilder(new String[]{"attribute", "wordbag"}).add("name", (Object)name).add("type", (Object)wordBag.name$()).add("offset", (Object)offset).add("bits", (Object)this.sizeOf(wordBag));
        if (wordBag.isFromResource()) {
            builder.add("resource").add("resource", (Object)this.resource(wordBag));
        } else {
            builder.add("word", (Object)this.words(wordBag));
        }
        return builder;
    }

    private String resource(WordBag wordBag) {
        String s = wordBag.asFromResource().tsv().toString();
        return this.conf.artifact().groupId().replace(".", "/") + "/ontology/" + new File(s).getName();
    }

    private boolean isPrimitive(Data.Type attribute) {
        Data data = attribute.asData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isId() || data.isReal();
    }

    private String[] words(WordBag wordBag) {
        return (String[])wordBag.asFromCode().wordList().stream().map(w -> w.name$() + "(" + w.value() + ")").toArray(String[]::new);
    }

    private Integer sizeOf(WordBag wordBag) {
        try {
            return !wordBag.isFromResource() ? (int)Math.ceil(TransactionRenderer.log2(wordBag.asFromCode().wordList().size() + 1)) : (int)Math.ceil(TransactionRenderer.log2(this.countLines(wordBag) + 1));
        }
        catch (IOException e) {
            return 0;
        }
    }

    private int countLines(WordBag wordBag) throws IOException {
        return (int)new BufferedReader(new InputStreamReader(wordBag.asFromResource().tsv().openStream())).lines().count();
    }

    private String transactionsPackage() {
        return this.rootPackage + ".transaction";
    }

    private Template template() {
        return Formatters.customize(new TransactionTemplate());
    }

    public static double log2(int N) {
        return Math.log(N) / Math.log(2.0);
    }
}

