/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.TripleStore;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.ness.core.Blob;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.fs.FSSetStore;
import io.intino.ness.core.sessions.Fingerprint;
import io.intino.ness.core.sessions.SetSessionFileReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SetSessionManager {
    private static final String BlobExtension = ".blob";
    private final List<File> files;
    private final File storeFolder;

    private SetSessionManager(List<File> files, File storeFolder) {
        this.files = files;
        this.storeFolder = storeFolder;
    }

    public static void push(Blob blob, File stageFolder) {
        FS.copyInto(SetSessionManager.fileFor(blob, stageFolder), blob.inputStream());
    }

    public static void seal(File stageFolder, File storeFolder) {
        new SetSessionManager(SetSessionManager.blobsOf(stageFolder), storeFolder).seal();
    }

    private static List<File> blobsOf(File stageFolder) {
        File[] files = stageFolder.listFiles(f -> f.getName().endsWith(BlobExtension));
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    private static File fileFor(Blob blob, File parentFolder) {
        return new File(parentFolder, SetSessionManager.randomName(blob));
    }

    private static String randomName(Blob blob) {
        return UUID.randomUUID().toString() + "." + (Object)((Object)blob.type()) + BlobExtension;
    }

    private static String extensionOf(Blob.Type type) {
        return "." + type.name() + BlobExtension;
    }

    private void seal() {
        this.sealSetSessions();
        this.sealSetMetadataSessions();
    }

    private void sealSetMetadataSessions() {
        HashMap map = new HashMap();
        this.loadSetMetadataSessions().flatMap(TripleStore::all).forEach(s -> this.processTriple((String[])s, map));
        map.values().forEach(TripleStore::save);
    }

    private void processTriple(String[] triple, Map<String, TripleStore> map) {
        Fingerprint fingerprint = new Fingerprint(triple[0]);
        this.tripleStoreFor(this.metadataPathOf(fingerprint), map).put(fingerprint.set(), triple[1], (Object)triple[2]);
    }

    private String metadataPathOf(Fingerprint fingerprint) {
        return fingerprint.tank() + "/" + fingerprint.timetag();
    }

    private TripleStore tripleStoreFor(String path, Map<String, TripleStore> map) {
        if (!map.containsKey(path)) {
            map.put(path, new TripleStore(this.metadataFileOf(path)));
        }
        return map.get(path);
    }

    private File metadataFileOf(String path) {
        return new File(this.storeFolder, path + "/" + ".metadata");
    }

    private Stream<TripleStore> loadSetMetadataSessions() {
        return this.files.parallelStream().filter(f -> f.getName().endsWith(SetSessionManager.extensionOf(Blob.Type.setMetadata))).map(TripleStore::new);
    }

    private void sealSetSessions() {
        List<SetSessionFileReader> readers = this.loadSetSessions();
        Set<Fingerprint> distinctChunks = this.distinctChunks(readers);
        Logger.trace((String)("Sets to seal " + distinctChunks.size()));
        distinctChunks.parallelStream().forEach(distinctChunk -> this.process((Fingerprint)distinctChunk, readers));
    }

    private void process(Fingerprint fingerprint, List<SetSessionFileReader> readers) {
        try {
            List<ZetStream> streams = this.chunksOf(readers, fingerprint);
            File setFile = this.filepath(fingerprint);
            File tempFile = File.createTempFile(fingerprint.toString(), ".zet");
            if (setFile.exists()) {
                streams.add((ZetStream)new ZetReader(setFile));
            }
            FSSetStore.write((ZetStream)new ZetStream.Union(streams), tempFile);
            Files.move(tempFile.toPath(), setFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private List<SetSessionFileReader> loadSetSessions() {
        return this.files.parallelStream().filter(f -> f.getName().endsWith(SetSessionManager.extensionOf(Blob.Type.set))).map(f -> {
            try {
                return new SetSessionFileReader((File)f);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }

    private File filepath(Fingerprint fingerprint) {
        File output = new File(this.storeFolder, fingerprint + ".zet");
        output.getParentFile().mkdirs();
        return output;
    }

    private List<ZetStream> chunksOf(List<SetSessionFileReader> readers, Fingerprint fingerprint) {
        return readers.stream().map(r -> r.chunks(fingerprint)).flatMap(Collection::stream).map(SetSessionFileReader.Chunk::stream).collect(Collectors.toList());
    }

    private Set<Fingerprint> distinctChunks(List<SetSessionFileReader> readers) {
        return readers.stream().map(SetSessionFileReader::chunks).flatMap(Collection::stream).map(SetSessionFileReader.Chunk::fingerprint).collect(Collectors.toSet());
    }
}

