/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimBuilder;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.core.Blob;
import io.intino.ness.core.fs.ExternalSorter;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.sessions.Fingerprint;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class EventSessionManager {
    public static void push(File stageFolder, Blob blob) {
        FS.copyInto(EventSessionManager.fileFor(blob, stageFolder), blob.inputStream());
    }

    private static File fileFor(Blob blob, File stageFolder) {
        return new File(stageFolder, blob.name() + ".inl");
    }

    public static void seal(File eventStageFolder, File eventStoreFolder) {
        FS.filesIn(eventStageFolder, f -> f.getName().endsWith(".inl")).forEach(f -> EventSessionManager.merge(EventSessionManager.sort(f), EventSessionManager.zimFile(eventStoreFolder, f)));
    }

    private static void merge(File sessionFile, File zimFile) {
        ZimReader stream = !zimFile.exists() ? EventSessionManager.reader(sessionFile) : ZimStream.Merge.of((ZimStream[])new ZimStream[]{EventSessionManager.reader(sessionFile), EventSessionManager.reader(zimFile)});
        File tempFile = EventSessionManager.tempFile();
        try {
            ZimBuilder builder = new ZimBuilder(tempFile);
            builder.put((ZimStream)stream);
            Files.move(tempFile.toPath(), zimFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static File tempFile() {
        try {
            return File.createTempFile("merge", ".zim");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("toMerge");
        }
    }

    private static ZimReader reader(File zimFile) {
        return new ZimReader(zimFile);
    }

    private static File zimFile(File eventStageFolder, File file) {
        File zimFile = new File(eventStageFolder, EventSessionManager.fingerprintOf(file).toString() + ".zim");
        zimFile.getParentFile().mkdirs();
        return zimFile;
    }

    private static Fingerprint fingerprintOf(File file) {
        return new Fingerprint(EventSessionManager.cleanedNameOf(file));
    }

    private static String cleanedNameOf(File file) {
        return file.getName().substring(0, file.getName().indexOf("#")).replace("-", "/").replace(".inl", "");
    }

    private static File sort(File file) {
        return new ExternalSorter(file).sort();
    }
}

