/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.zet.ZetStream;
import io.intino.ness.core.Datalake;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.fs.FSSetTank;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.stream.Stream;

public class FSSetStore
implements Datalake.SetStore {
    public static final String SetExtension = ".zet";
    public static final String MetadataFilename = ".metadata";
    private final File root;

    public FSSetStore(File root) {
        this.root = root;
        this.root.mkdirs();
    }

    public static void write(ZetStream stream, File file) throws IOException {
        file.getParentFile().mkdirs();
        DataOutputStream dataStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        while (stream.hasNext()) {
            dataStream.writeLong(stream.next());
        }
        dataStream.close();
    }

    @Override
    public Stream<Datalake.SetStore.Tank> tanks() {
        return FS.foldersIn(this.root).map(FSSetTank::new);
    }

    @Override
    public Datalake.SetStore.Tank tank(String name) {
        return new FSSetTank(new File(this.root, name));
    }
}

