/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.ness.core.Datalake;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.fs.FSMetadata;
import java.io.File;
import java.util.stream.Stream;

public class FSSet
implements Datalake.SetStore.Tank.Tub.Set {
    private final File file;

    public FSSet(File file) {
        this.file = file;
    }

    @Override
    public String name() {
        return this.file.getName().replace(".zet", "");
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.file.getParentFile().getName());
    }

    public File file() {
        return this.file;
    }

    @Override
    public int size() {
        return (int)(this.file.length() / 8L);
    }

    @Override
    public ZetStream content() {
        return new ZetReader(this.file);
    }

    @Override
    public Stream<Datalake.SetStore.Variable> variables() {
        return FSMetadata.of(this).map(a -> new Datalake.SetStore.Variable(a[1], a[2]));
    }

    @Override
    public Datalake.SetStore.Variable variable(String name) {
        return this.variables().filter(v -> v.name.equals(name)).findFirst().orElse(null);
    }
}

