/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.TripleStore;
import io.intino.ness.core.fs.FSSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class FSMetadata {
    private static Map<File, TripleStore> tripleStores = new HashMap<File, TripleStore>();

    public static Stream<String[]> of(FSSet set) {
        return FSMetadata.metadataTripleStoreOf(set).matches(new String[]{set.name()});
    }

    private static TripleStore metadataTripleStoreOf(FSSet set) {
        if (!FSMetadata.isOpenMetadataTripleStoreOf(set)) {
            FSMetadata.openMetadataTripleStoreOf(set);
        }
        return FSMetadata.getMetadataTripleStoreOf(set);
    }

    private static TripleStore getMetadataTripleStoreOf(FSSet set) {
        return tripleStores.get(FSMetadata.metadataFileOf(set));
    }

    private static boolean isOpenMetadataTripleStoreOf(FSSet set) {
        return tripleStores.containsKey(FSMetadata.metadataFileOf(set));
    }

    private static void openMetadataTripleStoreOf(FSSet set) {
        TripleStore tripleStore = new TripleStore(FSMetadata.metadataFileOf(set));
        tripleStores.put(tripleStore.file(), tripleStore);
    }

    private static File metadataFileOf(FSSet set) {
        return new File(FSMetadata.tubFolderOf(set.file()), ".metadata");
    }

    private static File tubFolderOf(File file) {
        return file.getParentFile();
    }
}

