/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.core.Datalake;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.fs.FS;
import java.io.File;
import java.util.function.Predicate;

public class FSEventTank
implements Datalake.EventStore.Tank {
    private final File root;

    FSEventTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public ZimStream content() {
        return ZimStream.Sequence.of((ZimStream[])this.zimStreams(t -> true));
    }

    @Override
    public ZimStream content(Predicate<Timetag> filter) {
        return ZimStream.Sequence.of((ZimStream[])this.zimStreams(filter));
    }

    private ZimStream[] zimStreams(Predicate<Timetag> filter) {
        return (ZimStream[])FS.filesIn(this.root, f -> f.getName().endsWith(".zim")).filter(f -> filter.test(this.timetagOf((File)f))).map(ZimReader::new).toArray(ZimStream[]::new);
    }

    private Timetag timetagOf(File file) {
        return new Timetag(file.getName().replace(".zim", ""));
    }
}

