/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ExternalSorter {
    private static final String INL = ".inl";
    private static String SEPARATOR = "\n\n";
    private final File tankDirectory;
    private final File tempDirectory;
    private File file;

    public ExternalSorter(File file) {
        this.file = file;
        this.tankDirectory = this.file.getParentFile();
        this.tempDirectory = new File(this.tankDirectory, this.file.getName().replace(INL, ""));
        this.tempDirectory.mkdirs();
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                ExternalSorter.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    public File sort() {
        try {
            ZimReader stream = new ZimReader(this.file);
            List<File> files = this.processBatches((ZimStream)stream);
            this.replace(this.sortAndMerge(files));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return this.file;
    }

    private List<File> processBatches(ZimStream stream) throws IOException {
        Message next;
        ArrayList<File> batches = new ArrayList<File>();
        ArrayList<Message> current = new ArrayList<Message>();
        int i = 0;
        int batch = 1;
        while ((next = stream.next()) != null) {
            current.add(next);
            if (++i != 50000) continue;
            batches.add(this.processBatch(current, batch++));
            i = 0;
        }
        if (!current.isEmpty()) {
            batches.add(this.processBatch(current, batch));
        }
        return batches;
    }

    private File processBatch(List<Message> messages, int batch) {
        File inlFile = new File(this.tempDirectory, batch + INL);
        try {
            messages.sort(this.messageComparator());
            Files.write(inlFile.toPath(), this.toString(messages).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            messages.clear();
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
        }
        return inlFile;
    }

    private String toString(List<Message> messages) {
        return messages.stream().map(Message::toString).collect(Collectors.joining(SEPARATOR));
    }

    private File sortAndMerge(List<File> files) {
        File temp = new File(this.tankDirectory, "temp.inl");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(temp));){
            List<TemporalFile> temporalFiles = files.stream().map(TemporalFile::new).collect(Collectors.toList());
            TemporalFile temporalFile = this.temporalFileWithOldestMessage(temporalFiles);
            while (this.tempsAreActive(temporalFiles)) {
                writer.write(temporalFile.message.toString() + SEPARATOR);
                temporalFile.next();
                temporalFile = this.temporalFileWithOldestMessage(temporalFiles);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return temp;
    }

    private void replace(File temp) {
        if (this.file.delete()) {
            temp.renameTo(this.file.getAbsoluteFile());
            ExternalSorter.deleteDirectory(this.tempDirectory);
        }
    }

    private TemporalFile temporalFileWithOldestMessage(List<TemporalFile> managers) {
        Instant reference = this.instantOf(managers.get(0).message);
        TemporalFile temporalFile = managers.get(0);
        for (int i = 1; i < managers.size(); ++i) {
            Instant comparable = this.instantOf(managers.get(i).message);
            if (!comparable.isBefore(reference)) continue;
            reference = comparable;
            temporalFile = managers.get(i);
        }
        return temporalFile;
    }

    private Comparator<Message> messageComparator() {
        return Comparator.comparing(m -> Instant.parse(this.tsOf((Message)m)));
    }

    private String tsOf(Message message) {
        return message.get("ts");
    }

    private Instant instantOf(Message message) {
        return message != null ? Instant.parse(this.tsOf(message)) : Instant.MAX;
    }

    private boolean tempsAreActive(List<TemporalFile> files) {
        for (TemporalFile file : files) {
            if (file.message == null) continue;
            return true;
        }
        return false;
    }

    static class TemporalFile {
        final String source;
        private ZimStream stream;
        private Message message;

        TemporalFile(File file) {
            this.source = file.getName();
            this.stream = new ZimReader(file);
            this.next();
        }

        private void next() {
            this.message = this.stream.next();
        }
    }
}

