/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core;

import io.intino.ness.core.Scale;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;

public class Timetag {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddhhmmss");
    private final String tag;

    public Timetag(LocalDateTime datetime, Scale scale) {
        this.tag = formatter.format(datetime).substring(0, this.sizeOf(scale));
    }

    public Timetag(String tag) {
        this.tag = tag;
    }

    public static Timetag of(String tag) {
        return new Timetag(tag);
    }

    public static Timetag of(LocalDateTime datetime, Scale scale) {
        return new Timetag(datetime, scale);
    }

    public LocalDateTime datetime() {
        return new Parser().parse();
    }

    public Scale scale() {
        return Scale.values()[this.precision()];
    }

    private int precision() {
        return (this.tag.length() - 4) / 2;
    }

    public String value() {
        return this.tag;
    }

    public String label() {
        String result = this.tag;
        for (int i = result.length(); i > 4; i -= 2) {
            result = result.substring(0, i - 2) + "-" + result.substring(i - 2);
        }
        return result;
    }

    public Timetag next() {
        return new Timetag(this.calculate(1), this.scale());
    }

    public Timetag previous() {
        return new Timetag(this.calculate(-1), this.scale());
    }

    public Iterable<Timetag> iterateTo(final Timetag to) {
        return () -> new Iterator<Timetag>(){
            Timetag current;
            {
                this.current = Timetag.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isAfter(to);
            }

            @Override
            public Timetag next() {
                Timetag result = this.current;
                this.current = this.current.next();
                return result;
            }
        };
    }

    private boolean isAfter(Timetag timetag) {
        return this.datetime().isAfter(timetag.datetime());
    }

    private boolean isBefore(Timetag timetag) {
        return this.datetime().isBefore(timetag.datetime());
    }

    private LocalDateTime calculate(int amount) {
        return this.scale().temporalUnit().addTo(this.datetime(), amount);
    }

    private int sizeOf(Scale scale) {
        return scale.ordinal() * 2 + 4;
    }

    public boolean equals(Object o) {
        return this.tag.equals(((Timetag)o).tag);
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag;
    }

    public class Parser {
        private final int precision;

        public Parser() {
            this.precision = Timetag.this.precision();
        }

        private LocalDateTime parse() {
            return LocalDateTime.of(this.year(), this.month(), this.day(), this.hour(), this.minute());
        }

        private int year() {
            return Integer.parseInt(Timetag.this.tag.substring(0, 4));
        }

        private int month() {
            return this.hasMonth() ? Integer.parseInt(Timetag.this.tag.substring(4, 6)) : 1;
        }

        private int day() {
            return this.hasDay() ? Integer.parseInt(Timetag.this.tag.substring(6, 8)) : 1;
        }

        private int hour() {
            return this.hasHour() ? Integer.parseInt(Timetag.this.tag.substring(8, 10)) : 0;
        }

        private int minute() {
            return this.hasMinute() ? Integer.parseInt(Timetag.this.tag.substring(10, 12)) : 0;
        }

        private boolean hasMonth() {
            return this.precision > 0;
        }

        private boolean hasDay() {
            return this.precision > 1;
        }

        private boolean hasHour() {
            return this.precision > 2;
        }

        private boolean hasMinute() {
            return this.precision > 3;
        }
    }
}

