/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.zet.ZetStream;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.core.Blob;
import io.intino.ness.core.Scale;
import io.intino.ness.core.Timetag;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Datalake {
    public Connection connection();

    public EventStore eventStore();

    public SetStore setStore();

    public void push(Stream<Blob> var1);

    public void seal();

    public static interface SetStore {
        public Stream<Tank> tanks();

        public Tank tank(String var1);

        default public Analytics analytics() {
            return new Analytics(this);
        }

        public static class Analytics {
            private SetStore setStore;

            public Analytics(SetStore setStore) {
                this.setStore = setStore;
            }

            public TankEvolution evolutionOf(String tank, int count) {
                return this.evolutionOf(this.setStore.tank(tank), count);
            }

            public TankHistogram histogramOf(String tank, TankHistogram.Axis axis) {
                return this.histogramOf(this.setStore.tank(tank), axis);
            }

            private TankEvolution evolutionOf(Tank tank, int count) {
                return new TankEvolution(tank.tubs(count));
            }

            private TankHistogram histogramOf(Tank tank, TankHistogram.Axis axis) {
                return new TankHistogram(axis, tank.last());
            }

            public static class TankEvolution {
                private Stream<Tank.Tub> tubs;

                public TankEvolution(Stream<Tank.Tub> tubs) {
                    this.tubs = tubs;
                }

                public Stream<Point> points() {
                    return this.points(s -> true);
                }

                public Stream<Point> points(SetFilter filter) {
                    return this.tubs.map(t -> this.point((Tank.Tub)t, filter));
                }

                private Point<Timetag> point(final Tank.Tub tub, final SetFilter filter) {
                    return new Point<Timetag>(){

                        @Override
                        public Timetag item() {
                            return tub.timetag();
                        }

                        @Override
                        public int size() {
                            return tub.sets(filter).mapToInt(Tank.Tub.Set::size).sum();
                        }
                    };
                }
            }

            public static class TankHistogram<T> {
                private final Axis<T> axis;
                private final Map<T, Integer> data;
                private final Tank.Tub tub;

                public TankHistogram(Axis axis, Tank.Tub tub) {
                    this.axis = axis;
                    this.data = new HashMap<T, Integer>();
                    this.tub = tub;
                }

                public Stream<Point> points() {
                    return this.points(Optional.ofNullable(this.tub).map(Tank.Tub::sets).orElse(Stream.empty()));
                }

                public Stream<Point> points(SetFilter filter) {
                    return this.points(Optional.ofNullable(this.tub).map(t -> t.sets(filter)).orElse(Stream.empty()));
                }

                private Stream<Point> points(Stream<Tank.Tub.Set> sets) {
                    this.fillDataWith(sets);
                    return this.data.keySet().stream().sorted(this.axis.sorting()).map(this::pointOf);
                }

                private void fillDataWith(Stream<Tank.Tub.Set> sets) {
                    this.data.clear();
                    sets.forEach(this::put);
                }

                private Point<T> pointOf(final T item) {
                    return new Point<T>(){

                        @Override
                        public T item() {
                            return item;
                        }

                        @Override
                        public int size() {
                            return this.sizeOf(item);
                        }
                    };
                }

                public void put(Tank.Tub.Set set) {
                    T item = this.axis.itemOf(set);
                    this.data.put(item, this.sizeOf(item) + this.sizeOf(set));
                }

                private Integer sizeOf(T item) {
                    return this.data.getOrDefault(item, 0);
                }

                private int sizeOf(Tank.Tub.Set set) {
                    return set.size();
                }

                public static interface Axis<T> {
                    public T itemOf(Tank.Tub.Set var1);

                    public Comparator<? super T> sorting();
                }
            }

            public static interface Point<T> {
                public T item();

                public int size();
            }
        }

        public static class Variable {
            public String name;
            public String value;

            public Variable(String name, Object value) {
                this.name = name;
                this.value = value.toString();
            }
        }

        public static interface SetFilter
        extends Predicate<Tank.Tub.Set> {
        }

        public static interface Tank {
            public String name();

            public Stream<Tub> tubs();

            public Tub first();

            public Tub last();

            public Tub on(Timetag var1);

            public Stream<Tub> tubs(int var1);

            public Stream<Tub> tubs(Timetag var1, Timetag var2);

            public static interface Tub {
                public Timetag timetag();

                public Scale scale();

                public Set set(String var1);

                public Stream<Set> sets();

                public Stream<Set> sets(SetFilter var1);

                public static interface Set {
                    public String name();

                    public Timetag timetag();

                    public int size();

                    public ZetStream content();

                    public Stream<Variable> variables();

                    public Variable variable(String var1);
                }
            }
        }
    }

    public static interface EventStore {
        public Stream<Tank> tanks();

        public Tank tank(String var1);

        public Reflow reflow(Reflow.Filter var1);

        public Subscription subscribe(Tank var1);

        public void unsubscribe(Tank var1);

        public static interface ReflowHandler {
            public void onBlock(int var1);

            public void onFinish(int var1);
        }

        public static interface MessageHandler {
            public void handle(Message var1);
        }

        public static interface Reflow {
            public void next(int var1, MessageHandler ... var2);

            public static interface Filter {
                public boolean allow(Tank var1);

                public boolean allow(Tank var1, Timetag var2);
            }
        }

        public static interface Subscription {
            default public void using(MessageHandler ... messageHandlers) {
                this.using((String)null, messageHandlers);
            }

            public void using(String var1, MessageHandler ... var2);
        }

        public static interface Tank {
            public String name();

            public ZimStream content();

            public ZimStream content(Predicate<Timetag> var1);
        }
    }

    public static interface Connection {
        public void connect(String ... var1);

        public void disconnect();
    }
}

