/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.pushnotifications;

import io.intino.monet.messaging.pushnotifications.PushNotification;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface PushNotificationServicePipeline {
    default public void onAfterSend(PushNotification notification, SendResult sendResult) {
    }

    default public void onError(Throwable e) {
    }

    public static class SendResponse {
        public final Map<String, String> info = new HashMap<String, String>();
        public final Exception error;

        public SendResponse(Exception error) {
            this.error = error;
        }

        public String toString() {
            return "SendResponse{info=" + this.info + ", error=" + this.error + "}";
        }
    }

    public static class SendResult {
        public final List<SendResponse> responses = new LinkedList<SendResponse>();

        public int successCount() {
            return (int)this.responses.stream().filter(r -> r.error != null).count();
        }

        public int failureCount() {
            return this.responses.size() - this.successCount();
        }

        public String toString() {
            return "SendResult{responses=" + this.responses + ", successCount=" + this.successCount() + ", failureCount=" + this.failureCount() + "}";
        }
    }

    public static class Default
    implements PushNotificationServicePipeline {
    }
}

