/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails.store;

import io.intino.monet.messaging.emails.EmailSignature;
import io.intino.monet.messaging.emails.store.EmailStore;
import io.intino.monet.messaging.emails.util.JsonPretty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class EmailBlacklist
implements EmailStore.Node {
    private transient EmailStore store;
    private final String recipient;
    private final List<String> blacklist;

    EmailBlacklist(String recipient) {
        this.recipient = Objects.requireNonNull(recipient);
        this.blacklist = new ArrayList<String>();
    }

    public String recipient() {
        return this.recipient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAll() {
        EmailBlacklist emailBlacklist = this;
        synchronized (emailBlacklist) {
            return List.copyOf(this.blacklist);
        }
    }

    public boolean add(EmailSignature signature) {
        return this.add(signature.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String signature) {
        EmailBlacklist emailBlacklist = this;
        synchronized (emailBlacklist) {
            if (this.blacklist.contains(signature)) {
                return false;
            }
            return this.blacklist.add(signature);
        }
    }

    public void remove(EmailSignature signature) {
        this.remove(signature.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String signature) {
        EmailBlacklist emailBlacklist = this;
        synchronized (emailBlacklist) {
            this.blacklist.remove(signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EmailBlacklist emailBlacklist = this;
        synchronized (emailBlacklist) {
            this.blacklist.clear();
        }
    }

    public boolean contains(String signature) {
        return this.contains(new EmailSignature(signature, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(EmailSignature signature) {
        EmailBlacklist emailBlacklist = this;
        synchronized (emailBlacklist) {
            return this.blacklist.stream().anyMatch(s -> new EmailSignature((String)s, new String[0]).contains(signature));
        }
    }

    public String toString() {
        return JsonPretty.toJson(this);
    }

    @Override
    public String id() {
        return this.recipient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        EmailBlacklist emailBlacklist = this;
        synchronized (emailBlacklist) {
            this.store.save(this);
        }
    }

    EmailBlacklist datamart(EmailStore store) {
        this.store = store;
        return this;
    }
}

