/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EmailSignature {
    public static final String SEPARATOR = "\\.";
    private String type;
    private List<String> subTypes;
    private String signature;

    public static EmailSignature wrap(String signature) {
        int sepIndex = signature.indexOf(SEPARATOR);
        if (sepIndex < 0) {
            return new EmailSignature(signature, new String[0]);
        }
        String type = signature.substring(0, sepIndex);
        String[] subtypes = signature.substring(sepIndex + 1).split(SEPARATOR);
        return new EmailSignature(type, subtypes);
    }

    public EmailSignature(String type, String ... subTypes) {
        this.init(type, subTypes);
    }

    public String get() {
        return this.signature;
    }

    private void init(String type, String ... subTypes) {
        this.type = Objects.requireNonNull(type);
        this.checkSubTypes(subTypes);
        this.subTypes = this.empty(subTypes) ? Collections.emptyList() : Arrays.asList(subTypes);
        this.signature = this.empty(subTypes) ? type : type + SEPARATOR + String.join((CharSequence)SEPARATOR, subTypes);
    }

    private void checkSubTypes(String[] subTypes) {
        if (Arrays.stream(subTypes).anyMatch(s -> s == null || s.isBlank())) {
            throw new IllegalArgumentException("Subtypes cannot be null nor blank");
        }
    }

    private boolean empty(String[] subTypes) {
        return subTypes == null || subTypes.length == 0;
    }

    public String type() {
        return this.type;
    }

    public boolean hasSubtype(String subType) {
        return this.subTypes.stream().anyMatch(s -> s.equals(subType));
    }

    public String subType(int index) {
        return index < this.subTypes.size() ? this.subTypes.get(index) : null;
    }

    public List<String> subTypes() {
        return Collections.unmodifiableList(this.subTypes);
    }

    public boolean contains(EmailSignature other) {
        return other.signature.contains(this.signature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailSignature that = (EmailSignature)o;
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }

    public String toString() {
        return this.signature;
    }
}

