/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails;

import io.intino.alexandria.Json;
import io.intino.monet.messaging.Recipient;
import io.intino.monet.messaging.emails.EmailSignature;
import java.io.File;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Email {
    private final EmailSignature signature;
    private String subject;
    private final Body body = new Body();
    private final Recipients recipients = new Recipients();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private Instant ts = Instant.now();

    public Email(EmailSignature signature) {
        this.signature = signature;
    }

    public EmailSignature signature() {
        return this.signature;
    }

    public String subject() {
        return this.subject;
    }

    public Email subject(String subject) {
        this.subject = subject;
        return this;
    }

    public Body body() {
        return this.body;
    }

    public Recipients recipients() {
        return this.recipients;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Email putProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public Instant ts() {
        return this.ts;
    }

    public Email ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals(this.subject, email.subject) && Objects.equals(this.body, email.body) && Objects.equals(this.recipients, email.recipients);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.body, this.recipients);
    }

    public String toString() {
        return Json.toString((Object)this);
    }

    public class Body {
        private String text = "";
        private List<File> attachments = new LinkedList<File>();
        private String contentType = "text/html;charset=utf-8";

        public String text() {
            return this.text;
        }

        public Email text(String text) {
            this.text = text;
            return Email.this;
        }

        public List<File> attachments() {
            return this.attachments;
        }

        public Email attachments(List<File> attachments) {
            this.attachments = attachments;
            return Email.this;
        }

        public String contentType() {
            return this.contentType;
        }

        public Email contentType(String contentType) {
            this.contentType = contentType;
            return Email.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Body body = (Body)o;
            return Objects.equals(this.text, body.text) && Objects.equals(this.attachments, body.attachments) && Objects.equals(this.contentType, body.contentType);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.attachments, this.contentType);
        }

        public String toString() {
            return "Body{text='" + this.text + "', attachments=" + this.attachments + ", contentType='" + this.contentType + "'}";
        }
    }

    public class Recipients {
        private Recipient to;
        private List<Recipient> cc = new LinkedList<Recipient>();
        private List<Recipient> bcc = new LinkedList<Recipient>();

        public Recipient to() {
            return this.to;
        }

        public Email to(Recipient to) {
            this.to = to;
            return Email.this;
        }

        public List<Recipient> cc() {
            return this.cc;
        }

        public Email cc(List<Recipient> cc) {
            this.cc = cc;
            return Email.this;
        }

        public List<Recipient> bcc() {
            return this.bcc;
        }

        public Email bcc(List<Recipient> bcc) {
            this.bcc = bcc;
            return Email.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Recipients that = (Recipients)o;
            return Objects.equals(this.to, that.to) && Objects.equals(this.cc, that.cc) && Objects.equals(this.bcc, that.bcc);
        }

        public int hashCode() {
            return Objects.hash(this.to, this.cc, this.bcc);
        }

        public String toString() {
            return "Recipients{to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + "}";
        }
    }
}

