/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging;

import io.intino.alexandria.Json;
import io.intino.monet.messaging.Recipient;
import io.intino.monet.messaging.emails.util.JsonPretty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RecipientsStore {
    private final File file;
    private final Map<String, Recipient> recipients;

    public RecipientsStore(File directory) {
        this.file = new File(directory, "recipients.json");
        this.file.getParentFile().mkdirs();
        this.recipients = new ConcurrentHashMap<String, Recipient>();
        this.load();
    }

    public Recipient get(String email) {
        return this.recipients.get(email);
    }

    public void add(Recipient recipient) {
        this.recipients.put(recipient.email(), recipient);
    }

    public void remove(String email) {
        this.recipients.remove(email);
    }

    public boolean exists(String email) {
        return this.recipients.containsKey(email);
    }

    public List<Recipient> getAll() {
        return new ArrayList<Recipient>(this.recipients.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        this.file.getParentFile().mkdirs();
        RecipientsStore recipientsStore = this;
        synchronized (recipientsStore) {
            try {
                Files.writeString(this.file.toPath(), (CharSequence)JsonPretty.toJson(this.recipients.values()), StandardOpenOption.CREATE);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        RecipientsStore recipientsStore = this;
        synchronized (recipientsStore) {
            this.recipients.clear();
            try {
                Recipient[] recipientsFromFile = this.file.exists() ? (Recipient[])Json.fromString((String)this.read(this.file), Recipient[].class) : new Recipient[]{};
                Arrays.stream(recipientsFromFile).forEach(r -> this.recipients.put(r.email(), (Recipient)r));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String read(File file) throws IOException {
        return Files.readString(file.toPath());
    }
}

