/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging;

import io.intino.monet.messaging.Recipient;
import io.intino.monet.messaging.emails.util.JsonPretty;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;

public class Notification {
    private String id;
    private String type;
    private Channel channel;
    private String language;
    private Recipient recipient;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Map<String, Attachment> attachments = new LinkedHashMap<String, Attachment>();
    private Instant ts;

    public String id() {
        return this.id;
    }

    public Notification id(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public Notification type(String type) {
        this.type = type;
        return this;
    }

    public Channel channel() {
        return this.channel;
    }

    public Notification channel(Channel channel) {
        this.channel = channel;
        return this;
    }

    public String language() {
        return this.language;
    }

    public Notification language(String language) {
        this.language = language;
        return this;
    }

    public Recipient recipient() {
        return this.recipient;
    }

    public Notification recipient(Recipient recipient) {
        this.recipient = recipient;
        return this;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Notification addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Map<String, Attachment> attachments() {
        return this.attachments;
    }

    public Notification addAttachment(String name, Attachment attachment) {
        this.attachments.put(name, attachment);
        return this;
    }

    public Instant ts() {
        return this.ts;
    }

    public Notification ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    public String toString() {
        return JsonPretty.toJson(this);
    }

    public static class Attachment {
        public final Type type;
        public final String value;

        public Attachment(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public static enum Type {
            Text,
            File;

        }
    }

    public static enum Channel {
        Email,
        Push;

    }
}

