package io.intino.monet.messaging.pushnotifications.backends.firebase;

import com.google.firebase.messaging.Message;
import io.intino.monet.messaging.emails.util.JsonPretty;
import io.intino.monet.messaging.pushnotifications.PushNotification;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FirebaseMessageBuilder {

    public static Message build(PushNotification n) {
        return buildMessage(n.recipient().device().token(), map(n), n.extraData());
    }

    private static Message buildMessage(String deviceToken, com.google.firebase.messaging.Notification notification, List<PushNotification.ExtraData> extraData) {
        return Message.builder()
                .setToken(deviceToken)
                .setNotification(notification)
                .putAllData(dataFrom(extraData))
                .build();
    }

    private static Map<String, String> dataFrom(List<PushNotification.ExtraData> data) {
        if (data == null) return new HashMap<>();
        return data.stream().collect(Collectors.toMap(PushNotification.ExtraData::key, PushNotification.ExtraData::value, (d1, d2) -> d1));
    }

    private static com.google.firebase.messaging.Notification map(PushNotification notification) {
        return com.google.firebase.messaging.Notification.builder()
                .setBody(safe(notification.body()))
                .setTitle(safe(notification.title()))
                .build();
    }

    private static String safe(String value) {
        return value == null ? "" : value;
    }
}
