package io.intino.monet.messaging.pushnotifications.backends;

import io.intino.monet.messaging.Recipient.Device;
import io.intino.monet.messaging.pushnotifications.PushNotificationServicePipeline;

import java.util.List;

import static java.util.Objects.requireNonNull;

public interface PushNotificationsBackendManager {

    void start(PushNotificationServicePipeline notificationPipeline);

    PushNotificationsBackend backendOf(Device device);

    class Default implements PushNotificationsBackendManager {

        private final List<PushNotificationsBackend> backends;

        public Default(List<PushNotificationsBackend> backends) {
            this.backends = requireNonNull(backends);
        }

        @Override
        public void start(PushNotificationServicePipeline notificationPipeline) {
            backends.forEach(backend -> backend.start(notificationPipeline));
        }

        @Override
        public PushNotificationsBackend backendOf(Device device) {
            if(device.googleServices()) return findBackend("Firebase");
            if(isHuaweiOS(device.os())) return findBackend("Huawei");
            return null;
        }

        private boolean isHuaweiOS(String os) {
            // TODO
            return false;
        }

        protected PushNotificationsBackend findBackend(String name) {
            return backends.stream().filter(b -> name.equalsIgnoreCase(b.name())).findFirst().orElse(null);
        }
    }
}
