package io.intino.monet.messaging.pushnotifications.backends;

import io.intino.monet.messaging.pushnotifications.PushNotification;
import io.intino.monet.messaging.pushnotifications.PushNotificationServicePipeline;

import static java.util.Objects.requireNonNull;

public abstract class PushNotificationsBackend {

    private final String name;
    private PushNotificationServicePipeline notificationPipeline;

    public PushNotificationsBackend(String name) {
        this.name = requireNonNull(name);
    }

    public final void start(PushNotificationServicePipeline notificationPipeline) {
        this.notificationPipeline = requireNonNull(notificationPipeline);
        doStart();
    }

    protected abstract void doStart();

    public abstract void sendNotification(PushNotification notification);

    public String name() {
        return name;
    }

    public PushNotificationServicePipeline notificationPipeline() {
        return notificationPipeline;
    }
}
